/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.security.vault.external.hashicorp;

import com.bettercloud.vault.SslConfig;
import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.api.Logical;
import com.bettercloud.vault.rest.RestException;
import java.io.File;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.SynapseConfiguration;
import org.wso2.carbon.mediation.security.vault.SecureVaultCacheContext;
import org.wso2.carbon.mediation.security.vault.external.ExternalVaultConfigLoader;
import org.wso2.carbon.mediation.security.vault.external.ExternalVaultException;
import org.wso2.carbon.mediation.security.vault.external.ExternalVaultLookupHandler;
import org.wso2.carbon.utils.CarbonUtils;

public class HashiCorpVaultLookupHandlerImpl
implements ExternalVaultLookupHandler {
    private static Log log = LogFactory.getLog(HashiCorpVaultLookupHandlerImpl.class);
    private static HashiCorpVaultLookupHandlerImpl instance = null;
    private Vault vaultConnection;
    private VaultConfig vaultConfig;
    private String cachableDuration = "15000";
    private String engineVersion = "2";
    private String vaultNamespace;
    private String currentAuthToken;
    private Calendar tokenExpiration;
    private String secretId;
    private String roleId;
    private boolean isAppRolePullAuthentication = true;
    private String currentAliasPassword;

    private HashiCorpVaultLookupHandlerImpl() throws ExternalVaultException {
        try {
            this.initialize();
        }
        catch (ExternalVaultException e) {
            throw new ExternalVaultException("Error while initializing the secure vault configs", e);
        }
    }

    public static HashiCorpVaultLookupHandlerImpl getDefaultSecurityService() throws ExternalVaultException {
        if (instance == null) {
            instance = new HashiCorpVaultLookupHandlerImpl();
        }
        return instance;
    }

    @Override
    public String name() {
        return "hashicorp";
    }

    private void initialize() throws ExternalVaultException {
        Map<String, String> parameters = ExternalVaultConfigLoader.getVaultParameters(this.name());
        if (parameters == null || parameters.size() < 2) {
            throw new ExternalVaultException("Required configurations of the " + this.name() + " secure vault can not found");
        }
        if (!parameters.containsKey("address")) {
            throw new ExternalVaultException("address parameter can not found in " + this.name() + " secure vault configurations");
        }
        if (!(parameters.containsKey("rootToken") || parameters.containsKey("roleId") && parameters.containsKey("secretId"))) {
            throw new ExternalVaultException("Static RootToken parameter or RoleID and SecretID parameters can not found in " + this.name() + " secure vault configurations");
        }
        this.processHashiCorpParameters(parameters);
        try {
            this.vaultConfig = this.createHashiCorpVaultConfig(parameters);
            this.vaultConnection = new Vault(this.vaultConfig);
            if (!parameters.containsKey("rootToken") && parameters.containsKey("roleId") && parameters.containsKey("secretId")) {
                this.authenticateHashiCorpVault();
            }
        }
        catch (VaultException e) {
            if (e.getCause() instanceof RestException) {
                throw new ExternalVaultException("Error in connecting to HashiCorp vault. Vault address: " + parameters.get("address"), e);
            }
            throw new ExternalVaultException("Error while connecting the HashiCorp vault", e);
        }
    }

    private boolean authenticateHashiCorpVault() throws VaultException {
        boolean isTokenExpired = false;
        if (this.isTokenTTLExpired()) {
            try {
                this.currentAuthToken = this.vaultConnection.auth().loginByAppRole(this.roleId, this.secretId).getAuthClientToken();
                this.vaultConfig.token(this.currentAuthToken).build();
            }
            catch (VaultException e) {
                throw new VaultException("Error while generating a new client token using the roleId and secretId. Please check the secret_id_num_uses parameter value for the troubleshooting purposes.");
            }
            log.debug((Object)"Login to Vault using AppRole/SecretID successful");
            this.getTTLExpiryOfCurrentToken(this.vaultConnection);
            isTokenExpired = true;
        } else {
            this.vaultConfig.token(this.currentAuthToken).build();
        }
        return isTokenExpired;
    }

    private boolean isTokenTTLExpired() {
        if (this.tokenExpiration == null || this.currentAuthToken == null) {
            return true;
        }
        boolean isTokenTTLExpired = true;
        Calendar now = Calendar.getInstance();
        long timeDiffInMillis = now.getTimeInMillis() - this.tokenExpiration.getTimeInMillis();
        if (timeDiffInMillis < -2000L) {
            isTokenTTLExpired = false;
            log.debug((Object)"current client token is still valid.");
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Auth token has to be re-issued" + timeDiffInMillis));
        }
        return isTokenTTLExpired;
    }

    private void getTTLExpiryOfCurrentToken(Vault vault) {
        int tokenTTL = 0;
        try {
            tokenTTL = (int)vault.auth().lookupSelf().getTTL();
        }
        catch (VaultException e) {
            log.warn((Object)"Could not determine token expiration. Check if token is allowed to access auth/token/lookup-self. Assuming token TTL is expired.", (Throwable)e);
        }
        this.tokenExpiration = Calendar.getInstance();
        this.tokenExpiration.add(13, tokenTTL);
    }

    private void processHashiCorpParameters(Map<String, String> parameters) {
        String keyStoreFilePath;
        String trustStoreFilePath;
        if (parameters.containsKey("cacheableDuration") && !parameters.get("cacheableDuration").isEmpty() && parameters.get("cacheableDuration").matches("[0-9]+")) {
            this.cachableDuration = parameters.get("cacheableDuration");
        }
        if (parameters.containsKey("engineVersion") && !parameters.get("engineVersion").isEmpty() && parameters.get("engineVersion").matches("[0-9]+")) {
            this.engineVersion = parameters.get("engineVersion");
        }
        if (parameters.containsKey("namespace") && !parameters.get("namespace").isEmpty()) {
            this.vaultNamespace = parameters.get("namespace");
        }
        if (parameters.containsKey("trustStoreFile") && (trustStoreFilePath = parameters.get("trustStoreFile")).startsWith("${carbon.home}")) {
            trustStoreFilePath = trustStoreFilePath.replace("${carbon.home}", CarbonUtils.getCarbonHome());
            parameters.put("trustStoreFile", trustStoreFilePath);
        }
        if (parameters.containsKey("keyStoreFile") && (keyStoreFilePath = parameters.get("keyStoreFile")).startsWith("${carbon.home}")) {
            keyStoreFilePath = keyStoreFilePath.replace("${carbon.home}", CarbonUtils.getCarbonHome());
            parameters.put("keyStoreFile", keyStoreFilePath);
        }
        if (parameters.containsKey("secretId")) {
            this.secretId = parameters.get("secretId");
        }
        if (parameters.containsKey("roleId")) {
            this.roleId = parameters.get("roleId");
        }
    }

    private VaultConfig createHashiCorpVaultConfig(Map<String, String> parameters) throws VaultException, ExternalVaultException {
        VaultConfig config = new VaultConfig().address(parameters.get("address"));
        if (parameters.get("address").startsWith("https")) {
            SslConfig sslConfig = new SslConfig();
            if (!parameters.containsKey("trustStoreFile") && !parameters.containsKey("keyStoreFile")) {
                throw new ExternalVaultException("trustStoreFile parameter or trustStoreFileparameter can not found in " + this.name() + " secure vault configurations");
            }
            if (parameters.containsKey("trustStoreFile")) {
                sslConfig = sslConfig.trustStoreFile(new File(parameters.get("trustStoreFile")));
            }
            if (parameters.containsKey("keyStoreFile") && parameters.containsKey("keyStorePassword")) {
                sslConfig = sslConfig.keyStoreFile(new File(parameters.get("keyStoreFile")), parameters.get("keyStorePassword"));
            } else {
                if (parameters.containsKey("keyStoreFile") && !parameters.containsKey("keyStorePassword")) {
                    throw new ExternalVaultException("keyStorePassword parameter can not found in " + this.name() + " secure vault configurations");
                }
                if (!parameters.containsKey("keyStoreFile") && parameters.containsKey("keyStorePassword")) {
                    throw new ExternalVaultException("keyStoreFile parameter can not found in " + this.name() + " secure vault configurations");
                }
            }
            config = config.sslConfig(sslConfig);
        }
        config = config.engineVersion(Integer.valueOf(Integer.parseInt(this.engineVersion)));
        if (parameters.containsKey("rootToken")) {
            config = config.token(parameters.get("rootToken"));
            this.isAppRolePullAuthentication = false;
        }
        if (this.vaultNamespace != null) {
            config = config.nameSpace(this.vaultNamespace);
        }
        return config.build();
    }

    @Override
    public String evaluate(Map<String, String> vaultParameters, MessageContext synCtx) throws ExternalVaultException {
        SynapseConfiguration synapseConfiguration = synCtx.getConfiguration();
        Map decryptedCacheMap = synapseConfiguration.getDecryptedCacheMap();
        String pathParameter = vaultParameters.get("path-parameter");
        String fieldParameter = vaultParameters.get("field-parameter");
        String aliasPassword = pathParameter + "-" + fieldParameter;
        String namespaceForEvaluation = null;
        if (vaultParameters.containsKey("vault-namespace")) {
            aliasPassword = vaultParameters.get("vault-namespace") + "-" + aliasPassword;
            namespaceForEvaluation = vaultParameters.get("vault-namespace");
        } else if (this.vaultNamespace != null) {
            aliasPassword = this.vaultNamespace + "-" + aliasPassword;
            namespaceForEvaluation = this.vaultNamespace;
        }
        if (decryptedCacheMap.containsKey(aliasPassword)) {
            SecureVaultCacheContext cacheContext = (SecureVaultCacheContext)decryptedCacheMap.get(aliasPassword);
            if (cacheContext != null) {
                long cacheTime = Long.parseLong(this.cachableDuration);
                if (cacheContext.getDateTime().getTime() + cacheTime >= System.currentTimeMillis()) {
                    return cacheContext.getDecryptedValue();
                }
                decryptedCacheMap.remove(aliasPassword);
                return this.vaultLookup(namespaceForEvaluation, pathParameter, fieldParameter, decryptedCacheMap);
            }
            return this.vaultLookup(namespaceForEvaluation, pathParameter, fieldParameter, decryptedCacheMap);
        }
        return this.vaultLookup(namespaceForEvaluation, pathParameter, fieldParameter, decryptedCacheMap);
    }

    private synchronized String vaultLookup(String namespace, String pathParameter, String fieldParameter, Map<String, Object> decryptedCacheMap) throws ExternalVaultException {
        SecureVaultCacheContext cacheContext;
        String decryptedValue;
        String errorMsg;
        block8: {
            this.currentAliasPassword = pathParameter + "-" + fieldParameter;
            errorMsg = "Cannot read the vault secret from the HashiCorp vault. " + (namespace != null ? "Namespace: " + namespace + ", " : "") + "Path: " + pathParameter + ", Field: " + fieldParameter;
            decryptedValue = null;
            try {
                decryptedValue = this.resolveHashiCorpSecret(namespace, pathParameter, fieldParameter);
            }
            catch (VaultException e) {
                if (this.isAppRolePullAuthentication) break block8;
                throw new ExternalVaultException(errorMsg, e);
            }
        }
        if (decryptedValue == null && this.isAppRolePullAuthentication) {
            try {
                if (this.authenticateHashiCorpVault()) {
                    log.warn((Object)"Generating a new client token since the current token is expired");
                    decryptedValue = this.resolveHashiCorpSecret(namespace, pathParameter, fieldParameter);
                }
            }
            catch (VaultException e) {
                throw new ExternalVaultException(errorMsg, e);
            }
        }
        if (decryptedCacheMap == null || decryptedValue == null) {
            log.warn((Object)("Cannot find a vault secret from the HashiCorp vault for, " + (namespace != null ? "Namespace: " + namespace + ", " : "") + "Path: " + pathParameter + ", Field: " + fieldParameter));
            return null;
        }
        if (decryptedValue.isEmpty() && (cacheContext = (SecureVaultCacheContext)decryptedCacheMap.get(this.currentAliasPassword)) != null) {
            return cacheContext.getDecryptedValue();
        }
        decryptedCacheMap.put(this.currentAliasPassword, new SecureVaultCacheContext(Calendar.getInstance().getTime(), decryptedValue));
        return decryptedValue;
    }

    private String resolveHashiCorpSecret(String namespace, String pathParameter, String fieldParameter) throws VaultException {
        Logical logical = this.vaultConnection.logical();
        if (namespace != null) {
            logical = logical.withNameSpace(namespace);
            this.currentAliasPassword = namespace + "-" + this.currentAliasPassword;
        }
        return (String)logical.read(pathParameter).getData().get(fieldParameter);
    }

    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }
}

