/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.security.vault.external.hashicorp;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;
import org.wso2.carbon.mediation.security.vault.external.hashicorp.HashiCorpVaultLookupHandlerImpl;

public class HashiCorpVaultLookupFunction
implements Function {
    private static final Log log = LogFactory.getLog(HashiCorpVaultLookupFunction.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private static final String NULL_STRING = "";
    private final MessageContext synCtx;

    public HashiCorpVaultLookupFunction(MessageContext synCtx) {
        this.synCtx = synCtx;
    }

    public Object call(Context context, List args) throws FunctionCallException {
        boolean traceOrDebugOn;
        boolean traceOn = this.synCtx.getTracingState() == 1;
        boolean bl = traceOrDebugOn = traceOn || log.isDebugEnabled();
        if (args == null || args.isEmpty()) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "vault alias for lookup is not specified");
            }
            return NULL_STRING;
        }
        if (args.size() != 2 && args.size() != 3) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "vault path and field values for lookup is not specified");
            }
            return NULL_STRING;
        }
        HashMap<String, String> vaultParameterMap = new HashMap<String, String>();
        if (args.size() == 3) {
            vaultParameterMap.put("vault-namespace", StringFunction.evaluate(args.get(0), (Navigator)context.getNavigator()));
            vaultParameterMap.put("path-parameter", StringFunction.evaluate(args.get(1), (Navigator)context.getNavigator()));
            vaultParameterMap.put("field-parameter", StringFunction.evaluate(args.get(2), (Navigator)context.getNavigator()));
        } else {
            vaultParameterMap.put("path-parameter", StringFunction.evaluate(args.get(0), (Navigator)context.getNavigator()));
            vaultParameterMap.put("field-parameter", StringFunction.evaluate(args.get(1), (Navigator)context.getNavigator()));
        }
        try {
            HashiCorpVaultLookupHandlerImpl mediationSecurity = HashiCorpVaultLookupHandlerImpl.getDefaultSecurityService();
            return mediationSecurity.evaluate(vaultParameterMap, this.synCtx);
        }
        catch (Exception msg) {
            throw new FunctionCallException((Throwable)msg);
        }
    }

    private void traceOrDebug(boolean traceOn, String msg) {
        if (traceOn) {
            trace.info((Object)msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)msg);
        }
    }
}

