/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.security.vault.external;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.security.vault.external.ExternalVaultException;
import org.wso2.carbon.securevault.SecretCallbackHandlerService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class ExternalVaultConfigLoader {
    private static Log log = LogFactory.getLog(ExternalVaultConfigLoader.class);
    private static final QName ROOT_Q = new QName("secureVaults");
    private static final QName VAULT_NAME_Q = new QName("name");
    private static final String EXTERNAL_VAULTS = "external-vaults.xml";
    private static SecretResolver secretResolver;
    private static Map<String, Map<String, String>> externalVaultMap;

    private ExternalVaultConfigLoader() {
    }

    public static void loadExternalVaultConfigs(SecretCallbackHandlerService secretCallbackHandlerService) throws ExternalVaultException {
        String vaultConfigFilePath = CarbonUtils.getCarbonSecurityConfigDirPath() + File.separator + EXTERNAL_VAULTS;
        OMElement vaultConfig = null;
        try {
            File externalVaultFile = new File(vaultConfigFilePath);
            if (externalVaultFile.exists()) {
                String configsFileAsString = FileUtils.readFileToString((File)externalVaultFile);
                vaultConfig = AXIOMUtil.stringToOM((String)configsFileAsString);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No such file: external-vaults.xml in location " + vaultConfigFilePath));
            }
        }
        catch (IOException | XMLStreamException e) {
            log.error((Object)("Error while reading the external-vaults.xml file in location + " + vaultConfigFilePath), (Throwable)e);
        }
        if (vaultConfig != null) {
            if (!ROOT_Q.equals(vaultConfig.getQName())) {
                throw new ExternalVaultException("Invalid external secure vault configuration file");
            }
            ExternalVaultConfigLoader.setSecretResolver(vaultConfig);
            Iterator vaultIterator = vaultConfig.getChildElements();
            while (vaultIterator.hasNext()) {
                OMElement vaultNode = (OMElement)vaultIterator.next();
                if (vaultNode == null) continue;
                Iterator vaultNodeIterator = vaultNode.getChildElements();
                HashMap<String, String> childParameters = new HashMap<String, String>();
                while (vaultNodeIterator.hasNext()) {
                    OMElement vaultChildNode = (OMElement)vaultNodeIterator.next();
                    if (vaultChildNode == null) continue;
                    String resolvedValue = MiscellaneousUtil.resolve((OMElement)vaultChildNode, (SecretResolver)secretResolver);
                    childParameters.put(vaultChildNode.getAttributeValue(VAULT_NAME_Q), resolvedValue);
                }
                externalVaultMap.put(vaultNode.getAttributeValue(VAULT_NAME_Q), childParameters);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"external-vaults.xml file external secure vault configurations loaded to the map");
            }
        }
    }

    public static Map<String, String> getVaultParameters(String name) {
        return externalVaultMap.get(name);
    }

    private static void setSecretResolver(OMElement rootElement) {
        secretResolver = SecretResolverFactory.create((OMElement)rootElement, (boolean)true);
    }

    static {
        externalVaultMap = new HashMap<String, Map<String, String>>();
    }
}

