/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.security.vault;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.mediation.security.vault.MediationSecurityAdminService;
import org.wso2.carbon.mediation.security.vault.SecureVaultLookupHandlerImpl;
import org.wso2.carbon.mediation.security.vault.SecurityServiceHolder;
import org.wso2.carbon.mediation.security.vault.external.ExternalVaultConfigLoader;
import org.wso2.carbon.mediation.security.vault.external.ExternalVaultException;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.securevault.SecretCallbackHandlerService;

@Component(name="mediation.security", immediate=true)
public class SynapseSecurityerviceComponent {
    private static Log log = LogFactory.getLog(SynapseSecurityerviceComponent.class);
    private static SecretCallbackHandlerService secretCallbackHandlerService;

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Synapse mediation security component activated");
        }
        BundleContext bundleCtx = ctxt.getBundleContext();
        bundleCtx.registerService(MediationSecurityAdminService.class.getName(), (Object)new MediationSecurityAdminService(), null);
        try {
            SecureVaultLookupHandlerImpl.getDefaultSecurityService();
            ExternalVaultConfigLoader.loadExternalVaultConfigs(secretCallbackHandlerService);
        }
        catch (RegistryException e) {
            log.error((Object)"Error while activating secure vault registry component", (Throwable)e);
        }
        catch (ExternalVaultException e) {
            log.error((Object)"Error while loading external secure vault configurations", (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the ESB initialization process");
        }
        SecurityServiceHolder.getInstance().setRegistryService(regService);
    }

    protected void unsetRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the ESB environment");
        }
        SecurityServiceHolder.getInstance().setRegistryService(null);
    }

    @Reference(name="server.configuration", service=ServerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfigurationService")
    protected void setServerConfigurationService(ServerConfigurationService serverConfiguration) {
        SecurityServiceHolder.getInstance().setServerConfigurationService(serverConfiguration);
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfiguration) {
        SecurityServiceHolder.getInstance().setServerConfigurationService(null);
    }

    @Reference(name="secret.callback.handler.service", service=SecretCallbackHandlerService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSecretCallbackHandlerService")
    protected void setSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SecretCallbackHandlerService bound to the ESB initialization process");
        }
        SynapseSecurityerviceComponent.secretCallbackHandlerService = secretCallbackHandlerService;
    }

    protected void unsetSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SecretCallbackHandlerService unbound from the ESB environment");
        }
        SynapseSecurityerviceComponent.secretCallbackHandlerService = null;
    }
}

