/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.security.vault;

import java.util.Calendar;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.SynapseConfiguration;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.mediation.security.vault.SecretCipherHander;
import org.wso2.carbon.mediation.security.vault.SecretSrcData;
import org.wso2.carbon.mediation.security.vault.SecureVaultCacheContext;
import org.wso2.carbon.mediation.security.vault.SecureVaultLookupHandler;
import org.wso2.carbon.mediation.security.vault.SecurityServiceHolder;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class SecureVaultLookupHandlerImpl
implements SecureVaultLookupHandler {
    private static Log log = LogFactory.getLog(SecureVaultLookupHandlerImpl.class);
    private static SecureVaultLookupHandlerImpl instance = null;
    private ServerConfigurationService serverConfigService;
    private RegistryService registryService;
    UserRegistry registry = null;
    Object decryptlockObj = new Object();

    private SecureVaultLookupHandlerImpl(ServerConfigurationService serverConfigurationService, RegistryService registryService) throws RegistryException {
        this.serverConfigService = serverConfigurationService;
        this.registryService = registryService;
        try {
            this.init();
        }
        catch (RegistryException e) {
            throw new RegistryException("Error while initializing the registry", (Throwable)e);
        }
    }

    public static SecureVaultLookupHandlerImpl getDefaultSecurityService() throws RegistryException {
        return SecureVaultLookupHandlerImpl.getDefaultSecurityService(SecurityServiceHolder.getInstance().getServerConfigurationService(), SecurityServiceHolder.getInstance().getRegistryService());
    }

    private static SecureVaultLookupHandlerImpl getDefaultSecurityService(ServerConfigurationService serverConfigurationService, RegistryService registryService) throws RegistryException {
        if (instance == null) {
            instance = new SecureVaultLookupHandlerImpl(serverConfigurationService, registryService);
        }
        return instance;
    }

    private void init() throws RegistryException {
        try {
            this.registry = this.registryService.getConfigSystemRegistry();
            this.initRegistryRepo();
        }
        catch (RegistryException e) {
            throw new RegistryException("Error while initializing the registry", (Throwable)e);
        }
    }

    private void initRegistryRepo() throws RegistryException {
        if (!this.isRepoExists()) {
            Collection secureVaultCollection = this.registry.newCollection();
            this.registry.put("/repository/components/secure-vault", (Resource)secureVaultCollection);
        }
    }

    protected boolean isRepoExists() {
        try {
            this.registry.get("/repository/components/secure-vault");
        }
        catch (RegistryException e) {
            return false;
        }
        return true;
    }

    public String getProviderClass() {
        return this.getClass().getName();
    }

    @Override
    public String evaluate(String aliasPasword, SecretSrcData secretSrcData, MessageContext synCtx) throws RegistryException {
        SynapseConfiguration synapseConfiguration = synCtx.getConfiguration();
        Map decryptedCacheMap = synapseConfiguration.getDecryptedCacheMap();
        if (decryptedCacheMap.containsKey(aliasPasword)) {
            SecureVaultCacheContext cacheContext = (SecureVaultCacheContext)decryptedCacheMap.get(aliasPasword);
            if (cacheContext != null) {
                long cacheTime;
                String cacheDurable = synCtx.getConfiguration().getRegistry().getConfigurationProperties().getProperty("cachableDuration");
                long l = cacheTime = cacheDurable != null && !cacheDurable.isEmpty() ? Long.parseLong(cacheDurable) : 10000L;
                if (cacheContext.getDateTime().getTime() + cacheTime >= System.currentTimeMillis()) {
                    return cacheContext.getDecryptedValue();
                }
                decryptedCacheMap.remove(aliasPasword);
                return this.vaultLookup(aliasPasword, secretSrcData, synCtx, decryptedCacheMap);
            }
            return this.vaultLookup(aliasPasword, secretSrcData, synCtx, decryptedCacheMap);
        }
        return this.vaultLookup(aliasPasword, secretSrcData, synCtx, decryptedCacheMap);
    }

    @Override
    public String evaluate(String aliasPasword, MessageContext synCtx) throws RegistryException {
        return this.evaluate(aliasPasword, new SecretSrcData(), synCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String vaultLookup(String aliasPasword, SecretSrcData secretSrcData, MessageContext synCtx, Map<String, Object> decryptedCacheMap) {
        Object object = this.decryptlockObj;
        synchronized (object) {
            SecureVaultCacheContext cacheContext;
            SecretCipherHander secretManager = new SecretCipherHander(synCtx);
            String decryptedValue = secretManager.getSecret(aliasPasword, secretSrcData);
            if (decryptedCacheMap == null) {
                return null;
            }
            if (decryptedValue.isEmpty() && (cacheContext = (SecureVaultCacheContext)decryptedCacheMap.get(aliasPasword)) != null) {
                return cacheContext.getDecryptedValue();
            }
            decryptedCacheMap.put(aliasPasword, new SecureVaultCacheContext(Calendar.getInstance().getTime(), decryptedValue));
            return decryptedValue;
        }
    }
}

