/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.security.vault;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.wso2.carbon.mediation.security.vault.CipherInitializer;
import org.wso2.carbon.mediation.security.vault.FileSecretRepository;
import org.wso2.carbon.mediation.security.vault.RegistrySecretRepository;
import org.wso2.carbon.mediation.security.vault.SecretSrcData;
import org.wso2.carbon.mediation.security.vault.SecureVaultConstants;

public class SecretCipherHander {
    private static Log log = LogFactory.getLog(SecretCipherHander.class);
    private static String DOCKER_SECRET_ROOT;
    private static String FILE_SECRET_ROOT;
    private RegistrySecretRepository parentRepository = new RegistrySecretRepository();
    private FileSecretRepository fileSecretRepository = new FileSecretRepository();
    private MessageContext synCtx;
    CipherInitializer ciperInitializer = CipherInitializer.getInstance();

    public SecretCipherHander(MessageContext synCtx) {
        this.synCtx = synCtx;
        this.parentRepository.setSynCtx(synCtx);
    }

    public String getSecret(String alias) {
        return this.parentRepository.getSecret(alias);
    }

    public String getSecret(String alias, SecretSrcData secretSrcData) {
        switch (secretSrcData.getVaultType()) {
            case DOCKER: {
                String resolvedDockerAlias = DOCKER_SECRET_ROOT + alias;
                if (secretSrcData.isEncrypted()) {
                    return this.fileSecretRepository.getSecret(resolvedDockerAlias);
                }
                return this.fileSecretRepository.getPlainTextSecret(resolvedDockerAlias);
            }
            case FILE: {
                String resolvedFileAlias = FILE_SECRET_ROOT + alias;
                if (secretSrcData.isEncrypted()) {
                    return this.fileSecretRepository.getSecret(resolvedFileAlias);
                }
                return this.fileSecretRepository.getPlainTextSecret(resolvedFileAlias);
            }
            case REG: {
                return this.parentRepository.getSecret(alias);
            }
        }
        throw new SynapseException("Unknown secret type : " + secretSrcData.getVaultType().toString());
    }

    public String getEncryptedData(String alias) {
        return this.parentRepository.getEncryptedData(alias);
    }

    public void shoutDown() {
        this.parentRepository = null;
    }

    public MessageContext getSynCtx() {
        return this.synCtx;
    }

    public void setSynCtx(MessageContext synCtx) {
        this.synCtx = synCtx;
    }

    static {
        String dockerSecretProp = System.getProperty("ei.secret.docker.root.dir");
        DOCKER_SECRET_ROOT = dockerSecretProp != null && !dockerSecretProp.trim().isEmpty() ? dockerSecretProp.trim() : (System.getProperty("os.name").toLowerCase().contains("windows") ? "C:\\ProgramData\\Docker\\secrets" : "/run/secrets/");
        if (!DOCKER_SECRET_ROOT.endsWith(File.separator)) {
            DOCKER_SECRET_ROOT = DOCKER_SECRET_ROOT + File.separator;
        }
        DOCKER_SECRET_ROOT = "file:" + DOCKER_SECRET_ROOT;
        String fileSecretProp = System.getProperty("ei.secret.file.root.dir");
        FILE_SECRET_ROOT = fileSecretProp != null && !fileSecretProp.trim().isEmpty() ? fileSecretProp.trim() : SecureVaultConstants.PROP_FILE_SECRET_ROOT_DIRECTORY_DEFAULT;
        if (!FILE_SECRET_ROOT.endsWith(File.separator)) {
            FILE_SECRET_ROOT = FILE_SECRET_ROOT + File.separator;
        }
        FILE_SECRET_ROOT = "file:" + FILE_SECRET_ROOT;
    }
}

