/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.security.vault;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.Entry;
import org.apache.synapse.registry.Registry;
import org.wso2.carbon.mediation.security.vault.CipherInitializer;
import org.wso2.securevault.DecryptionProvider;
import org.wso2.securevault.secret.SecretRepository;

public class RegistrySecretRepository
implements SecretRepository {
    private static Log log = LogFactory.getLog(RegistrySecretRepository.class);
    private SecretRepository parentRepository;
    private MessageContext synCtx;

    public String getSecret(String alias) {
        DecryptionProvider decyptProvider;
        Entry propEntry = this.synCtx.getConfiguration().getEntryDefinition("conf:/repository/components/secure-vault");
        Registry registry = this.synCtx.getConfiguration().getRegistry();
        String propertyValue = "";
        if (registry != null) {
            Properties reqProperties;
            registry.getResource(propEntry, new Properties());
            if (alias != null && (reqProperties = propEntry.getEntryProperties()) != null && reqProperties.get(alias) != null) {
                propertyValue = reqProperties.getProperty(alias);
            }
        }
        if ((decyptProvider = CipherInitializer.getInstance().getDecryptionProvider()) == null) {
            log.error((Object)"Can not proceed decyption due to the secret repository intialization error");
            return null;
        }
        String decryptedText = new String(decyptProvider.decrypt(propertyValue.trim().getBytes()));
        if (log.isDebugEnabled()) {
            log.info((Object)("evaluation completed succesfully " + decryptedText));
        }
        return decryptedText;
    }

    public String getEncryptedData(String alias) {
        return null;
    }

    public void setParent(SecretRepository parent) {
        this.parentRepository = parent;
    }

    public SecretRepository getParent() {
        return this.parentRepository;
    }

    public MessageContext getSynCtx() {
        return this.synCtx;
    }

    public void setSynCtx(MessageContext synCtx) {
        this.synCtx = synCtx;
    }

    public void init(Properties arg0, String arg1) {
    }
}

