/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.security.vault;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.apache.axis2.AxisFault;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.security.vault.CipherInitializer;
import org.wso2.carbon.mediation.security.vault.external.ExternalVaultException;
import org.wso2.carbon.mediation.security.vault.external.hashicorp.HashiCorpVaultLookupHandlerImpl;

public class MediationSecurityAdminService
extends AbstractServiceBusAdmin {
    private static Log log = LogFactory.getLog(MediationSecurityAdminService.class);
    private static final String EXTERNAL_VAULTS = "[EI_HOME]/conf/security/external-vaults.xml";

    public String doEncrypt(String plainTextPass) throws AxisFault {
        CipherInitializer ciperInitializer = CipherInitializer.getInstance();
        byte[] plainTextPassByte = plainTextPass.getBytes();
        try {
            Cipher cipher = ciperInitializer.getEncryptionProvider();
            if (cipher == null) {
                log.error((Object)"Either Configuration properties can not be loaded or No secret repositories have been configured please check PRODUCT_HOME/conf/security  refer links related to configure WSO2 Secure vault");
                this.handleException(log, "Failed to load security key store information ,Configure secret-conf.properties properly by referring to \"Carbon Secure Vault Implementation\" in WSO2 Documentation", null);
            }
            byte[] encryptedPassword = cipher.doFinal(plainTextPassByte);
            return new String(Base64.encodeBase64((byte[])encryptedPassword));
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            this.handleException(log, "Error encrypting password ", e);
            return null;
        }
    }

    public String doDecrypt(String cipherText) throws AxisFault {
        return null;
    }

    private void handleException(Log log, String message, Exception e) throws AxisFault {
        if (e == null) {
            AxisFault exception = new AxisFault(message);
            log.error((Object)message, (Throwable)exception);
            throw exception;
        }
        message = message + " :: " + e.getMessage();
        log.error((Object)message, (Throwable)e);
        throw new AxisFault(message, (Throwable)e);
    }

    public void setSecretIdForHashiCorpVault(String secretId) throws ExternalVaultException {
        HashiCorpVaultLookupHandlerImpl instance = HashiCorpVaultLookupHandlerImpl.getDefaultSecurityService();
        instance.setSecretId(secretId);
        log.info((Object)"SecretId value is updated in HashiCorp vault runtime configurations");
        log.warn((Object)"To persist the new SecretId in the next server startup, please update the [EI_HOME]/conf/security/external-vaults.xml file");
    }
}

