/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.security.vault;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.wso2.carbon.mediation.security.vault.CipherInitializer;
import org.wso2.securevault.DecryptionProvider;
import org.wso2.securevault.secret.SecretRepository;

public class FileSecretRepository
implements SecretRepository {
    private static Log LOG = LogFactory.getLog(FileSecretRepository.class);
    private SecretRepository parentRepository;

    public void init(Properties properties, String id) {
    }

    public String getSecret(String alias) {
        String secretRawValue = this.getPlainTextSecret(alias);
        DecryptionProvider decyptProvider = CipherInitializer.getInstance().getDecryptionProvider();
        if (decyptProvider == null) {
            LOG.error((Object)"Can not proceed decryption due to the secret repository initialization error");
            return null;
        }
        return new String(decyptProvider.decrypt(secretRawValue.trim().getBytes()));
    }

    public String getPlainTextSecret(String alias) {
        try {
            String plainText = this.readFile(alias);
            return plainText != null ? plainText.trim() : null;
        }
        catch (IOException e) {
            this.handleException("Error occurred while reading file resource : " + alias, e);
            return null;
        }
    }

    public String getEncryptedData(String alias) {
        return null;
    }

    public void setParent(SecretRepository secretRepository) {
        this.parentRepository = secretRepository;
    }

    public SecretRepository getParent() {
        return this.parentRepository;
    }

    private String readFile(String filePath) throws IOException {
        URL url = null;
        try {
            url = new URL(filePath);
        }
        catch (MalformedURLException e) {
            this.handleException("Invalid path '" + filePath + "' for URL", e);
        }
        URLConnection urlConnection = url.openConnection();
        urlConnection.connect();
        try (InputStream inputStream = urlConnection.getInputStream();){
            if (inputStream == null) {
                String string = null;
                return string;
            }
            StringBuilder strBuilder = new StringBuilder();
            try (BufferedReader bReader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                while ((line = bReader.readLine()) != null) {
                    strBuilder.append(line);
                }
            }
            String string = strBuilder.toString();
            return string;
        }
    }

    private void handleException(String msg, Exception e) {
        throw new SynapseException(msg, (Throwable)e);
    }
}

