/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.security.vault;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.security.vault.util.SecureVaultUtil;
import org.wso2.securevault.CipherFactory;
import org.wso2.securevault.CipherOperationMode;
import org.wso2.securevault.DecryptionProvider;
import org.wso2.securevault.EncodingType;
import org.wso2.securevault.commons.MiscellaneousUtil;
import org.wso2.securevault.definition.CipherInformation;
import org.wso2.securevault.definition.IdentityKeyStoreInformation;
import org.wso2.securevault.definition.KeyStoreInformationFactory;
import org.wso2.securevault.definition.TrustKeyStoreInformation;
import org.wso2.securevault.keystore.IdentityKeyStoreWrapper;
import org.wso2.securevault.keystore.KeyStoreWrapper;
import org.wso2.securevault.keystore.TrustKeyStoreWrapper;

public class CipherInitializer {
    private static Log log = LogFactory.getLog(CipherInitializer.class);
    private static final String LOCATION = "location";
    private static final String KEY_STORE = "keyStore";
    private static final String DOT = ".";
    private static final String ALGORITHM = "algorithm";
    private static final String DEFAULT_ALGORITHM = "RSA";
    private static final String TRUSTED = "trusted";
    private static final String CIPHER_TRANSFORMATION_SECRET_CONF_PROPERTY = "keystore.identity.CipherTransformation";
    private static final String CIPHER_TRANSFORMATION_SYSTEM_PROPERTY = "org.wso2.CipherTransformation";
    private static CipherInitializer cipherInitializer = new CipherInitializer();
    private String globalSecretProvider = null;
    private IdentityKeyStoreWrapper identityKeyStoreWrapper;
    private TrustKeyStoreWrapper trustKeyStoreWrapper;
    private DecryptionProvider decryptionProvider = null;
    private Cipher encryptionProvider = null;
    Object cipherLockObj;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CipherInitializer() {
        Object object = this.cipherLockObj = new Object();
        synchronized (object) {
            boolean initPro = this.init();
            if (initPro) {
                this.initCipherDecryptProvider();
                this.initEncrypt();
            } else {
                log.error((Object)"Either Configuration properties can not be loaded or No secret repositories have been configured please check PRODUCT_HOME/repository/conf/security  refer links related to configure WSO2 Secure vault");
            }
        }
    }

    public static CipherInitializer getInstance() {
        return cipherInitializer;
    }

    private boolean init() {
        String repositoriesString;
        Properties properties = SecureVaultUtil.loadProperties();
        if (properties == null) {
            log.error((Object)"KeyStore configuration properties cannot be found");
            return false;
        }
        String configurationFile = MiscellaneousUtil.getProperty((Properties)properties, (String)"secret.manager.conf", (String)"secret-manager.properties");
        Properties configurationProperties = MiscellaneousUtil.loadProperties((String)configurationFile);
        if (configurationProperties == null || configurationProperties.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Configuration properties can not be loaded form : " + configurationFile + " Will use synapse properties"));
            }
            configurationProperties = properties;
        }
        this.globalSecretProvider = MiscellaneousUtil.getProperty((Properties)configurationProperties, (String)"carbon.secretProvider", null);
        if ((this.globalSecretProvider == null || "".equals(this.globalSecretProvider)) && log.isDebugEnabled()) {
            log.debug((Object)"No global secret provider is configured.");
        }
        if ((repositoriesString = MiscellaneousUtil.getProperty((Properties)configurationProperties, (String)"secretRepositories", null)) == null || "".equals(repositoriesString)) {
            log.error((Object)"No secret repositories have been configured");
            return false;
        }
        String[] repositories = repositoriesString.split(",");
        if (repositories == null || repositories.length == 0) {
            log.error((Object)"No secret repositories have been configured");
            return false;
        }
        IdentityKeyStoreInformation identityInformation = KeyStoreInformationFactory.createIdentityKeyStoreInformation((Properties)properties);
        TrustKeyStoreInformation trustInformation = KeyStoreInformationFactory.createTrustKeyStoreInformation((Properties)properties);
        String identityKeyPass = null;
        String identityStorePass = null;
        String trustStorePass = null;
        if (identityInformation != null) {
            identityKeyPass = identityInformation.getKeyPasswordProvider().getResolvedSecret();
            identityStorePass = identityInformation.getKeyStorePasswordProvider().getResolvedSecret();
        }
        if (trustInformation != null) {
            trustStorePass = trustInformation.getKeyStorePasswordProvider().getResolvedSecret();
        }
        if (!this.validatePasswords(identityStorePass, identityKeyPass, trustStorePass)) {
            log.error((Object)"Either Identity or Trust keystore password is mandatory in order to initialized secret manager.");
            return false;
        }
        this.identityKeyStoreWrapper = new IdentityKeyStoreWrapper();
        this.identityKeyStoreWrapper.init(identityInformation, identityKeyPass);
        this.trustKeyStoreWrapper = new TrustKeyStoreWrapper();
        if (trustInformation != null) {
            this.trustKeyStoreWrapper.init(trustInformation);
        }
        Object currentParent = null;
        for (String secretRepo : repositories) {
            StringBuffer sb = new StringBuffer();
            sb.append("secretRepositories");
            sb.append(DOT);
            sb.append(secretRepo);
            String id = sb.toString();
            sb.append(DOT);
            sb.append("provider");
            String provider = MiscellaneousUtil.getProperty((Properties)configurationProperties, (String)sb.toString(), null);
            if (provider == null || "".equals(provider)) {
                CipherInitializer.handleException("Repository provider cannot be null ");
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)"Initiating a File Based Secret Repository");
        }
        return true;
    }

    private boolean validatePasswords(String identityStorePass, String identityKeyPass, String trustStorePass) {
        boolean isValid = false;
        if (trustStorePass != null && !"".equals(trustStorePass)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Trust Store Password cannot be found.");
            }
            isValid = true;
        } else if (identityStorePass != null && !"".equals(identityStorePass) && identityKeyPass != null && !"".equals(identityKeyPass)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity Store Password and Identity Store private key Password cannot be found.");
            }
            isValid = true;
        }
        return isValid;
    }

    protected void initCipherDecryptProvider() {
        if (this.decryptionProvider != null) {
            return;
        }
        Properties properties = SecureVaultUtil.loadProperties();
        StringBuffer sb = new StringBuffer();
        sb.append(DOT);
        sb.append(LOCATION);
        StringBuffer sbTwo = new StringBuffer();
        sbTwo.append(DOT);
        sbTwo.append(ALGORITHM);
        String algorithm = this.getCipherTransformation(properties);
        StringBuffer buffer = new StringBuffer();
        buffer.append(DOT);
        buffer.append(KEY_STORE);
        String keyStore = MiscellaneousUtil.getProperty((Properties)properties, (String)buffer.toString(), null);
        Object keyStoreWrapper = TRUSTED.equals(keyStore) ? this.trustKeyStoreWrapper : this.identityKeyStoreWrapper;
        CipherInformation cipherInformation = new CipherInformation();
        cipherInformation.setAlgorithm(algorithm);
        cipherInformation.setCipherOperationMode(CipherOperationMode.DECRYPT);
        cipherInformation.setInType(EncodingType.BASE64);
        this.decryptionProvider = CipherFactory.createCipher((CipherInformation)cipherInformation, (KeyStoreWrapper)keyStoreWrapper);
    }

    public void initEncrypt() {
        if (this.encryptionProvider != null) {
            return;
        }
        Properties properties = SecureVaultUtil.loadProperties();
        String provider = null;
        Cipher cipher = null;
        String keyStoreFile = properties.getProperty("keystore.identity.location");
        File keyStore = new File(keyStoreFile);
        if (!keyStore.exists()) {
            CipherInitializer.handleException("Primary Key Store Can not be found at Default location");
        }
        String keyType = properties.getProperty("keystore.identity.type");
        String aliasName = properties.getProperty("keystore.identity.alias");
        IdentityKeyStoreInformation identityInformation = KeyStoreInformationFactory.createIdentityKeyStoreInformation((Properties)properties);
        String password = identityInformation.getKeyStorePasswordProvider().getResolvedSecret();
        try {
            KeyStore primaryKeyStore = CipherInitializer.getKeyStore(keyStoreFile, password, keyType, provider);
            Certificate certs = primaryKeyStore.getCertificate(aliasName);
            String algorithm = this.getCipherTransformation(properties);
            cipher = Cipher.getInstance(algorithm);
            cipher.init(1, certs);
        }
        catch (InvalidKeyException e) {
            CipherInitializer.handleException("Error initializing Cipher ", e);
        }
        catch (NoSuchAlgorithmException e) {
            CipherInitializer.handleException("Error initializing Cipher ", e);
        }
        catch (KeyStoreException e) {
            CipherInitializer.handleException("Error initializing Cipher ", e);
        }
        catch (NoSuchPaddingException e) {
            CipherInitializer.handleException("Error initializing Cipher ", e);
        }
        this.encryptionProvider = cipher;
    }

    private String getCipherTransformation(Properties properties) {
        String cipherTransformation = System.getProperty(CIPHER_TRANSFORMATION_SYSTEM_PROPERTY);
        if (cipherTransformation == null) {
            cipherTransformation = DEFAULT_ALGORITHM;
        }
        return MiscellaneousUtil.getProperty((Properties)properties, (String)CIPHER_TRANSFORMATION_SECRET_CONF_PROPERTY, (String)cipherTransformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyStore(String location, String storePassword, String storeType, String provider) {
        File keyStoreFile = new File(location);
        if (!keyStoreFile.exists()) {
            CipherInitializer.handleException("KeyStore can not be found at ' " + keyStoreFile + " '");
        }
        if (storePassword == null) {
            CipherInitializer.handleException("KeyStore password can not be null");
        }
        if (storeType == null) {
            CipherInitializer.handleException("KeyStore Type can not be null");
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(keyStoreFile));
            KeyStore keyStore = provider != null ? KeyStore.getInstance(storeType, provider) : KeyStore.getInstance(storeType);
            keyStore.load(bufferedInputStream, storePassword.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (KeyStoreException e) {
            CipherInitializer.handleException("Error loading keyStore from ' " + location + " ' ", e);
        }
        catch (IOException e) {
            CipherInitializer.handleException("IOError loading keyStore from ' " + location + " ' ", e);
        }
        catch (NoSuchAlgorithmException e) {
            CipherInitializer.handleException("Error loading keyStore from ' " + location + " ' ", e);
        }
        catch (CertificateException e) {
            CipherInitializer.handleException("Error loading keyStore from ' " + location + " ' ", e);
        }
        catch (NoSuchProviderException e) {
            CipherInitializer.handleException("Error loading keyStore from ' " + location + " ' ", e);
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException ignored) {
                    System.err.println("Error while closing input stream");
                }
            }
        }
        return null;
    }

    protected static void handleException(String msg, Exception e) {
    }

    protected static void handleException(String msg) {
    }

    public IdentityKeyStoreWrapper getIdentityKeyStoreWrapper() {
        return this.identityKeyStoreWrapper;
    }

    public void setIdentityKeyStoreWrapper(IdentityKeyStoreWrapper identityKeyStoreWrapper) {
        this.identityKeyStoreWrapper = identityKeyStoreWrapper;
    }

    public TrustKeyStoreWrapper getTrustKeyStoreWrapper() {
        return this.trustKeyStoreWrapper;
    }

    public void setTrustKeyStoreWrapper(TrustKeyStoreWrapper trustKeyStoreWrapper) {
        this.trustKeyStoreWrapper = trustKeyStoreWrapper;
    }

    public DecryptionProvider getDecryptionProvider() {
        return this.decryptionProvider;
    }

    public Cipher getEncryptionProvider() {
        return this.encryptionProvider;
    }
}

