/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.manager.core.internal.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.processor.manager.commons.utils.Utils;
import org.wso2.carbon.event.processor.manager.core.config.DistributedConfiguration;
import org.wso2.carbon.event.processor.manager.core.config.HAConfiguration;
import org.wso2.carbon.event.processor.manager.core.config.ManagementModeInfo;
import org.wso2.carbon.event.processor.manager.core.config.Mode;
import org.wso2.carbon.event.processor.manager.core.config.PersistenceConfiguration;
import org.wso2.carbon.event.processor.manager.core.exception.ManagementConfigurationException;

public class ManagementModeConfigurationLoader {
    private static final Log log = LogFactory.getLog(ManagementModeConfigurationLoader.class);

    public static ManagementModeInfo loadManagementModeInfo() throws ManagementConfigurationException {
        ManagementModeInfo managementModeInfo = new ManagementModeInfo();
        OMElement omElement = ManagementModeConfigurationLoader.loadConfigXML();
        Iterator iterator = omElement.getChildrenWithName(new QName("mode"));
        while (iterator.hasNext()) {
            OMElement processingMode = (OMElement)iterator.next();
            if (processingMode.getAttribute(new QName("name")) == null) {
                throw new ManagementConfigurationException("Invalid Mode Element with no mode attribute 'name' in file event-processor.xml");
            }
            String attribute = processingMode.getAttribute(new QName("name")).getAttributeValue();
            if (processingMode.getAttribute(new QName("enable")) == null) {
                throw new ManagementConfigurationException("Invalid Mode Element '" + attribute + "' with no mode attribute '" + "enable" + "' in file " + "event-processor.xml");
            }
            String enabled = processingMode.getAttribute(new QName("enable")).getAttributeValue();
            if (!enabled.equalsIgnoreCase("true")) continue;
            if (attribute.equalsIgnoreCase("HA")) {
                managementModeInfo.setMode(Mode.HA);
                managementModeInfo.setHaConfiguration(ManagementModeConfigurationLoader.getHAConfiguration(processingMode));
                OMElement nodeConfig = processingMode.getFirstChildWithName(new QName("persistence"));
                if (nodeConfig != null) {
                    boolean isPersistenceEnabled = ManagementModeConfigurationLoader.nodeType("enable", nodeConfig);
                    if (isPersistenceEnabled) {
                        managementModeInfo.setPersistenceConfiguration(ManagementModeConfigurationLoader.getPersistConfigurations(nodeConfig, isPersistenceEnabled));
                        log.info((Object)"CEP started in Persistence enabled HA mode");
                    }
                } else {
                    log.info((Object)"CEP started in HA mode");
                }
            } else if (attribute.equalsIgnoreCase("Distributed")) {
                managementModeInfo.setMode(Mode.Distributed);
                log.info((Object)"CEP started in Distributed mode");
                managementModeInfo.setDistributedConfiguration(ManagementModeConfigurationLoader.getDistributedConfiguration(processingMode));
            } else {
                managementModeInfo.setMode(Mode.SingleNode);
                OMElement nodeConfig = processingMode.getFirstChildWithName(new QName("persistence"));
                if (nodeConfig != null) {
                    boolean isPersistenceEnabled = ManagementModeConfigurationLoader.nodeType("enable", nodeConfig);
                    if (isPersistenceEnabled) {
                        managementModeInfo.setPersistenceConfiguration(ManagementModeConfigurationLoader.getPersistConfigurations(nodeConfig, isPersistenceEnabled));
                        log.info((Object)"CEP started in Persistence enabled Single Node mode");
                    }
                } else {
                    log.info((Object)"CEP started in Single node mode");
                }
            }
            return managementModeInfo;
        }
        managementModeInfo.setMode(Mode.SingleNode);
        log.info((Object)"CEP started in Single node mode");
        return managementModeInfo;
    }

    private static OMElement loadConfigXML() throws ManagementConfigurationException {
        String carbonHome = System.getProperty("carbon.config.dir.path");
        String path = carbonHome + File.separator + "event-processor.xml";
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(new File(path)));
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement omElement = builder.getDocumentElement();
            omElement.build();
            OMElement oMElement = omElement;
            return oMElement;
        }
        catch (FileNotFoundException e) {
            throw new ManagementConfigurationException("event-processor.xmlcannot be found in the path : " + path, e);
        }
        catch (XMLStreamException e) {
            throw new ManagementConfigurationException("Invalid XML for event-processor.xml located in the path : " + path, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Can not shutdown the input stream", (Throwable)e);
            }
        }
    }

    private static boolean nodeType(String elementName, OMElement element) throws ManagementConfigurationException {
        OMAttribute attribute = element.getAttribute(new QName(elementName));
        if (attribute != null) {
            return attribute.getAttributeValue().equalsIgnoreCase("True");
        }
        throw new ManagementConfigurationException("Invalid XML. No attribute with name name found in file event-processor.xml");
    }

    private static PersistenceConfiguration getPersistConfigurations(OMElement persistence, boolean isPersistenceEnabled) {
        int poolSize;
        long timeInterval;
        String className;
        OMElement classElement = persistence.getFirstChildWithName(new QName("persister"));
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        if (classElement == null) {
            log.warn((Object)"Invalid XML. Using default persistence store :org.wso2.carbon.event.processor.core.internal.persistence.FileSystemPersistenceStore");
            className = "org.wso2.carbon.event.processor.core.internal.persistence.FileSystemPersistenceStore";
        } else {
            className = classElement.getAttribute(new QName("class")).getAttributeValue();
            Iterator propertyElements = classElement.getChildrenWithName(new QName("property"));
            while (propertyElements.hasNext()) {
                OMElement propertyElement = (OMElement)propertyElements.next();
                String key = propertyElement.getAttribute(new QName("key")).getAttributeValue();
                propertiesMap.put(key, propertyElement.getText());
            }
        }
        OMElement timeElement = persistence.getFirstChildWithName(new QName("persistenceIntervalInMinutes"));
        if (timeElement == null) {
            timeInterval = 15L;
        } else {
            try {
                timeInterval = Long.parseLong(persistence.getFirstChildWithName(new QName("persistenceIntervalInMinutes")).getText());
            }
            catch (NumberFormatException ex) {
                log.warn((Object)"Invalid persistenceInterval. Using default persistenceInterval");
                timeInterval = 15L;
            }
        }
        OMElement omElement = persistence.getFirstChildWithName(new QName("persisterSchedulerPoolSize"));
        if (omElement == null) {
            poolSize = 10;
        } else {
            try {
                poolSize = Integer.parseInt(persistence.getFirstChildWithName(new QName("persisterSchedulerPoolSize")).getText());
            }
            catch (NumberFormatException ex) {
                log.warn((Object)"Invalid persisterSchedulerPoolSize. Using default persisterSchedulerPoolSize");
                poolSize = 10;
            }
        }
        return new PersistenceConfiguration(className, timeInterval, poolSize, propertiesMap, isPersistenceEnabled);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DistributedConfiguration getDistributedConfiguration(OMElement processingElement) {
        OMElement memberUpdateCheckInterval;
        int queueSize;
        DistributedConfiguration stormDeploymentConfig = new DistributedConfiguration();
        OMElement management = processingElement.getFirstChildWithName(new QName("management"));
        OMElement managers = management.getFirstChildWithName(new QName("managers"));
        Iterator iterator = managers.getChildElements();
        if (!iterator.hasNext()) {
            try {
                String hostName = Utils.findAddress((String)"localhost");
                int port = 8904;
                stormDeploymentConfig.addManager(hostName, port);
                log.info((Object)("No storm managers are provided. Hence automatically electing " + hostName + ":" + port + " node as manager"));
            }
            catch (SocketException e) {
                log.error((Object)"Error while automatically populating storm managers. Please check the event-processor.xml at CARBON_HOME/repository/conf", (Throwable)e);
                return null;
            }
        }
        while (iterator.hasNext()) {
            OMElement manager = (OMElement)iterator.next();
            String hostName = manager.getFirstChildWithName(new QName("hostName")).getText();
            int port = Integer.parseInt(manager.getFirstChildWithName(new QName("port")).getText());
            stormDeploymentConfig.addManager(hostName, port);
        }
        if (management.getFirstChildWithName(new QName("heartbeatInterval")) != null) {
            stormDeploymentConfig.setManagementHeartbeatInterval(Integer.parseInt(management.getFirstChildWithName(new QName("heartbeatInterval")).getText()));
        } else {
            log.info((Object)("No heartbeat interval provided. Hence using default heartbeat interval " + stormDeploymentConfig.getManagementHeartbeatInterval()));
        }
        if (management.getFirstChildWithName(new QName("reconnectionInterval")) != null) {
            stormDeploymentConfig.setManagementReconnectInterval(Integer.parseInt(management.getFirstChildWithName(new QName("reconnectionInterval")).getText()));
        } else {
            log.info((Object)("No reconnection interval provided. Hence using default reconnection interval " + stormDeploymentConfig.getManagementReconnectInterval()));
        }
        if (management.getFirstChildWithName(new QName("topologyResubmitInterval")) != null) {
            stormDeploymentConfig.setTopologySubmitRetryInterval(Integer.parseInt(management.getFirstChildWithName(new QName("topologyResubmitInterval")).getText()));
        } else {
            log.info((Object)("No topology resubmit interval provided. Hence using default topology resubmit interval " + stormDeploymentConfig.getTopologySubmitRetryInterval()));
        }
        OMElement transport = processingElement.getFirstChildWithName(new QName("transport"));
        OMElement portRange = transport.getFirstChildWithName(new QName("portRange"));
        if (portRange != null) {
            stormDeploymentConfig.setTransportMaxPort(Integer.parseInt(portRange.getFirstChildWithName(new QName("max")).getText()));
            stormDeploymentConfig.setTransportMinPort(Integer.parseInt(portRange.getFirstChildWithName(new QName("min")).getText()));
        } else {
            log.info((Object)("No port information provided. Hence using default port range " + stormDeploymentConfig.getTransportMinPort() + " - " + stormDeploymentConfig.getTransportMaxPort()));
        }
        if (transport.getFirstChildWithName(new QName("reconnectionInterval")) != null) {
            stormDeploymentConfig.setTransportReconnectInterval(Integer.parseInt(transport.getFirstChildWithName(new QName("reconnectionInterval")).getText()));
        } else {
            log.info((Object)("No transport reconnection interval provided. Hence using default reconnection interval " + stormDeploymentConfig.getTransportReconnectInterval()));
        }
        if (transport.getFirstChildWithName(new QName("cepReceiverOutputQueueSize")) != null) {
            queueSize = Integer.parseInt(transport.getFirstChildWithName(new QName("cepReceiverOutputQueueSize")).getText());
            if (!ManagementModeConfigurationLoader.isPowerOfTwo(queueSize)) throw new IllegalArgumentException("cepReceiverOutputQueueSize must be a power of two.");
            stormDeploymentConfig.setCepReceiverOutputQueueSize(queueSize);
        } else {
            log.info((Object)("No CEP receiver output queue size specified. Hence using default queue size " + stormDeploymentConfig.getCepReceiverOutputQueueSize()));
        }
        if (transport.getFirstChildWithName(new QName("stormPublisherOutputQueueSize")) != null) {
            queueSize = Integer.parseInt(transport.getFirstChildWithName(new QName("stormPublisherOutputQueueSize")).getText());
            if (!ManagementModeConfigurationLoader.isPowerOfTwo(queueSize)) throw new IllegalArgumentException("cepReceiverOutputQueueSize must be a power of two.");
            stormDeploymentConfig.setStormPublisherOutputQueueSize(queueSize);
        } else {
            log.info((Object)("No storm publisher output queue size specified. Hence using default queue size " + stormDeploymentConfig.getStormPublisherOutputQueueSize()));
        }
        if (transport.getFirstChildWithName(new QName("tcpEventPublisherSendBufferSize")) != null) {
            int bufferSize = Integer.parseInt(transport.getFirstChildWithName(new QName("tcpEventPublisherSendBufferSize")).getText());
            stormDeploymentConfig.setTransportPublisherTcpSendBufferSize(bufferSize);
        } else {
            log.info((Object)("No TCP publisher buffer size not specified. Hence using default buffer size " + stormDeploymentConfig.getTransportPublisherTcpSendBufferSize()));
        }
        if (transport.getFirstChildWithName(new QName("tcpEventPublisherCharSet")) != null) {
            String tcpEventPublisherCharSet = transport.getFirstChildWithName(new QName("tcpEventPublisherCharSet")).getText();
            stormDeploymentConfig.setTransportPublisherCharSet(tcpEventPublisherCharSet);
        } else {
            log.info((Object)("TCP event publisher Char-Set not set. Hence using default value " + stormDeploymentConfig.getTransportPublisherCharSet()));
        }
        if (transport.getFirstChildWithName(new QName("stormSpoutBufferSize")) != null) {
            int bufferSize = Integer.parseInt(transport.getFirstChildWithName(new QName("stormSpoutBufferSize")).getText());
            stormDeploymentConfig.setStormSpoutBufferSize(bufferSize);
        } else {
            log.info((Object)("No Storm Spout buffer size not specified. Hence using default buffer size " + stormDeploymentConfig.getStormSpoutBufferSize()));
        }
        if (transport.getFirstChildWithName(new QName("connectionStatusCheckInterval")) != null) {
            int connectionStatusCheckInterval = Integer.parseInt(transport.getFirstChildWithName(new QName("connectionStatusCheckInterval")).getText());
            stormDeploymentConfig.setTransportPublisherConnectionStatusCheckInterval(connectionStatusCheckInterval);
        } else {
            log.info((Object)("No transport connection status check interval specified. Hence using default interval " + stormDeploymentConfig.getTransportPublisherConnectionStatusCheckInterval() + "ms"));
        }
        OMElement node = processingElement.getFirstChildWithName(new QName("nodeType"));
        if (node != null) {
            OMElement presenter;
            OMElement manager;
            OMElement worker = node.getFirstChildWithName(new QName("worker"));
            if ("true".equalsIgnoreCase(worker.getAttributeValue(new QName("enable")))) {
                stormDeploymentConfig.setWorkerNode(true);
            }
            if ("true".equalsIgnoreCase((manager = node.getFirstChildWithName(new QName("manager"))).getAttributeValue(new QName("enable")))) {
                stormDeploymentConfig.setManagerNode(true);
                String hostName = manager.getFirstChildWithName(new QName("hostName")).getText();
                int port = Integer.parseInt(manager.getFirstChildWithName(new QName("port")).getText());
                stormDeploymentConfig.setLocalManagerConfig(hostName, port);
            }
            if ("true".equalsIgnoreCase((presenter = node.getFirstChildWithName(new QName("presenter"))).getAttributeValue(new QName("enable")))) {
                stormDeploymentConfig.setPresenterNode(true);
                String hostName = presenter.getFirstChildWithName(new QName("hostName")).getText();
                int port = Integer.parseInt(presenter.getFirstChildWithName(new QName("port")).getText());
                stormDeploymentConfig.setLocalPresenterConfig(hostName, port);
            }
        } else {
            log.info((Object)"No node type configurations provided. Hence using default node type configurations");
        }
        OMElement distributedUI = processingElement.getFirstChildWithName(new QName("distributedUIUrl"));
        if (distributedUI != null) {
            String url = distributedUI.getText();
            stormDeploymentConfig.setDistributedUIUrl(url);
        }
        if ((memberUpdateCheckInterval = processingElement.getFirstChildWithName(new QName("memberUpdateCheckInterval"))) != null) {
            int interval = Integer.parseInt(memberUpdateCheckInterval.getText());
            stormDeploymentConfig.setMemberUpdateCheckInterval(interval);
        } else {
            log.info((Object)("No member update check interval specified. Hence using default interval " + stormDeploymentConfig.getMemberUpdateCheckInterval()));
        }
        OMElement jar = processingElement.getFirstChildWithName(new QName("stormJar"));
        stormDeploymentConfig.setJar(jar.getText());
        OMElement presentation = processingElement.getFirstChildWithName(new QName("presentation"));
        if (presentation != null) {
            if (presentation.getFirstChildWithName(new QName("presentationOutputQueueSize")) != null) {
                int queueSize2 = Integer.parseInt(presentation.getFirstChildWithName(new QName("presentationOutputQueueSize")).getText());
                if (!ManagementModeConfigurationLoader.isPowerOfTwo(queueSize2)) throw new IllegalArgumentException("presentationOutputQueueSize must be a power of two.");
                stormDeploymentConfig.setPresentationOutputQueueSize(queueSize2);
            } else {
                log.info((Object)("No presentation output queue size provided. Hence using default queue size " + stormDeploymentConfig.getPresentationOutputQueueSize()));
            }
            if (presentation.getFirstChildWithName(new QName("tcpEventPublisherSendBufferSize")) != null) {
                int bufferSize = Integer.parseInt(transport.getFirstChildWithName(new QName("tcpEventPublisherSendBufferSize")).getText());
                stormDeploymentConfig.setPresentationPublisherTcpSendBufferSize(bufferSize);
            } else {
                log.info((Object)("No TCP publisher buffer size not specified for presenter. Hence using default buffer size " + stormDeploymentConfig.getPresentationPublisherTcpSendBufferSize()));
            }
            if (presentation.getFirstChildWithName(new QName("tcpEventPublisherCharSet")) != null) {
                String tcpEventPublisherCharSet = transport.getFirstChildWithName(new QName("tcpEventPublisherCharSet")).getText();
                stormDeploymentConfig.setPresentationPublisherCharSet(tcpEventPublisherCharSet);
            } else {
                log.info((Object)("TCP event publisher Char-Set not set for presenter. Hence using default value " + stormDeploymentConfig.getPresentationPublisherCharSet()));
            }
            if (presentation.getFirstChildWithName(new QName("connectionStatusCheckInterval")) != null) {
                int connectionStatusCheckInterval = Integer.parseInt(transport.getFirstChildWithName(new QName("connectionStatusCheckInterval")).getText());
                stormDeploymentConfig.setPresentationPublisherConnectionStatusCheckInterval(connectionStatusCheckInterval);
            } else {
                log.info((Object)("No transport connection status check interval specified for presenter. Hence using default interval " + stormDeploymentConfig.getPresentationPublisherConnectionStatusCheckInterval() + "ms"));
            }
        } else {
            log.info((Object)"No presentation configurations provided. Hence using default configurations");
        }
        OMElement statusMonitor = processingElement.getFirstChildWithName(new QName("statusMonitor"));
        if (statusMonitor != null) {
            OMElement lockTimeoutElement = statusMonitor.getFirstChildWithName(new QName("lockTimeout"));
            if (lockTimeoutElement != null) {
                int lockTimeout = Integer.parseInt(lockTimeoutElement.getText());
                stormDeploymentConfig.setStatusLockTimeout(lockTimeout);
            } else {
                log.info((Object)("No lockTimeout value specified in Status Monitor configurations. Hence using default lock timeout value: " + stormDeploymentConfig.getStatusLockTimeout() + " seconds."));
            }
            OMElement updateRateElement = statusMonitor.getFirstChildWithName(new QName("updateRate"));
            if (updateRateElement != null) {
                int updateRate = Integer.parseInt(updateRateElement.getText());
                stormDeploymentConfig.setStatusUpdateInterval(updateRate);
                return stormDeploymentConfig;
            } else {
                log.info((Object)("No updateRate value specified in Status Monitor configurations. Hence using default update rate: " + stormDeploymentConfig.getStatusUpdateInterval() + " milliseconds."));
            }
            return stormDeploymentConfig;
        } else {
            log.info((Object)("No Status Monitor configurations provided. Hence using default Status Monitor configurations. Lock timeout: " + stormDeploymentConfig.getStatusLockTimeout() + " seconds, Update rate: " + stormDeploymentConfig.getStatusUpdateInterval() + " milliseconds."));
        }
        return stormDeploymentConfig;
    }

    private static HAConfiguration getHAConfiguration(OMElement processing) {
        HAConfiguration haConfiguration = new HAConfiguration();
        OMElement nodeType = processing.getFirstChildWithName(new QName("nodeType"));
        String isWorkerEnabled = nodeType.getFirstChildWithName(new QName("worker")).getAttribute(new QName("enable")).getAttributeValue();
        String isPresenterEnabled = nodeType.getFirstChildWithName(new QName("presenter")).getAttribute(new QName("enable")).getAttributeValue();
        haConfiguration.setCheckMemberUpdateInterval(Integer.parseInt(ManagementModeConfigurationLoader.readOMElementValue(processing, "checkMemberUpdateInterval")));
        OMElement management = processing.getFirstChildWithName(new QName("management"));
        haConfiguration.setManagement(ManagementModeConfigurationLoader.readHostName(management), ManagementModeConfigurationLoader.readPort(management, 11324));
        haConfiguration.setManagementTryStateChangeInterval(Integer.parseInt(ManagementModeConfigurationLoader.readOMElementValue(management, "tryStateChangeInterval")));
        haConfiguration.setManagementStateSyncRetryInterval(Integer.parseInt(ManagementModeConfigurationLoader.readOMElementValue(management, "stateSyncRetryInterval")));
        if (isWorkerEnabled.equalsIgnoreCase("true")) {
            haConfiguration.setWorkerNode(true);
            OMElement eventSync = processing.getFirstChildWithName(new QName("eventSync"));
            haConfiguration.setEventSyncConfig(ManagementModeConfigurationLoader.readHostName(eventSync), ManagementModeConfigurationLoader.readPort(eventSync, 11224));
            haConfiguration.setEventSyncPublisherTcpSendBufferSize(Integer.parseInt(ManagementModeConfigurationLoader.readOMElementValue(eventSync, "publisherTcpSendBufferSize")));
            haConfiguration.setEventSyncPublisherCharSet(ManagementModeConfigurationLoader.readOMElementValue(eventSync, "publisherCharSet"));
            haConfiguration.setEventSyncPublisherBufferSize(Integer.parseInt(ManagementModeConfigurationLoader.readOMElementValue(eventSync, "publisherBufferSize")));
            haConfiguration.setEventSyncPublisherConnectionStatusCheckInterval(Integer.parseInt(ManagementModeConfigurationLoader.readOMElementValue(eventSync, "publisherConnectionStatusCheckInterval")));
            haConfiguration.setEventSyncReceiverQueueSize(Integer.parseInt(ManagementModeConfigurationLoader.readOMElementValue(eventSync, "receiverQueueSize")));
            haConfiguration.setEventSyncReceiverMaxQueueSizeInMb(Integer.parseInt(ManagementModeConfigurationLoader.readOMElementValue(eventSync, "receiverQueueMaxSizeMb")));
            haConfiguration.setEventSyncPublisherQueueSize(Integer.parseInt(ManagementModeConfigurationLoader.readOMElementValue(eventSync, "publisherQueueSize")));
            haConfiguration.setEventSyncPublisherMaxQueueSizeInMb(Integer.parseInt(ManagementModeConfigurationLoader.readOMElementValue(eventSync, "publisherQueueMaxSizeMb")));
        }
        if (isPresenterEnabled.equalsIgnoreCase("true")) {
            haConfiguration.setPresenterNode(true);
            OMElement presentation = processing.getFirstChildWithName(new QName("presentation"));
            haConfiguration.setLocalPresenterConfig(ManagementModeConfigurationLoader.readHostName(presentation), ManagementModeConfigurationLoader.readPort(presentation, 11000));
            haConfiguration.setPresentationPublisherTcpSendBufferSize(Integer.parseInt(ManagementModeConfigurationLoader.readOMElementValue(presentation, "publisherTcpSendBufferSize")));
            haConfiguration.setPresentationPublisherCharSet(ManagementModeConfigurationLoader.readOMElementValue(presentation, "publisherCharSet"));
            haConfiguration.setPresentationPublisherBufferSize(Integer.parseInt(ManagementModeConfigurationLoader.readOMElementValue(presentation, "publisherBufferSize")));
            haConfiguration.setPresentationPublisherConnectionStatusCheckInterval(Integer.parseInt(ManagementModeConfigurationLoader.readOMElementValue(presentation, "publisherConnectionStatusCheckInterval")));
        }
        return haConfiguration;
    }

    private static String readHostName(OMElement transport) {
        OMElement receiverHostName = transport.getFirstChildWithName(new QName("hostName"));
        String hostName = null;
        if (receiverHostName != null && receiverHostName.getText() != null && !receiverHostName.getText().trim().equals("")) {
            hostName = receiverHostName.getText();
        }
        if (hostName == null) {
            try {
                hostName = Utils.findAddress((String)"localhost");
            }
            catch (SocketException e) {
                log.error((Object)"Unable to find the address of localhost.", (Throwable)e);
            }
        }
        return hostName;
    }

    private static int readPort(OMElement transport, int defaultPort) {
        OMElement receiverPort = transport.getFirstChildWithName(new QName("port"));
        if (receiverPort != null) {
            try {
                return Integer.parseInt(receiverPort.getText());
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid port for HA configuration. Using default port " + defaultPort), (Throwable)e);
            }
        } else {
            log.warn((Object)("Missing port for HA configuration. Using default port" + defaultPort));
        }
        return defaultPort;
    }

    private static int readReconnectionInterval(OMElement transport) {
        int interval;
        OMElement reconnectionInterval = transport.getFirstChildWithName(new QName("reconnectionInterval"));
        if (reconnectionInterval != null && reconnectionInterval.getText() != null && !reconnectionInterval.getText().trim().equals("")) {
            try {
                return Integer.parseInt(reconnectionInterval.getText().trim());
            }
            catch (NumberFormatException e) {
                interval = 20000;
                log.warn((Object)("Invalid reconnection interval for HA configuration. Using default: " + interval), (Throwable)e);
            }
        } else {
            interval = 20000;
            log.warn((Object)("Missing reconnection interval for HA configuration. Using default: " + interval));
        }
        return interval;
    }

    public static boolean isPowerOfTwo(int value) {
        while (value % 2 == 0 && value > 1) {
            value /= 2;
        }
        return value == 1;
    }

    public static String readOMElementValue(OMElement parentElement, String elementName) {
        OMElement element = parentElement.getFirstChildWithName(new QName(elementName));
        String elementValue = null;
        if (!element.getText().trim().isEmpty()) {
            elementValue = element.getText();
        }
        return elementValue;
    }
}

