/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.manager.core.internal.thrift;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.event.processor.manager.commons.utils.HostAndPort;
import org.wso2.carbon.event.processor.manager.core.internal.ManagementServiceClient;
import org.wso2.carbon.event.processor.manager.core.internal.thrift.data.SnapshotData;
import org.wso2.carbon.event.processor.manager.core.internal.thrift.exception.InternalServerException;
import org.wso2.carbon.event.processor.manager.core.internal.thrift.service.ManagementService;

public class ManagementServiceClientThriftImpl
implements ManagementServiceClient {
    private static final Log log = LogFactory.getLog(ManagementServiceClientThriftImpl.class);

    @Override
    public byte[] getSnapshot(HostAndPort activeMember) {
        TSocket receiverTransport = new TSocket(activeMember.getHostName(), activeMember.getPort());
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)receiverTransport);
        ManagementService.Client client = new ManagementService.Client((TProtocol)protocol);
        try {
            receiverTransport.open();
        }
        catch (TTransportException e) {
            throw new RuntimeException("Error in connecting to " + activeMember.getHostName() + ":" + activeMember.getPort());
        }
        try {
            log.info((Object)("Requesting snapshot from " + activeMember.getHostName() + ":" + activeMember.getPort()));
            SnapshotData snapshotDataIn = client.takeSnapshot();
            log.info((Object)"Snapshot received.");
            return snapshotDataIn.getState();
        }
        catch (InternalServerException e) {
            throw new RuntimeException("Internal server error occurred at CEP member :" + activeMember.getHostName() + ":" + activeMember.getPort() + ", " + e.getMessage());
        }
        catch (TException e) {
            throw new RuntimeException("Thrift error occurred when communicating to CEP member :" + activeMember.getHostName() + ":" + activeMember.getPort() + ", " + e.getMessage());
        }
    }
}

