/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.manager.core.internal;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.wso2.carbon.event.processor.manager.core.EventProcessorManagementService;
import org.wso2.carbon.event.processor.manager.core.internal.ds.EventManagementServiceValueHolder;

public class PersistenceManager
implements Runnable {
    private final ScheduledExecutorService scheduledExecutorService;
    private final long interval;
    private ScheduledFuture<?> scheduledFuture = null;

    public PersistenceManager(ScheduledExecutorService scheduledExecutorService, long interval) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.interval = interval;
    }

    public void init() {
        if (this.interval > 0L) {
            this.scheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(this, this.interval, this.interval, TimeUnit.MINUTES);
        }
    }

    public void shutdown() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        this.persist();
        this.scheduledExecutorService.shutdown();
    }

    @Override
    public void run() {
        this.persist();
    }

    private void persist() {
        EventProcessorManagementService eventProcessorManagementService = EventManagementServiceValueHolder.getCarbonEventManagementService().getEventProcessorManagementService();
        eventProcessorManagementService.persist();
    }
}

