/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.manager.core.internal;

import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.event.processor.manager.commons.utils.ByteSerializer;
import org.wso2.carbon.event.processor.manager.commons.utils.HostAndPort;
import org.wso2.carbon.event.processor.manager.core.EventProcessorManagementService;
import org.wso2.carbon.event.processor.manager.core.EventPublisherManagementService;
import org.wso2.carbon.event.processor.manager.core.EventReceiverManagementService;
import org.wso2.carbon.event.processor.manager.core.Manager;
import org.wso2.carbon.event.processor.manager.core.config.HAConfiguration;
import org.wso2.carbon.event.processor.manager.core.config.PersistenceConfiguration;
import org.wso2.carbon.event.processor.manager.core.exception.EventManagementException;
import org.wso2.carbon.event.processor.manager.core.internal.CarbonEventManagementService;
import org.wso2.carbon.event.processor.manager.core.internal.EventHandler;
import org.wso2.carbon.event.processor.manager.core.internal.ds.EventManagementServiceValueHolder;
import org.wso2.carbon.event.processor.manager.core.internal.thrift.ManagementServiceClientThriftImpl;
import org.wso2.carbon.event.processor.manager.core.internal.thrift.ManagementServiceImpl;
import org.wso2.carbon.event.processor.manager.core.internal.thrift.service.ManagementService;

public class HAManager {
    private static final Log log = LogFactory.getLog(HAManager.class);
    private final ScheduledExecutorService executorService;
    private final EventHandler receiverEventHandler;
    private final EventHandler presenterEventHandler;
    private final SnapshotServer snapshotServer;
    private HAConfiguration haConfiguration;
    private boolean activeLockAcquired;
    private boolean passiveLockAcquired;
    private boolean isBackup;
    private boolean synced;
    private ILock activeLock;
    private ILock passiveLock;
    private IMap<String, HAConfiguration> roleToMembershipMap;
    private Future stateChanger = null;
    private String activeId;
    private String passiveId;
    private HAConfiguration otherMember;

    public HAManager(HazelcastInstance hazelcastInstance, HAConfiguration haConfiguration, ScheduledExecutorService executorService, EventHandler receiverEventHandler, EventHandler presenterEventHandler) {
        this.haConfiguration = haConfiguration;
        this.executorService = executorService;
        this.receiverEventHandler = receiverEventHandler;
        this.presenterEventHandler = presenterEventHandler;
        this.activeId = "org.wso2.cep.org.wso2.carbon.event.processor.managementActive";
        this.passiveId = "org.wso2.cep.org.wso2.carbon.event.processor.managementPassive";
        this.activeLock = hazelcastInstance.getLock(this.activeId);
        this.passiveLock = hazelcastInstance.getLock(this.passiveId);
        this.haConfiguration.setMemberUuid(hazelcastInstance.getCluster().getLocalMember().getUuid());
        presenterEventHandler.allowEventSync(false);
        this.snapshotServer = new SnapshotServer();
        this.snapshotServer.start(haConfiguration);
        this.roleToMembershipMap = hazelcastInstance.getMap("org.wso2.cep.org.wso2.carbon.event.processor.managementrole_membership_map");
        this.roleToMembershipMap.addEntryListener((EntryListener)new EntryAdapter<String, HAConfiguration>(){

            public void entryRemoved(EntryEvent<String, HAConfiguration> stringCEPMembershipEntryEvent) {
                HAManager.this.tryChangeState();
            }
        }, (Object)this.activeId, false);
    }

    public void init() {
        this.tryChangeState();
        if (!this.activeLockAcquired) {
            this.executorService.execute(new PeriodicStateChanger());
        }
    }

    public void tryChangeState() {
        if (!(this.activeLockAcquired || this.passiveLockAcquired || this.isBackup)) {
            if (this.passiveLock.tryLock()) {
                this.passiveLockAcquired = true;
                if (this.activeLock.tryLock()) {
                    this.activeLockAcquired = true;
                    this.becomeActive();
                    this.passiveLockAcquired = false;
                    this.passiveLock.forceUnlock();
                } else {
                    this.becomePassive();
                    this.isBackup = false;
                }
            } else {
                this.becomeBackup();
                this.isBackup = true;
            }
        } else if (!this.activeLockAcquired && !this.passiveLockAcquired) {
            if (this.passiveLock.tryLock()) {
                this.passiveLockAcquired = true;
                if (this.activeLock.tryLock()) {
                    this.activeLockAcquired = true;
                    this.becomeActive();
                    this.passiveLockAcquired = false;
                    this.passiveLock.forceUnlock();
                } else {
                    this.becomePassive();
                    this.isBackup = false;
                }
            }
        } else if (!this.activeLockAcquired && !this.isBackup && this.activeLock.tryLock()) {
            this.activeLockAcquired = true;
            this.becomeActive();
            this.passiveLockAcquired = false;
            this.passiveLock.forceUnlock();
        }
        this.haConfiguration.setActive(this.activeLockAcquired);
    }

    public void verifyState() {
        if (this.activeLockAcquired && !((HAConfiguration)this.roleToMembershipMap.get((Object)this.activeId)).getMemberUuid().equalsIgnoreCase(this.haConfiguration.getMemberUuid())) {
            if (this.passiveLock.tryLock()) {
                this.passiveLockAcquired = true;
                this.activeLockAcquired = false;
                this.becomePassive();
                this.isBackup = false;
                this.executorService.execute(new PeriodicStateChanger());
            } else {
                this.passiveLockAcquired = false;
                this.activeLockAcquired = false;
                this.becomeBackup();
                this.isBackup = true;
                this.executorService.execute(new PeriodicStateChanger());
            }
        }
        this.haConfiguration.setActive(this.activeLockAcquired);
    }

    public byte[] getState() {
        HAConfiguration passiveMember;
        CarbonEventManagementService eventManagementService = EventManagementServiceValueHolder.getCarbonEventManagementService();
        EventReceiverManagementService eventReceiverManagementService = eventManagementService.getEventReceiverManagementService();
        EventProcessorManagementService eventProcessorManagementService = eventManagementService.getEventProcessorManagementService();
        this.otherMember = passiveMember = (HAConfiguration)this.roleToMembershipMap.get((Object)this.passiveId);
        HashMap<Manager.ManagerType, byte[]> stateMap = new HashMap<Manager.ManagerType, byte[]>();
        this.receiverEventHandler.addEventPublisher(passiveMember.getEventSyncConfig());
        if (eventProcessorManagementService != null) {
            eventProcessorManagementService.pause();
        }
        if (eventReceiverManagementService != null) {
            eventReceiverManagementService.pause();
            byte[] receiverState = eventReceiverManagementService.getState();
            stateMap.put(Manager.ManagerType.Receiver, receiverState);
        }
        if (eventProcessorManagementService != null) {
            byte[] processorState = eventProcessorManagementService.getState();
            stateMap.put(Manager.ManagerType.Processor, processorState);
        }
        byte[] state = ByteSerializer.OToB(stateMap);
        if (eventProcessorManagementService != null) {
            eventProcessorManagementService.resume();
        }
        if (eventReceiverManagementService != null) {
            eventReceiverManagementService.resume();
        }
        return state;
    }

    public void shutdown() {
        CarbonEventManagementService eventManagementService = EventManagementServiceValueHolder.getCarbonEventManagementService();
        if (this.passiveLockAcquired) {
            this.roleToMembershipMap.remove((Object)this.passiveId);
            this.passiveLock.forceUnlock();
        }
        if (this.activeLockAcquired) {
            this.roleToMembershipMap.remove((Object)this.activeId);
            this.activeLock.forceUnlock();
        }
        this.stateChanger.cancel(false);
        if (this.snapshotServer != null) {
            this.snapshotServer.shutDown();
        }
        eventManagementService.stopPersistence();
    }

    private void becomeActive() {
        CarbonEventManagementService eventManagementService = EventManagementServiceValueHolder.getCarbonEventManagementService();
        EventReceiverManagementService eventReceiverManagementService = eventManagementService.getEventReceiverManagementService();
        List<EventPublisherManagementService> eventPublisherManagementService = eventManagementService.getEventPublisherManagementService();
        EventProcessorManagementService eventProcessorManagementService = eventManagementService.getEventProcessorManagementService();
        this.roleToMembershipMap.set((Object)this.activeId, (Object)this.haConfiguration);
        this.otherMember = null;
        PersistenceConfiguration persistenceConfiguration = eventManagementService.getManagementModeInfo().getPersistenceConfiguration();
        if (!this.synced && persistenceConfiguration != null && persistenceConfiguration.isPersistenceEnabled()) {
            eventProcessorManagementService.restoreLastState();
            log.info((Object)"Restored to Last Known State.");
        }
        if (eventPublisherManagementService != null) {
            for (EventPublisherManagementService service : eventPublisherManagementService) {
                service.setDrop(false);
            }
        }
        if (eventReceiverManagementService != null) {
            eventReceiverManagementService.start();
        }
        this.receiverEventHandler.allowContinueProcess(true);
        this.presenterEventHandler.allowEventSync(true);
        eventManagementService.initPersistence();
        log.info((Object)"Became CEP HA Active Member");
    }

    private void becomePassive() {
        try {
            HAConfiguration activeMember;
            this.roleToMembershipMap.set((Object)this.passiveId, (Object)this.haConfiguration);
            this.otherMember = activeMember = (HAConfiguration)this.roleToMembershipMap.get((Object)this.activeId);
            final CarbonEventManagementService eventManagementService = EventManagementServiceValueHolder.getCarbonEventManagementService();
            this.receiverEventHandler.addEventPublisher(activeMember.getEventSyncConfig());
            this.receiverEventHandler.allowContinueProcess(true);
            this.presenterEventHandler.allowEventSync(false);
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            log.info((Object)"CEP HA State syncing started..");
                            HAManager.this.syncState(activeMember, eventManagementService);
                            log.info((Object)"CEP HA State successfully synced.");
                            return;
                        }
                        catch (EventManagementException e) {
                            log.error((Object)("CEP HA State syncing failed, " + e.getMessage()), (Throwable)e);
                            try {
                                Thread.sleep(HAManager.this.haConfiguration.getManagementStateSyncRetryInterval());
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            continue;
                        }
                        break;
                    }
                }
            });
            log.info((Object)"Became CEP HA Passive Member");
        }
        catch (Exception ex) {
            log.error((Object)"Error while setting the member as passive member. ", (Throwable)ex);
        }
    }

    private void becomeBackup() {
        CarbonEventManagementService eventManagementService = EventManagementServiceValueHolder.getCarbonEventManagementService();
        HAConfiguration activeMember = (HAConfiguration)this.roleToMembershipMap.get((Object)this.passiveId);
        this.receiverEventHandler.addEventPublisher(activeMember.getEventSyncConfig());
        HAConfiguration passiveMember = (HAConfiguration)this.roleToMembershipMap.get((Object)this.passiveId);
        this.receiverEventHandler.addEventPublisher(passiveMember.getEventSyncConfig());
        this.presenterEventHandler.allowEventSync(false);
        log.info((Object)"Became CEP HA Backup Member");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncState(HAConfiguration activeMember, CarbonEventManagementService eventManagementService) {
        EventReceiverManagementService eventReceiverManagementService = eventManagementService.getEventReceiverManagementService();
        EventProcessorManagementService eventProcessorManagementService = eventManagementService.getEventProcessorManagementService();
        List<EventPublisherManagementService> eventPublisherManagementService = eventManagementService.getEventPublisherManagementService();
        if (eventReceiverManagementService != null) {
            eventReceiverManagementService.start();
            eventReceiverManagementService.pause();
        }
        if (eventProcessorManagementService != null) {
            eventProcessorManagementService.pause();
        }
        if (eventPublisherManagementService != null) {
            for (EventPublisherManagementService service : eventPublisherManagementService) {
                service.setDrop(true);
            }
        }
        ManagementServiceClientThriftImpl client = new ManagementServiceClientThriftImpl();
        byte[] state = null;
        try {
            state = client.getSnapshot(activeMember.getManagementConfig());
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        HashMap stateMap = (HashMap)ByteSerializer.BToO((byte[])state);
        try {
            if (eventProcessorManagementService != null) {
                eventProcessorManagementService.restoreState((byte[])stateMap.get((Object)Manager.ManagerType.Processor));
            }
            if (eventReceiverManagementService != null) {
                eventReceiverManagementService.syncState((byte[])stateMap.get((Object)Manager.ManagerType.Receiver));
            }
            this.synced = true;
        }
        finally {
            if (eventProcessorManagementService != null) {
                eventProcessorManagementService.resume();
            }
            if (eventReceiverManagementService != null) {
                eventReceiverManagementService.resume();
            }
        }
    }

    class SnapshotServer {
        private TServer dataReceiverServer;

        SnapshotServer() {
        }

        public void start(HAConfiguration config) {
            HostAndPort management = config.getManagementConfig();
            try {
                TServerSocket serverTransport = new TServerSocket(new InetSocketAddress(management.getHostName(), management.getPort()));
                ManagementService.Processor<ManagementServiceImpl> processor = new ManagementService.Processor<ManagementServiceImpl>(new ManagementServiceImpl());
                this.dataReceiverServer = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor(processor));
                Thread thread = new Thread(new ServerThread(this.dataReceiverServer));
                log.info((Object)("CEP HA Snapshot Server started on " + management.getHostName() + ":" + management.getPort()));
                thread.start();
            }
            catch (TTransportException e) {
                log.error((Object)("Cannot start CEP HA Snapshot Server on port " + management.getHostName() + ":" + management.getPort()), (Throwable)e);
            }
            catch (Throwable e) {
                log.error((Object)"Error in starting CEP HA Snapshot Server ", e);
            }
        }

        public void shutDown() {
            this.dataReceiverServer.stop();
        }

        class ServerThread
        implements Runnable {
            private TServer server;

            ServerThread(TServer server) {
                this.server = server;
            }

            @Override
            public void run() {
                this.server.serve();
            }
        }
    }

    class PeriodicStateChanger
    implements Runnable {
        PeriodicStateChanger() {
        }

        @Override
        public void run() {
            HAManager.this.tryChangeState();
            if (!HAManager.this.activeLockAcquired) {
                HAManager.this.stateChanger = HAManager.this.executorService.schedule(this, HAManager.this.haConfiguration.getManagementTryStateChangeInterval(), TimeUnit.MILLISECONDS);
            }
        }
    }
}

