/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.manager.core.internal;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.event.processor.manager.commons.transport.client.TCPEventPublisher;
import org.wso2.carbon.event.processor.manager.commons.transport.client.TCPEventPublisherConfig;
import org.wso2.carbon.event.processor.manager.commons.transport.server.StreamCallback;
import org.wso2.carbon.event.processor.manager.commons.transport.server.TCPEventServer;
import org.wso2.carbon.event.processor.manager.commons.transport.server.TCPEventServerConfig;
import org.wso2.carbon.event.processor.manager.commons.utils.HostAndPort;
import org.wso2.carbon.event.processor.manager.core.EventManagementUtil;
import org.wso2.carbon.event.processor.manager.core.EventSync;
import org.wso2.carbon.event.processor.manager.core.internal.ds.EventManagementServiceValueHolder;

public class EventHandler {
    private static Log log = LogFactory.getLog(EventHandler.class);
    private TCPEventServer tcpEventServer = null;
    private IMap<String, HostAndPort> members = null;
    private ConcurrentHashMap<HostAndPort, TCPEventPublisher> tcpEventPublisherPool = new ConcurrentHashMap();
    private ConcurrentHashMap<String, EventSync> eventSyncMap = new ConcurrentHashMap();
    private HostAndPort localMember;
    private TCPEventPublisherConfig localEventPublisherConfiguration;
    private boolean allowEventSync = true;
    private boolean isMemberNode;
    private boolean allowContinueProcess = false;

    public void init(String memberType, HostAndPort localMember, TCPEventPublisherConfig localEventPublisherConfiguration, boolean isMemberNode) {
        this.isMemberNode = isMemberNode;
        HazelcastInstance hazelcastInstance = EventManagementServiceValueHolder.getHazelcastInstance();
        this.members = hazelcastInstance.getMap(memberType);
        this.localMember = localMember;
        this.registerLocalMember();
        this.localEventPublisherConfiguration = localEventPublisherConfiguration;
    }

    public void registerLocalMember() {
        if (this.isMemberNode && this.members != null) {
            this.members.set((Object)EventManagementServiceValueHolder.getHazelcastInstance().getCluster().getLocalMember().getUuid(), (Object)this.localMember);
        }
    }

    public void removeMember(String uuid) {
        if (this.members != null) {
            this.members.remove((Object)uuid);
        }
    }

    public void shutdown() {
        if (this.members != null) {
            this.members.remove((Object)EventManagementServiceValueHolder.getHazelcastInstance().getCluster().getLocalMember().getUuid());
        }
        for (TCPEventPublisher publisher : this.tcpEventPublisherPool.values()) {
            publisher.shutdown();
        }
        if (this.tcpEventServer != null) {
            this.tcpEventServer.shutdown();
        }
    }

    public void syncEvent(String syncId, Event event) {
        if (this.allowEventSync) {
            for (TCPEventPublisher publisher : this.tcpEventPublisherPool.values()) {
                if (publisher == null) continue;
                try {
                    Object[] eventData = ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])event.getMetaData(), (Object[])event.getCorrelationData()), (Object[])event.getPayloadData());
                    publisher.sendEvent(syncId, event.getTimeStamp(), eventData, event.getArbitraryDataMap(), true);
                }
                catch (IOException e) {
                    log.error((Object)("Error sending sync events to " + syncId), (Throwable)e);
                }
            }
        }
    }

    public synchronized void registerEventSync(EventSync eventSync) {
        if (this.allowContinueProcess) {
            eventSync.setContinueProcess(this.allowContinueProcess);
        }
        this.eventSyncMap.putIfAbsent(EventManagementUtil.getSyncIdFromDatabridgeStream(eventSync.getStreamDefinition()), eventSync);
        for (TCPEventPublisher tcpEventPublisher : this.tcpEventPublisherPool.values()) {
            tcpEventPublisher.addStreamDefinition(EventManagementUtil.constructStreamDefinition(EventManagementUtil.getSyncIdFromDatabridgeStream(eventSync.getStreamDefinition()), eventSync.getStreamDefinition()));
        }
        if (this.tcpEventServer != null) {
            this.tcpEventServer.addStreamDefinition(EventManagementUtil.constructStreamDefinition(EventManagementUtil.getSyncIdFromDatabridgeStream(eventSync.getStreamDefinition()), eventSync.getStreamDefinition()));
        }
    }

    public void unregisterEventSync(String syncId) {
        EventSync eventSync = this.eventSyncMap.remove(syncId);
        if (eventSync != null) {
            for (TCPEventPublisher tcpEventPublisher : this.tcpEventPublisherPool.values()) {
                tcpEventPublisher.removeStreamDefinition(EventManagementUtil.constructStreamDefinition(EventManagementUtil.getSyncIdFromDatabridgeStream(eventSync.getStreamDefinition()), eventSync.getStreamDefinition()));
            }
            if (this.tcpEventServer != null) {
                this.tcpEventServer.removeStreamDefinition(EventManagementUtil.getSyncIdFromDatabridgeStream(eventSync.getStreamDefinition()));
            }
        }
    }

    public void startServer(HostAndPort member) {
        if (this.tcpEventServer == null) {
            TCPEventServerConfig tcpEventServerConfig = new TCPEventServerConfig(member.getHostName(), member.getPort());
            this.tcpEventServer = new TCPEventServer(tcpEventServerConfig, new StreamCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void receive(String streamId, long timestamp, Object[] event, Map<String, String> arbitraryMapData) {
                    int index = streamId.indexOf("/");
                    if (index != -1) {
                        int tenantId = Integer.parseInt(streamId.substring(0, index));
                        try {
                            PrivilegedCarbonContext.startTenantFlow();
                            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
                            PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
                            EventSync eventSync = (EventSync)EventHandler.this.eventSyncMap.get(streamId);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Event Received to :" + streamId));
                            }
                            if (eventSync != null) {
                                eventSync.process(EventManagementUtil.getWso2Event(eventSync.getOriginalEventStreamId(), eventSync.getStreamDefinition(), timestamp, event));
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)("Unable to process events for tenant :" + tenantId + " on stream:" + streamId.substring(index)), (Throwable)e);
                        }
                        finally {
                            PrivilegedCarbonContext.endTenantFlow();
                        }
                    }
                }
            }, null);
            for (EventSync eventSync : this.eventSyncMap.values()) {
                this.tcpEventServer.addStreamDefinition(EventManagementUtil.constructStreamDefinition(EventManagementUtil.getSyncIdFromDatabridgeStream(eventSync.getStreamDefinition()), eventSync.getStreamDefinition()));
            }
            try {
                this.tcpEventServer.start();
                log.info((Object)("Event Management TCPEventServer for EventReceiver started on port " + member.getPort()));
            }
            catch (IOException e) {
                log.error((Object)("Unable to start TCPEventServer for EventReceiver started on port " + member.getPort()));
            }
        }
    }

    public void checkMemberUpdate() {
        this.cleanupMembers();
        this.updateEventPublishers();
    }

    private synchronized void updateEventPublishers() {
        if (this.members != null) {
            ArrayList memberList = new ArrayList(this.members.values());
            memberList.remove(this.localMember);
            ArrayList currentMembers = new ArrayList(this.tcpEventPublisherPool.keySet());
            for (HostAndPort member : memberList) {
                if (currentMembers.remove(member)) continue;
                this.addEventPublisher(member);
            }
            for (HostAndPort member : currentMembers) {
                this.removeEventPublisher(member);
            }
        }
    }

    public synchronized void addEventPublisher(HostAndPort member) {
        try {
            if (!this.tcpEventPublisherPool.containsKey(member)) {
                TCPEventPublisher tcpEventPublisher = new TCPEventPublisher(member.getHostName() + ":" + member.getPort(), this.localEventPublisherConfiguration, false, null);
                for (EventSync eventSync : this.eventSyncMap.values()) {
                    tcpEventPublisher.addStreamDefinition(EventManagementUtil.constructStreamDefinition(EventManagementUtil.getSyncIdFromDatabridgeStream(eventSync.getStreamDefinition()), eventSync.getStreamDefinition()));
                }
                this.tcpEventPublisherPool.putIfAbsent(member, tcpEventPublisher);
                log.info((Object)("CEP sync publisher initiated to Member '" + member.getHostName() + ":" + member.getPort() + "'"));
            }
        }
        catch (IOException e) {
            log.error((Object)("Error occurred while trying to start the publisher: " + e.getMessage()), (Throwable)e);
        }
    }

    private synchronized void removeEventPublisher(HostAndPort member) {
        TCPEventPublisher tcpEventPublisher = this.tcpEventPublisherPool.remove(member);
        if (tcpEventPublisher != null) {
            tcpEventPublisher.shutdown();
            log.info((Object)("CEP sync publisher disconnected from Member '" + member.getHostName() + ":" + member.getPort() + "'"));
        }
    }

    private void cleanupMembers() {
        if (this.members != null) {
            HashSet<String> activeMemberUuidSet = new HashSet<String>();
            for (Member member : EventManagementServiceValueHolder.getHazelcastInstance().getCluster().getMembers()) {
                activeMemberUuidSet.add(member.getUuid());
            }
            ArrayList currentMemberUuidList = new ArrayList(this.members.keySet());
            for (String memberUuid : currentMemberUuidList) {
                if (activeMemberUuidSet.contains(memberUuid)) continue;
                this.members.remove((Object)memberUuid);
            }
        }
    }

    public void allowEventSync(boolean allowEventSync) {
        this.allowEventSync = allowEventSync;
    }

    public synchronized void allowContinueProcess(boolean allowContinueProcess) {
        this.allowContinueProcess = allowContinueProcess;
        for (EventSync eventSync : this.eventSyncMap.values()) {
            eventSync.setContinueProcess(allowContinueProcess);
        }
    }
}

