/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.manager.core.internal;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.event.processor.manager.core.EventManagementService;
import org.wso2.carbon.event.processor.manager.core.EventProcessorManagementService;
import org.wso2.carbon.event.processor.manager.core.EventPublisherManagementService;
import org.wso2.carbon.event.processor.manager.core.EventReceiverManagementService;
import org.wso2.carbon.event.processor.manager.core.EventSync;
import org.wso2.carbon.event.processor.manager.core.Manager;
import org.wso2.carbon.event.processor.manager.core.config.DistributedConfiguration;
import org.wso2.carbon.event.processor.manager.core.config.HAConfiguration;
import org.wso2.carbon.event.processor.manager.core.config.ManagementModeInfo;
import org.wso2.carbon.event.processor.manager.core.config.Mode;
import org.wso2.carbon.event.processor.manager.core.config.PersistenceConfiguration;
import org.wso2.carbon.event.processor.manager.core.exception.EventManagementException;
import org.wso2.carbon.event.processor.manager.core.exception.ManagementConfigurationException;
import org.wso2.carbon.event.processor.manager.core.internal.EventHandler;
import org.wso2.carbon.event.processor.manager.core.internal.HAManager;
import org.wso2.carbon.event.processor.manager.core.internal.PersistenceManager;
import org.wso2.carbon.event.processor.manager.core.internal.StormReceiverCoordinator;
import org.wso2.carbon.event.processor.manager.core.internal.ds.EventManagementServiceValueHolder;
import org.wso2.carbon.event.processor.manager.core.internal.util.ManagementModeConfigurationLoader;
import org.wso2.carbon.utils.ConfigurationContextService;

public class CarbonEventManagementService
implements EventManagementService {
    private static Log log = LogFactory.getLog(CarbonEventManagementService.class);
    private Mode mode = Mode.SingleNode;
    private ManagementModeInfo managementModeInfo;
    private EventProcessorManagementService processorManager;
    private EventReceiverManagementService receiverManager;
    private List<EventPublisherManagementService> publisherManager;
    private EventHandler receiverEventHandler = new EventHandler();
    private EventHandler presenterEventHandler = new EventHandler();
    private ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(3);
    private HAManager haManager = null;
    private IMap<String, Long> haEventPublisherTimeSyncMap = null;
    private PersistenceManager persistenceManager = null;
    private StormReceiverCoordinator stormReceiverCoordinator = null;
    private boolean isManagerNode = false;
    private boolean isWorkerNode = false;
    private boolean isPresenterNode = false;

    public CarbonEventManagementService() {
        try {
            this.managementModeInfo = ManagementModeConfigurationLoader.loadManagementModeInfo();
            this.mode = this.managementModeInfo.getMode();
            this.publisherManager = new CopyOnWriteArrayList<EventPublisherManagementService>();
        }
        catch (ManagementConfigurationException e) {
            throw new EventManagementException("Error getting management mode information", e);
        }
        if (this.mode == Mode.HA) {
            HAConfiguration haConfiguration = this.managementModeInfo.getHaConfiguration();
            this.isWorkerNode = haConfiguration.isWorkerNode();
            this.isPresenterNode = haConfiguration.isPresenterNode();
            if (this.isWorkerNode) {
                PersistenceConfiguration persistConfig = this.managementModeInfo.getPersistenceConfiguration();
                if (persistConfig != null) {
                    ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(persistConfig.getThreadPoolSize());
                    long persistenceTimeInterval = persistConfig.getPersistenceTimeInterval();
                    if (persistenceTimeInterval > 0L) {
                        this.persistenceManager = new PersistenceManager(scheduledExecutorService, persistenceTimeInterval);
                    }
                }
                this.receiverEventHandler.startServer(haConfiguration.getEventSyncConfig());
            }
            if (this.isPresenterNode && !this.isWorkerNode) {
                this.presenterEventHandler.startServer(haConfiguration.getLocalPresenterConfig());
            }
        } else if (this.mode == Mode.SingleNode) {
            PersistenceConfiguration persistConfig = this.managementModeInfo.getPersistenceConfiguration();
            if (persistConfig != null) {
                ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(persistConfig.getThreadPoolSize());
                long persistenceTimeInterval = persistConfig.getPersistenceTimeInterval();
                if (persistenceTimeInterval > 0L) {
                    this.persistenceManager = new PersistenceManager(scheduledExecutorService, persistenceTimeInterval);
                    this.persistenceManager.init();
                }
            }
        } else if (this.mode == Mode.Distributed) {
            DistributedConfiguration distributedConfiguration = this.managementModeInfo.getDistributedConfiguration();
            this.isManagerNode = distributedConfiguration.isManagerNode();
            this.isWorkerNode = distributedConfiguration.isWorkerNode();
            if (this.isWorkerNode) {
                this.stormReceiverCoordinator = new StormReceiverCoordinator();
            }
            this.isPresenterNode = distributedConfiguration.isPresenterNode();
            if (this.isPresenterNode) {
                this.presenterEventHandler.startServer(distributedConfiguration.getLocalPresenterConfig());
            }
        }
    }

    public void init(HazelcastInstance hazelcastInstance) {
        if (this.mode == Mode.HA) {
            HAConfiguration haConfiguration = this.managementModeInfo.getHaConfiguration();
            if (this.isWorkerNode) {
                if (!this.validateHostName(haConfiguration.getEventSyncConfig().getHostName())) {
                    log.error((Object)("Hostname : " + haConfiguration.getEventSyncConfig().getHostName() + " defined for eventSync configuration is invalid. Please add proper IP address of the node. This IP address is used by other nodes in the cluster to communicate."));
                }
                if (!this.validateHostName(haConfiguration.getManagementConfig().getHostName())) {
                    log.error((Object)("Hostname : " + haConfiguration.getManagementConfig().getHostName() + " defined for management configuration is invalid. Please add proper IP address of the node. This IP address is used by other nodes in the cluster to communicate."));
                }
                this.receiverEventHandler.init("org.wso2.cep.org.wso2.carbon.event.processor.managementreceivers", haConfiguration.getEventSyncConfig(), haConfiguration.constructEventSyncPublisherConfig(), this.isWorkerNode);
                this.haManager = new HAManager(hazelcastInstance, haConfiguration, this.executorService, this.receiverEventHandler, this.presenterEventHandler);
                this.haManager.init();
                if (this.haEventPublisherTimeSyncMap == null) {
                    this.haEventPublisherTimeSyncMap = EventManagementServiceValueHolder.getHazelcastInstance().getMap("haEventPublisherTimeSyncMap");
                }
            }
            if (this.isPresenterNode && !this.validateHostName(haConfiguration.getLocalPresenterConfig().getHostName())) {
                log.error((Object)("Hostname : " + haConfiguration.getLocalPresenterConfig().getHostName() + " defined for presentation purpose is invalid. Please add proper IP address of the node. This IP address is used by other nodes in the cluster to communicate."));
            }
            this.presenterEventHandler.init("org.wso2.cep.org.wso2.carbon.event.processor.managementpresenters", haConfiguration.getLocalPresenterConfig(), haConfiguration.constructPresenterPublisherConfig(), this.isPresenterNode && !this.isWorkerNode);
            this.checkMemberUpdate();
        } else if (this.mode == Mode.Distributed) {
            if (this.stormReceiverCoordinator != null) {
                this.stormReceiverCoordinator.tryBecomeCoordinator();
            }
            DistributedConfiguration distributedConfiguration = this.managementModeInfo.getDistributedConfiguration();
            this.presenterEventHandler.init("org.wso2.cep.org.wso2.carbon.event.processor.managementpresenters", distributedConfiguration.getLocalPresenterConfig(), distributedConfiguration.constructPresenterPublisherConfig(), this.isPresenterNode);
            this.checkMemberUpdate();
        } else if (this.mode == Mode.SingleNode) {
            log.warn((Object)"CEP started with clustering enabled, but SingleNode configuration given.");
        }
        hazelcastInstance.getCluster().addMembershipListener(new MembershipListener(){

            public void memberAdded(MembershipEvent membershipEvent) {
                CarbonEventManagementService.this.presenterEventHandler.registerLocalMember();
                CarbonEventManagementService.this.receiverEventHandler.registerLocalMember();
                CarbonEventManagementService.this.checkMemberUpdate();
                if (CarbonEventManagementService.this.mode == Mode.HA && CarbonEventManagementService.this.isWorkerNode && CarbonEventManagementService.this.haManager != null) {
                    CarbonEventManagementService.this.haManager.verifyState();
                }
            }

            public void memberRemoved(MembershipEvent membershipEvent) {
                CarbonEventManagementService.this.receiverEventHandler.removeMember(membershipEvent.getMember().getUuid());
                CarbonEventManagementService.this.presenterEventHandler.removeMember(membershipEvent.getMember().getUuid());
                CarbonEventManagementService.this.checkMemberUpdate();
                if (CarbonEventManagementService.this.mode == Mode.HA) {
                    if (CarbonEventManagementService.this.isWorkerNode && CarbonEventManagementService.this.haManager != null) {
                        CarbonEventManagementService.this.haManager.tryChangeState();
                    }
                } else if (CarbonEventManagementService.this.mode == Mode.Distributed && CarbonEventManagementService.this.stormReceiverCoordinator != null) {
                    CarbonEventManagementService.this.stormReceiverCoordinator.tryBecomeCoordinator();
                }
            }

            public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            }
        });
    }

    private boolean validateHostName(String hostname) {
        return !hostname.trim().equals("0.0.0.0") && !hostname.trim().equals("localhost") && !hostname.trim().equals("127.0.0.1") && !hostname.trim().equals("::1");
    }

    public void init(ConfigurationContextService configurationContextService) {
        if ((this.mode == Mode.SingleNode || this.isWorkerNode) && this.receiverManager != null) {
            this.receiverManager.start();
        }
        if (((this.mode == Mode.Distributed || this.mode == Mode.HA) && this.isWorkerNode || this.mode == Mode.SingleNode) && this.receiverManager != null) {
            this.executorService.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        log.info((Object)"Starting polling event receivers");
                        EventReceiverManagementService eventReceiverManagementService = CarbonEventManagementService.this.getEventReceiverManagementService();
                        if (eventReceiverManagementService != null) {
                            eventReceiverManagementService.startPolling();
                        } else {
                            log.error((Object)"Adapter polling failed as EventReceiverManagementService not available");
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Unexpected error occurred when start polling event adapters", (Throwable)e);
                    }
                }
            }, 40000L, TimeUnit.MILLISECONDS);
        }
        int checkMemberUpdateInterval = 10000;
        if (this.mode == Mode.Distributed) {
            DistributedConfiguration distributedConfiguration = this.managementModeInfo.getDistributedConfiguration();
            checkMemberUpdateInterval = distributedConfiguration.getMemberUpdateCheckInterval();
        } else if (this.mode == Mode.HA) {
            HAConfiguration haConfiguration = this.managementModeInfo.getHaConfiguration();
            checkMemberUpdateInterval = haConfiguration.getCheckMemberUpdateInterval();
        }
        if (this.mode == Mode.Distributed || this.mode == Mode.HA) {
            this.executorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    CarbonEventManagementService.this.checkMemberUpdate();
                }
            }, checkMemberUpdateInterval, checkMemberUpdateInterval, TimeUnit.MILLISECONDS);
        }
    }

    public void shutdown() {
        if (this.haManager != null) {
            this.haManager.shutdown();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.persistenceManager != null) {
            this.persistenceManager.shutdown();
        }
        this.receiverEventHandler.shutdown();
        this.presenterEventHandler.shutdown();
    }

    public byte[] getState() {
        if (this.mode == Mode.HA && this.isWorkerNode) {
            return this.haManager.getState();
        }
        return null;
    }

    @Override
    public ManagementModeInfo getManagementModeInfo() {
        return this.managementModeInfo;
    }

    @Override
    public void subscribe(Manager manager) {
        if (manager.getType() == Manager.ManagerType.Processor) {
            this.processorManager = (EventProcessorManagementService)manager;
        } else if (manager.getType() == Manager.ManagerType.Receiver) {
            this.receiverManager = (EventReceiverManagementService)manager;
        } else if (manager.getType() == Manager.ManagerType.Publisher) {
            this.publisherManager.add((EventPublisherManagementService)manager);
        }
    }

    @Override
    public void unsubscribe(Manager manager) {
        if (manager.getType() == Manager.ManagerType.Processor) {
            this.processorManager = null;
        } else if (manager.getType() == Manager.ManagerType.Receiver) {
            this.receiverManager = null;
        } else if (manager.getType() == Manager.ManagerType.Publisher) {
            this.publisherManager.remove(manager);
        }
    }

    @Override
    public void syncEvent(String syncId, Manager.ManagerType type, Event event) {
        if (type == Manager.ManagerType.Receiver) {
            this.receiverEventHandler.syncEvent(syncId, event);
        } else {
            this.presenterEventHandler.syncEvent(syncId, event);
        }
    }

    @Override
    public void registerEventSync(EventSync eventSync, Manager.ManagerType type) {
        if (type == Manager.ManagerType.Receiver) {
            this.receiverEventHandler.registerEventSync(eventSync);
        } else {
            this.presenterEventHandler.registerEventSync(eventSync);
        }
    }

    @Override
    public void unregisterEventSync(String syncId, Manager.ManagerType type) {
        if (type == Manager.ManagerType.Receiver) {
            this.receiverEventHandler.unregisterEventSync(syncId);
        } else {
            this.presenterEventHandler.unregisterEventSync(syncId);
        }
    }

    public EventProcessorManagementService getEventProcessorManagementService() {
        return this.processorManager;
    }

    public EventReceiverManagementService getEventReceiverManagementService() {
        return this.receiverManager;
    }

    public List<EventPublisherManagementService> getEventPublisherManagementService() {
        return this.publisherManager;
    }

    private void checkMemberUpdate() {
        if (this.isWorkerNode) {
            if (this.mode == Mode.HA) {
                this.receiverEventHandler.checkMemberUpdate();
                this.presenterEventHandler.checkMemberUpdate();
            } else if (this.mode == Mode.Distributed) {
                this.presenterEventHandler.checkMemberUpdate();
            }
        }
    }

    @Override
    public void updateLatestEventSentTime(String publisherName, int tenantId, long timestamp) {
        this.haEventPublisherTimeSyncMap.putAsync((Object)(tenantId + "-" + publisherName), (Object)EventManagementServiceValueHolder.getHazelcastInstance().getCluster().getClusterTime());
    }

    @Override
    public long getLatestEventSentTime(String publisherName, int tenantId) {
        Long latestTimePublished;
        if (this.haEventPublisherTimeSyncMap == null) {
            this.haEventPublisherTimeSyncMap = EventManagementServiceValueHolder.getHazelcastInstance().getMap("haEventPublisherTimeSyncMap");
        }
        if ((latestTimePublished = (Long)this.haEventPublisherTimeSyncMap.get((Object)(tenantId + "-" + publisherName))) != null) {
            return latestTimePublished;
        }
        return 0L;
    }

    @Override
    public long getClusterTimeInMillis() {
        if (EventManagementServiceValueHolder.getHazelcastInstance() == null) {
            throw new RuntimeException("No HazelcastInstance found.");
        }
        if (EventManagementServiceValueHolder.getHazelcastInstance().getCluster() == null) {
            throw new RuntimeException("No Cluster was found in the HazelcastInstance.");
        }
        try {
            return EventManagementServiceValueHolder.getHazelcastInstance().getCluster().getClusterTime();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void initPersistence() {
        if (this.persistenceManager != null) {
            this.persistenceManager.init();
        }
    }

    public void stopPersistence() {
        if (this.persistenceManager != null) {
            this.persistenceManager.shutdown();
        }
    }
}

