/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.manager.core.config;

import java.io.Serializable;
import org.wso2.carbon.event.processor.manager.commons.transport.client.TCPEventPublisherConfig;
import org.wso2.carbon.event.processor.manager.commons.utils.HostAndPort;
import org.wso2.carbon.utils.CarbonUtils;

public class HAConfiguration
implements Serializable {
    private boolean workerNode = false;
    private boolean presenterNode = false;
    private HostAndPort localPresenterConfig = new HostAndPort("localhost", 11000);
    private HostAndPort managementConfig = new HostAndPort("localhost", 10005);
    private int managementStateSyncRetryInterval = 10000;
    private long managementTryStateChangeInterval = 15000L;
    private HostAndPort eventSyncConfig = new HostAndPort("localhost", 11224);
    private int eventSyncPublisherTcpSendBufferSize = 0x500000;
    private String eventSyncPublisherCharSet = "UTF-8";
    private int eventSyncPublisherBufferSize = 1024;
    private long eventSyncPublisherConnectionStatusCheckInterval = 30000L;
    private int eventSyncReceiverQueueSize = 1000000;
    private int eventSyncPublisherQueueSize = 1000000;
    private int eventSyncReceiverMaxQueueSizeInMb = 50;
    private int eventSyncPublisherMaxQueueSizeInMb = 50;
    private int presentationPublisherTcpSendBufferSize = 0x500000;
    private String presentationPublisherCharSet = "UTF-8";
    private int presentationPublisherBufferSize = 1024;
    private long presentationPublisherConnectionStatusCheckInterval = 30000L;
    private int checkMemberUpdateInterval = 10000;
    private String memberUuid;
    private boolean isActive = false;
    private static final int carbonXmlportOffset = Integer.parseInt(CarbonUtils.getServerConfiguration().getFirstProperty("Ports.Offset"));
    private static final int commandLinePortOffset = Integer.parseInt(System.getProperty("portOffset") == null ? "0" : System.getProperty("portOffset"));
    private static int portOffset = 0;

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean isWorkerNode() {
        return this.workerNode;
    }

    public void setWorkerNode(boolean workerNode) {
        this.workerNode = workerNode;
    }

    public boolean isPresenterNode() {
        return this.presenterNode;
    }

    public void setPresenterNode(boolean presenterNode) {
        this.presenterNode = presenterNode;
    }

    public HostAndPort getLocalPresenterConfig() {
        return this.localPresenterConfig;
    }

    public void setLocalPresenterConfig(String host, int port) {
        this.localPresenterConfig = new HostAndPort(host, port + portOffset);
    }

    public HostAndPort getManagementConfig() {
        return this.managementConfig;
    }

    public HostAndPort getEventSyncConfig() {
        return this.eventSyncConfig;
    }

    public void setManagement(String host, int port) {
        this.managementConfig = new HostAndPort(host, port + portOffset);
    }

    public void setEventSyncConfig(String host, int port) {
        this.eventSyncConfig = new HostAndPort(host, port + portOffset);
    }

    public String getMemberUuid() {
        return this.memberUuid;
    }

    public void setMemberUuid(String memberUuid) {
        this.memberUuid = memberUuid;
    }

    public int getCheckMemberUpdateInterval() {
        return this.checkMemberUpdateInterval;
    }

    public void setCheckMemberUpdateInterval(int checkMemberUpdateInterval) {
        this.checkMemberUpdateInterval = checkMemberUpdateInterval;
    }

    public int getManagementStateSyncRetryInterval() {
        return this.managementStateSyncRetryInterval;
    }

    public void setManagementStateSyncRetryInterval(int managementStateSyncRetryInterval) {
        this.managementStateSyncRetryInterval = managementStateSyncRetryInterval;
    }

    public long getManagementTryStateChangeInterval() {
        return this.managementTryStateChangeInterval;
    }

    public void setManagementTryStateChangeInterval(long managementTryStateChangeInterval) {
        this.managementTryStateChangeInterval = managementTryStateChangeInterval;
    }

    public int getEventSyncPublisherBufferSize() {
        return this.eventSyncPublisherBufferSize;
    }

    public void setEventSyncPublisherBufferSize(int eventSyncPublisherBufferSize) {
        this.eventSyncPublisherBufferSize = eventSyncPublisherBufferSize;
    }

    public long getEventSyncPublisherConnectionStatusCheckInterval() {
        return this.eventSyncPublisherConnectionStatusCheckInterval;
    }

    public void setEventSyncPublisherConnectionStatusCheckInterval(long eventSyncPublisherConnectionStatusCheckInterval) {
        this.eventSyncPublisherConnectionStatusCheckInterval = eventSyncPublisherConnectionStatusCheckInterval;
    }

    public String getEventSyncPublisherCharSet() {
        return this.eventSyncPublisherCharSet;
    }

    public void setEventSyncPublisherCharSet(String eventSyncPublisherCharSet) {
        this.eventSyncPublisherCharSet = eventSyncPublisherCharSet;
    }

    public int getEventSyncPublisherTcpSendBufferSize() {
        return this.eventSyncPublisherTcpSendBufferSize;
    }

    public void setEventSyncPublisherTcpSendBufferSize(int eventSyncPublisherTcpSendBufferSize) {
        this.eventSyncPublisherTcpSendBufferSize = eventSyncPublisherTcpSendBufferSize;
    }

    public int getPresentationPublisherTcpSendBufferSize() {
        return this.presentationPublisherTcpSendBufferSize;
    }

    public String getPresentationPublisherCharSet() {
        return this.presentationPublisherCharSet;
    }

    public int getPresentationPublisherBufferSize() {
        return this.presentationPublisherBufferSize;
    }

    public long getPresentationPublisherConnectionStatusCheckInterval() {
        return this.presentationPublisherConnectionStatusCheckInterval;
    }

    public void setPresentationPublisherTcpSendBufferSize(int presentationPublisherTcpSendBufferSize) {
        this.presentationPublisherTcpSendBufferSize = presentationPublisherTcpSendBufferSize;
    }

    public void setPresentationPublisherCharSet(String presentationPublisherCharSet) {
        this.presentationPublisherCharSet = presentationPublisherCharSet;
    }

    public void setPresentationPublisherBufferSize(int presentationPublisherBufferSize) {
        this.presentationPublisherBufferSize = presentationPublisherBufferSize;
    }

    public void setPresentationPublisherConnectionStatusCheckInterval(long presentationPublisherConnectionStatusCheckInterval) {
        this.presentationPublisherConnectionStatusCheckInterval = presentationPublisherConnectionStatusCheckInterval;
    }

    public TCPEventPublisherConfig constructEventSyncPublisherConfig() {
        TCPEventPublisherConfig tcpEventPublisherConfig = new TCPEventPublisherConfig();
        tcpEventPublisherConfig.setBufferSize(this.getEventSyncPublisherBufferSize());
        tcpEventPublisherConfig.setConnectionStatusCheckInterval(this.getEventSyncPublisherConnectionStatusCheckInterval());
        tcpEventPublisherConfig.setCharset(this.getEventSyncPublisherCharSet());
        tcpEventPublisherConfig.setTcpSendBufferSize(this.getEventSyncPublisherTcpSendBufferSize());
        return tcpEventPublisherConfig;
    }

    public TCPEventPublisherConfig constructPresenterPublisherConfig() {
        TCPEventPublisherConfig tcpEventPublisherConfig = new TCPEventPublisherConfig();
        tcpEventPublisherConfig.setBufferSize(this.getPresentationPublisherBufferSize());
        tcpEventPublisherConfig.setConnectionStatusCheckInterval(this.getPresentationPublisherConnectionStatusCheckInterval());
        tcpEventPublisherConfig.setCharset(this.getPresentationPublisherCharSet());
        tcpEventPublisherConfig.setTcpSendBufferSize(this.getPresentationPublisherTcpSendBufferSize());
        return tcpEventPublisherConfig;
    }

    public int getEventSyncReceiverQueueSize() {
        return this.eventSyncReceiverQueueSize;
    }

    public void setEventSyncReceiverQueueSize(int eventSyncReceiverQueueSize) {
        this.eventSyncReceiverQueueSize = eventSyncReceiverQueueSize;
    }

    public int getEventSyncPublisherQueueSize() {
        return this.eventSyncPublisherQueueSize;
    }

    public void setEventSyncPublisherQueueSize(int eventSyncPublisherQueueSize) {
        this.eventSyncPublisherQueueSize = eventSyncPublisherQueueSize;
    }

    public int getEventSyncReceiverMaxQueueSizeInMb() {
        return this.eventSyncReceiverMaxQueueSizeInMb;
    }

    public void setEventSyncReceiverMaxQueueSizeInMb(int eventSyncReceiverMaxQueueSizeInMb) {
        this.eventSyncReceiverMaxQueueSizeInMb = eventSyncReceiverMaxQueueSizeInMb;
    }

    public int getEventSyncPublisherMaxQueueSizeInMb() {
        return this.eventSyncPublisherMaxQueueSizeInMb;
    }

    public void setEventSyncPublisherMaxQueueSizeInMb(int eventSyncPublisherMaxQueueSizeInMb) {
        this.eventSyncPublisherMaxQueueSizeInMb = eventSyncPublisherMaxQueueSizeInMb;
    }

    static {
        if (commandLinePortOffset > 0) {
            portOffset = commandLinePortOffset;
        } else if (carbonXmlportOffset > 0) {
            portOffset = carbonXmlportOffset;
        }
    }
}

