/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.manager.core.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.event.processor.manager.commons.transport.client.TCPEventPublisherConfig;
import org.wso2.carbon.event.processor.manager.commons.utils.HostAndPort;

public class DistributedConfiguration
implements Serializable {
    private boolean workerNode = false;
    private boolean managerNode = false;
    private HostAndPort localManagerConfig = new HostAndPort("localhost", 8904);
    private boolean presenterNode = false;
    private HostAndPort localPresenterConfig = new HostAndPort("localhost", -1);
    private List<HostAndPort> managers = new ArrayList<HostAndPort>();
    private int managementReconnectInterval = 10000;
    private int managementHeartbeatInterval = 5000;
    private int topologySubmitRetryInterval = 10000;
    private int transportMinPort = 15000;
    private int transportMaxPort = 15100;
    private int transportReconnectInterval = 15000;
    private int cepReceiverOutputQueueSize = 8192;
    private int stormPublisherOutputQueueSize = 8192;
    private int transportPublisherTcpSendBufferSize = 0x500000;
    private String transportPublisherCharSet = "UTF-8";
    private int transportPublisherConnectionStatusCheckInterval = 30000;
    private int stormSpoutBufferSize = 10000;
    private int presentationPublisherTcpSendBufferSize = 0x500000;
    private String presentationPublisherCharSet = "UTF-8";
    private int presentationOutputQueueSize = 1024;
    private int presentationPublisherConnectionStatusCheckInterval = 30000;
    private int statusLockTimeout = 60000;
    private int statusUpdateInterval = 60000;
    private int memberUpdateCheckInterval = 10000;
    private String jar;
    private String distributedUIUrl;

    public String getTransportPublisherCharSet() {
        return this.transportPublisherCharSet;
    }

    public void setTransportPublisherCharSet(String transportPublisherCharSet) {
        this.transportPublisherCharSet = transportPublisherCharSet;
    }

    public int getTransportPublisherTcpSendBufferSize() {
        return this.transportPublisherTcpSendBufferSize;
    }

    public void setTransportPublisherTcpSendBufferSize(int transportPublisherTcpSendBufferSize) {
        this.transportPublisherTcpSendBufferSize = transportPublisherTcpSendBufferSize;
    }

    public int getCepReceiverOutputQueueSize() {
        return this.cepReceiverOutputQueueSize;
    }

    public void setCepReceiverOutputQueueSize(int cepReceiverOutputQueueSize) {
        this.cepReceiverOutputQueueSize = cepReceiverOutputQueueSize;
    }

    public int getStormPublisherOutputQueueSize() {
        return this.stormPublisherOutputQueueSize;
    }

    public void setStormPublisherOutputQueueSize(int stormPublisherOutputQueueSize) {
        this.stormPublisherOutputQueueSize = stormPublisherOutputQueueSize;
    }

    public int getManagementHeartbeatInterval() {
        return this.managementHeartbeatInterval;
    }

    public void setManagementHeartbeatInterval(int managementHeartbeatInterval) {
        this.managementHeartbeatInterval = managementHeartbeatInterval;
    }

    public int getTopologySubmitRetryInterval() {
        return this.topologySubmitRetryInterval;
    }

    public void setTopologySubmitRetryInterval(int topologySubmitRetryInterval) {
        this.topologySubmitRetryInterval = topologySubmitRetryInterval;
    }

    public boolean isWorkerNode() {
        return this.workerNode;
    }

    public void setWorkerNode(boolean workerNode) {
        this.workerNode = workerNode;
    }

    public boolean isManagerNode() {
        return this.managerNode;
    }

    public void setManagerNode(boolean managerNode) {
        this.managerNode = managerNode;
    }

    public HostAndPort getLocalManagerConfig() {
        return this.localManagerConfig;
    }

    public void setLocalManagerConfig(String hostName, int port) {
        this.localManagerConfig = new HostAndPort(hostName, port);
    }

    public List<HostAndPort> getManagers() {
        return this.managers;
    }

    public void addManager(String hostName, int port) {
        this.managers.add(new HostAndPort(hostName, port));
    }

    public int getManagementReconnectInterval() {
        return this.managementReconnectInterval;
    }

    public void setManagementReconnectInterval(int managementReconnectInterval) {
        this.managementReconnectInterval = managementReconnectInterval;
    }

    public int getTransportMaxPort() {
        return this.transportMaxPort;
    }

    public void setTransportMaxPort(int transportMaxPort) {
        this.transportMaxPort = transportMaxPort;
    }

    public int getTransportMinPort() {
        return this.transportMinPort;
    }

    public void setTransportMinPort(int transportMinPort) {
        this.transportMinPort = transportMinPort;
    }

    public int getTransportReconnectInterval() {
        return this.transportReconnectInterval;
    }

    public void setTransportReconnectInterval(int transportReconnectInterval) {
        this.transportReconnectInterval = transportReconnectInterval;
    }

    public long getTransportPublisherConnectionStatusCheckInterval() {
        return this.transportPublisherConnectionStatusCheckInterval;
    }

    public void setTransportPublisherConnectionStatusCheckInterval(int transportPublisherConnectionStatusCheckInterval) {
        this.transportPublisherConnectionStatusCheckInterval = transportPublisherConnectionStatusCheckInterval;
    }

    public void setJar(String jar) {
        this.jar = jar;
    }

    public String getJar() {
        return this.jar;
    }

    public String getDistributedUIUrl() {
        return this.distributedUIUrl;
    }

    public void setDistributedUIUrl(String distributedUIUrl) {
        this.distributedUIUrl = distributedUIUrl;
    }

    public int getStatusLockTimeout() {
        return this.statusLockTimeout;
    }

    public void setStatusLockTimeout(int statusLockTimeout) {
        this.statusLockTimeout = statusLockTimeout;
    }

    public int getStatusUpdateInterval() {
        return this.statusUpdateInterval;
    }

    public void setStatusUpdateInterval(int statusUpdateInterval) {
        this.statusUpdateInterval = statusUpdateInterval;
    }

    public boolean isPresenterNode() {
        return this.presenterNode;
    }

    public void setPresenterNode(boolean presenterNode) {
        this.presenterNode = presenterNode;
    }

    public HostAndPort getLocalPresenterConfig() {
        return this.localPresenterConfig;
    }

    public void setLocalPresenterConfig(String host, int port) {
        this.localPresenterConfig = new HostAndPort(host, port);
    }

    public int getMemberUpdateCheckInterval() {
        return this.memberUpdateCheckInterval;
    }

    public void setMemberUpdateCheckInterval(int memberUpdateCheckInterval) {
        this.memberUpdateCheckInterval = memberUpdateCheckInterval;
    }

    public int getPresentationPublisherTcpSendBufferSize() {
        return this.presentationPublisherTcpSendBufferSize;
    }

    public void setPresentationPublisherTcpSendBufferSize(int presentationPublisherTcpSendBufferSize) {
        this.presentationPublisherTcpSendBufferSize = presentationPublisherTcpSendBufferSize;
    }

    public String getPresentationPublisherCharSet() {
        return this.presentationPublisherCharSet;
    }

    public void setPresentationPublisherCharSet(String presentationPublisherCharSet) {
        this.presentationPublisherCharSet = presentationPublisherCharSet;
    }

    public int getPresentationOutputQueueSize() {
        return this.presentationOutputQueueSize;
    }

    public void setPresentationOutputQueueSize(int presentationOutputQueueSize) {
        this.presentationOutputQueueSize = presentationOutputQueueSize;
    }

    public long getPresentationPublisherConnectionStatusCheckInterval() {
        return this.presentationPublisherConnectionStatusCheckInterval;
    }

    public void setPresentationPublisherConnectionStatusCheckInterval(int presentationPublisherConnectionStatusCheckInterval) {
        this.presentationPublisherConnectionStatusCheckInterval = presentationPublisherConnectionStatusCheckInterval;
    }

    public TCPEventPublisherConfig constructTransportPublisherConfig() {
        TCPEventPublisherConfig tcpEventPublisherConfig = new TCPEventPublisherConfig();
        tcpEventPublisherConfig.setConnectionStatusCheckInterval(this.getTransportPublisherConnectionStatusCheckInterval());
        tcpEventPublisherConfig.setCharset(this.getTransportPublisherCharSet());
        tcpEventPublisherConfig.setTcpSendBufferSize(this.getTransportPublisherTcpSendBufferSize());
        return tcpEventPublisherConfig;
    }

    public TCPEventPublisherConfig constructPresenterPublisherConfig() {
        TCPEventPublisherConfig tcpEventPublisherConfig = new TCPEventPublisherConfig();
        tcpEventPublisherConfig.setBufferSize(this.getPresentationOutputQueueSize());
        tcpEventPublisherConfig.setConnectionStatusCheckInterval(this.getPresentationPublisherConnectionStatusCheckInterval());
        tcpEventPublisherConfig.setCharset(this.getPresentationPublisherCharSet());
        tcpEventPublisherConfig.setTcpSendBufferSize(this.getPresentationPublisherTcpSendBufferSize());
        return tcpEventPublisherConfig;
    }

    public int getStormSpoutBufferSize() {
        return this.stormSpoutBufferSize;
    }

    public void setStormSpoutBufferSize(int stormSpoutBufferSize) {
        this.stormSpoutBufferSize = stormSpoutBufferSize;
    }
}

