/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.manager.core;

import java.util.ArrayList;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.event.processor.manager.core.Manager;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public class EventManagementUtil {
    public static String constructEventSyncId(int tenantId, String name, Manager.ManagerType type) {
        return tenantId + "/" + (Object)((Object)type) + "/" + name;
    }

    public static String getSyncIdFromDatabridgeStream(org.wso2.carbon.databridge.commons.StreamDefinition streamDefinition) {
        String streamId = streamDefinition.getStreamId();
        String[] streamIdComponents = streamId.split(":");
        if (streamIdComponents.length > 1) {
            return streamIdComponents[0];
        }
        return streamId;
    }

    public static StreamDefinition constructStreamDefinition(String syncId, org.wso2.carbon.databridge.commons.StreamDefinition inStreamDefinition) {
        StreamDefinition streamDefinition = new StreamDefinition();
        streamDefinition.setId(syncId);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (inStreamDefinition.getMetaData() != null) {
            for (Attribute attr : inStreamDefinition.getMetaData()) {
                attributes.add(new Attribute("meta_" + attr.getName(), attr.getType()));
            }
        }
        if (inStreamDefinition.getCorrelationData() != null) {
            for (Attribute attr : inStreamDefinition.getCorrelationData()) {
                attributes.add(new Attribute("correlation_" + attr.getName(), attr.getType()));
            }
        }
        if (inStreamDefinition.getPayloadData() != null) {
            attributes.addAll(inStreamDefinition.getPayloadData());
        }
        for (Attribute attr : attributes) {
            streamDefinition.attribute(attr.getName(), Attribute.Type.valueOf((String)attr.getType().toString()));
        }
        return streamDefinition;
    }

    public static org.wso2.carbon.databridge.commons.StreamDefinition constructDatabridgeStreamDefinition(String syncId, org.wso2.carbon.databridge.commons.StreamDefinition inStreamDefinition) {
        org.wso2.carbon.databridge.commons.StreamDefinition streamDefinition = new org.wso2.carbon.databridge.commons.StreamDefinition(syncId);
        streamDefinition.setMetaData(inStreamDefinition.getMetaData());
        streamDefinition.setCorrelationData(inStreamDefinition.getCorrelationData());
        streamDefinition.setPayloadData(inStreamDefinition.getPayloadData());
        return streamDefinition;
    }

    public static Event getWso2Event(String originalEventStreamId, org.wso2.carbon.databridge.commons.StreamDefinition streamDefinition, long timestamp, Object[] data) {
        int metaAttrCount = streamDefinition.getMetaData() != null ? streamDefinition.getMetaData().size() : 0;
        int correlationAttrCount = streamDefinition.getCorrelationData() != null ? streamDefinition.getCorrelationData().size() : 0;
        int payloadAttrCount = streamDefinition.getPayloadData() != null ? streamDefinition.getPayloadData().size() : 0;
        Object[] metaAttrArray = new Object[metaAttrCount];
        Object[] correlationAttrArray = new Object[correlationAttrCount];
        Object[] payloadAttrArray = new Object[payloadAttrCount];
        for (int i = 0; i < data.length; ++i) {
            if (i < metaAttrCount) {
                metaAttrArray[i] = data[i];
                continue;
            }
            if (i < metaAttrCount + correlationAttrCount) {
                correlationAttrArray[i - metaAttrCount] = data[i];
                continue;
            }
            payloadAttrArray[i - (metaAttrCount + correlationAttrCount)] = data[i];
        }
        return new Event(originalEventStreamId, timestamp, metaAttrArray, correlationAttrArray, payloadAttrArray);
    }
}

