/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.modules.sso.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.IdResolver;
import org.jaggeryjs.modules.sso.common.util.X509CredentialImpl;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.impl.SecureRandomIdentifierGenerator;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml2.core.impl.StatusResponseTypeImpl;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.signature.impl.SignatureImpl;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.xml.sax.SAXException;

public class Util {
    private static final int ENTITY_EXPANSION_LIMIT = 0;
    private static boolean bootStrapped = false;
    private static final String ISSUER = "issuer";
    private static final String IDENTITY_PROVIDER_ERROR = "urn:oasis:names:tc:SAML:2.0:status:Responder";
    private static final String NO_PASSIVE = "urn:oasis:names:tc:SAML:2.0:status:NoPassive";
    private static final String TIME_STAMP_SKEW = "timeStampSkew";
    private static final int DEAFAULT_TIME_STAMP_SKEW_IN_SECONDS = 300;
    private static Random random = new Random();
    private static final char[] charMapping = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p'};
    private static Log log = LogFactory.getLog(Util.class);

    public static void doBootstrap() {
        if (!bootStrapped) {
            try {
                DefaultBootstrap.bootstrap();
                bootStrapped = true;
            }
            catch (ConfigurationException e) {
                System.err.println("Error in bootstrapping the OpenSAML2 library");
                e.printStackTrace();
            }
        }
    }

    public static XMLObject buildXMLObject(QName objectQName) throws Exception {
        XMLObjectBuilder builder = org.opensaml.xml.Configuration.getBuilderFactory().getBuilder(objectQName);
        if (builder == null) {
            throw new Exception("Unable to retrieve builder for object QName " + objectQName);
        }
        return builder.buildObject(objectQName.getNamespaceURI(), objectQName.getLocalPart(), objectQName.getPrefix());
    }

    public static String createID() {
        try {
            SecureRandomIdentifierGenerator generator = new SecureRandomIdentifierGenerator();
            return generator.generateIdentifier();
        }
        catch (NoSuchAlgorithmException e) {
            log.warn((Object)"Error while building Secure Random ID");
            return null;
        }
    }

    public static XMLObject unmarshall(String authReqStr) throws Exception {
        try {
            Util.doBootstrap();
            DocumentBuilderFactory documentBuilderFactory = Util.getSecuredDocumentBuilder();
            documentBuilderFactory.setIgnoringComments(true);
            Document document = Util.getDocument(documentBuilderFactory, authReqStr);
            if (Util.isSignedWithComments(document)) {
                documentBuilderFactory.setIgnoringComments(false);
                document = Util.getDocument(documentBuilderFactory, authReqStr);
            }
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            XMLObject response = unmarshaller.unmarshall(element);
            NodeList list = response.getDOM().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "Response");
            if (list.getLength() > 0) {
                log.error((Object)"Invalid schema for the SAML2 reponse. Multiple response objects found");
                throw new Exception("Error occured while processing saml2 response. Multiple response objects found");
            }
            NodeList assertionList = response.getDOM().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
            if (response instanceof Assertion) {
                if (assertionList.getLength() > 0) {
                    log.error((Object)"Invalid schema for the SAML2 assertion. Multiple assertions detected");
                    throw new Exception("Error occurred while processing saml2 response. Multiple assertions detected");
                }
            } else if (assertionList.getLength() > 1) {
                log.error((Object)"Invalid schema for the SAML2 response. Multiple assertions detected");
                throw new Exception("Error occurred while processing saml2 response. Multiple assertions detected");
            }
            return response;
        }
        catch (Exception e) {
            throw new Exception("Error in constructing AuthRequest from the encoded String ", e);
        }
    }

    private static boolean isSignedWithComments(Document document) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            String assertionId = (String)xPath.compile("//*[local-name()='Assertion']/@ID").evaluate(document, XPathConstants.STRING);
            if (StringUtils.isBlank((String)assertionId)) {
                return false;
            }
            NodeList nodeList = (NodeList)xPath.compile("//*[local-name()='Assertion']/*[local-name()='Signature']/*[local-name()='SignedInfo']/*[local-name()='Reference'][@URI='#" + assertionId + "']/*[local-name()='Transforms']/*[local-name()='Transform'][@Algorithm='http://www.w3.org/2001/10/xml-exc-c14n#WithComments']").evaluate(document, XPathConstants.NODESET);
            return nodeList != null && nodeList.getLength() > 0;
        }
        catch (XPathExpressionException e) {
            String message = "Failed to find the canonicalization algorithm of the assertion. Defaulting to: http://www.w3.org/2001/10/xml-exc-c14n#";
            log.warn((Object)message);
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            }
            return false;
        }
    }

    private static Document getDocument(DocumentBuilderFactory documentBuilderFactory, String samlString) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(samlString.getBytes());
        return docBuilder.parse(inputStream);
    }

    public static String marshall(XMLObject xmlObject) throws Exception {
        try {
            Util.doBootstrap();
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            MarshallerFactory marshallerFactory = org.opensaml.xml.Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
            Element element = marshaller.marshall(xmlObject);
            ByteArrayOutputStream byteArrayOutputStrm = new ByteArrayOutputStream();
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            LSOutput output = impl.createLSOutput();
            output.setByteStream(byteArrayOutputStrm);
            writer.write(element, output);
            return byteArrayOutputStrm.toString();
        }
        catch (Exception e) {
            throw new Exception("Error Serializing the SAML Response", e);
        }
    }

    public static String encode(String xmlString) {
        String encodedRequestMessage = Base64.encodeBytes((byte[])xmlString.getBytes(), (int)8);
        return encodedRequestMessage.trim();
    }

    public static String decode(String encodedStr) throws Exception {
        return new String(Base64.decode((String)encodedStr));
    }

    public static boolean validateSignature(StatusResponseTypeImpl resp, String keyStoreName, String keyStorePassword, String alias, int tenantId, String tenantDomain) {
        if (resp.getSignature() == null) {
            log.error((Object)"SAML Response signing is enabled, but signature element not found in SAML Response element.");
            return false;
        }
        return Util.validateSignature(resp.getSignature(), keyStoreName, keyStorePassword, alias, tenantId, tenantDomain);
    }

    public static boolean validateAssertionSignature(Response resp, String keyStoreName, String keyStorePassword, String alias, int tenantId, String tenantDomain) {
        Assertion assertion = Util.retrieveAssertion(resp);
        if (assertion == null) {
            log.error((Object)"SAML Assertion not found in the Response");
            return false;
        }
        if (assertion.getSignature() == null) {
            log.error((Object)"SAMLAssertion signing is enabled, but signature element not found in SAML Assertion element.");
            return false;
        }
        return Util.validateSignature(assertion.getSignature(), keyStoreName, keyStorePassword, alias, tenantId, tenantDomain);
    }

    private static boolean validateSignature(Signature signature, String keyStoreName, String keyStorePassword, String alias, int tenantId, String tenantDomain) {
        boolean isSigValid = false;
        try {
            KeyStore keyStore = null;
            X509Certificate cert = null;
            if (tenantId != -1234) {
                KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)tenantId);
                keyStore = keyStoreManager.getKeyStore(Util.generateKSNameFromDomainName(tenantDomain));
                cert = (X509Certificate)keyStore.getCertificate(tenantDomain);
            } else {
                keyStore = KeyStore.getInstance("JKS");
                keyStore.load(new FileInputStream(new File(keyStoreName)), keyStorePassword.toCharArray());
                cert = (X509Certificate)keyStore.getCertificate(alias);
            }
            try {
                SAMLSignatureProfileValidator signatureProfileValidator = new SAMLSignatureProfileValidator();
                signatureProfileValidator.validate(signature);
                SignatureImpl sigImpl = (SignatureImpl)signature;
                XMLSignature apacheSig = sigImpl.getXMLSignature();
                SignableSAMLObject signableObject = (SignableSAMLObject)sigImpl.getParent();
                Reference ref = null;
                try {
                    ref = apacheSig.getSignedInfo().item(0);
                }
                catch (XMLSecurityException e) {
                    log.error((Object)"Apache XML Security exception obtaining Reference", (Throwable)e);
                    throw new ValidationException("Could not obtain Reference from Signature/SignedInfo", (Exception)((Object)e));
                }
                String uri = ref.getURI();
                Util.validateReferenceURI(uri, signableObject);
                Util.validateObjectChildren(apacheSig);
            }
            catch (ValidationException e) {
                String logMsg = "Signature do not confirm to SAML signature profile. Possible XML Signature Wrapping Attack!";
                log.warn((Object)logMsg);
                if (log.isDebugEnabled()) {
                    log.debug((Object)logMsg, (Throwable)e);
                }
                return isSigValid;
            }
            X509CredentialImpl credentialImpl = new X509CredentialImpl(cert);
            SignatureValidator signatureValidator = new SignatureValidator((Credential)credentialImpl);
            signatureValidator.validate(signature);
            isSigValid = true;
            return isSigValid;
        }
        catch (Exception e) {
            log.error((Object)"Error while validating signature", (Throwable)e);
            return isSigValid;
        }
    }

    public static boolean validateAssertionValidityPeriod(Response resp, Properties prop) {
        Assertion assertion = Util.retrieveAssertion(resp);
        if (assertion == null) {
            log.error((Object)"SAML Assertion not found in the Response");
            return false;
        }
        DateTime validFrom = assertion.getConditions().getNotBefore();
        DateTime validTill = assertion.getConditions().getNotOnOrAfter();
        int timeStampSkewInSeconds = Util.getTimeStampSkewInSeconds(prop);
        if (validFrom != null && validFrom.minusSeconds(timeStampSkewInSeconds).isAfterNow()) {
            log.error((Object)"Failed to meet SAML Assertion Condition 'Not Before'");
            return false;
        }
        if (validTill != null && validTill.plusSeconds(timeStampSkewInSeconds).isBeforeNow()) {
            log.error((Object)"Failed to meet SAML Assertion Condition 'Not On Or After'");
            return false;
        }
        if (validFrom != null && validTill != null && validFrom.isAfter((ReadableInstant)validTill)) {
            log.error((Object)"SAML Assertion Condition 'Not Before' must be less than the value of 'Not On Or After'");
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean validateAudienceRestriction(Response resp, Properties properties) {
        Assertion assertion = Util.retrieveAssertion(resp);
        if (assertion == null) {
            log.error((Object)"SAML Assertion not found in the Response");
            return false;
        }
        Conditions conditions = assertion.getConditions();
        if (conditions == null) {
            log.error((Object)"SAML Response doesn't contain Conditions");
            return false;
        }
        List audienceRestrictions = conditions.getAudienceRestrictions();
        if (audienceRestrictions != null && !audienceRestrictions.isEmpty()) {
            boolean audienceFound;
            Iterator iterator = audienceRestrictions.iterator();
            block0: do {
                if (!iterator.hasNext()) {
                    return true;
                }
                AudienceRestriction audienceRestriction = (AudienceRestriction)iterator.next();
                if (!CollectionUtils.isNotEmpty((Collection)audienceRestriction.getAudiences())) {
                    log.error((Object)"SAML Response's AudienceRestriction doesn't contain Audiences");
                    return false;
                }
                audienceFound = false;
                for (Audience audience : audienceRestriction.getAudiences()) {
                    if (!properties.get(ISSUER).equals(audience.getAudienceURI())) continue;
                    audienceFound = true;
                    continue block0;
                }
            } while (audienceFound);
            log.error((Object)"SAML Assertion Audience Restriction validation failed");
            return false;
        }
        log.error((Object)"SAML Response doesn't contain AudienceRestrictions");
        return false;
    }

    private static int getTimeStampSkewInSeconds(Properties prop) {
        String timeStampSkew;
        int timeStampSkewInSeconds = 300;
        if (prop != null && prop.containsKey(TIME_STAMP_SKEW) && (timeStampSkew = prop.get(TIME_STAMP_SKEW).toString()) != null && timeStampSkew.length() > 0) {
            timeStampSkewInSeconds = Integer.parseInt(timeStampSkew);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("TimestampSkew is set to " + timeStampSkewInSeconds + " s."));
        }
        return timeStampSkewInSeconds;
    }

    private static Assertion retrieveAssertion(Response resp) {
        Assertion assertion = null;
        List assertions = resp.getAssertions();
        if (CollectionUtils.isNotEmpty((Collection)assertions)) {
            if (assertions.size() != 1) {
                log.error((Object)"SAML Response contains multiple assertions");
                return assertion;
            }
            assertion = (Assertion)assertions.get(0);
        }
        return assertion;
    }

    public static String getDomainName(XMLObject samlObject) {
        NodeList list = samlObject.getDOM().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "NameID");
        String domainName = null;
        if (list.getLength() > 0) {
            String userName = list.item(0).getTextContent();
            domainName = MultitenantUtils.getTenantDomain((String)userName);
        }
        return domainName;
    }

    private static String generateKSNameFromDomainName(String tenantDomain) {
        String ksName = tenantDomain.trim().replace(".", "-");
        return ksName + ".jks";
    }

    public static DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }

    public static NameIDPolicy buildNameIDPolicy(String nameIdPolicy) {
        NameIDPolicy nameIDPolicyObj = new NameIDPolicyBuilder().buildObject();
        if (!StringUtils.isEmpty((String)nameIdPolicy)) {
            nameIDPolicyObj.setFormat(nameIdPolicy);
        } else {
            nameIDPolicyObj.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        }
        nameIDPolicyObj.setAllowCreate(Boolean.valueOf(true));
        return nameIDPolicyObj;
    }

    public static NameID buildNameID(String nameIdFormat, String subject) {
        NameID nameIdObj = new NameIDBuilder().buildObject();
        if (!StringUtils.isEmpty((String)nameIdFormat)) {
            nameIdObj.setFormat(nameIdFormat);
        } else {
            nameIdObj.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        }
        nameIdObj.setValue(subject);
        return nameIdObj;
    }

    public static String processAcsUrl(String acsUrl) {
        Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher matcher = pattern.matcher(acsUrl);
        while (matcher.find()) {
            String match = matcher.group(1);
            String property = System.getProperty(match);
            if (property != null) {
                acsUrl = acsUrl.replace("${" + match + "}", property);
                continue;
            }
            log.warn((Object)("System Property " + match + " is not set"));
        }
        return acsUrl;
    }

    private static void validateReferenceURI(String uri, SignableSAMLObject signableObject) throws ValidationException {
        if (DatatypeHelper.isEmpty((String)uri)) {
            return;
        }
        String uriID = uri.substring(1);
        Element expected = signableObject.getDOM();
        if (expected == null) {
            log.error((Object)"SignableSAMLObject does not have a cached DOM Element.");
            throw new ValidationException("SignableSAMLObject does not have a cached DOM Element.");
        }
        Document doc = expected.getOwnerDocument();
        Element resolved = IdResolver.getElementById((Document)doc, (String)uriID);
        if (resolved == null) {
            log.error((Object)("Apache xmlsec IdResolver could not resolve the Element for id reference: " + uriID));
            throw new ValidationException("Apache xmlsec IdResolver could not resolve the Element for id reference: " + uriID);
        }
        if (!expected.isSameNode(resolved)) {
            log.error((Object)("Signature Reference URI " + uri + " did not resolve to the expected parent Element"));
            throw new ValidationException("Signature Reference URI did not resolve to the expected parent Element");
        }
    }

    private static void validateObjectChildren(XMLSignature apacheSig) throws ValidationException {
        if (apacheSig.getObjectLength() > 0) {
            log.error((Object)("Signature contained " + apacheSig.getObjectLength() + " ds:Object child element(s)"));
            throw new ValidationException("Signature contained illegal ds:Object children");
        }
    }
}

