/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.modules.sso.common.util;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.modules.sso.common.util.SSOAgentX509Credential;
import org.wso2.carbon.core.util.KeyStoreManager;

public class SSOAgentCarbonX509Credential
implements SSOAgentX509Credential {
    private static Log log = LogFactory.getLog(SSOAgentCarbonX509Credential.class);
    private PublicKey publicKey = null;
    private PrivateKey privateKey = null;
    private X509Certificate entityCertificate = null;

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public X509Certificate getEntityCertificate() {
        return this.entityCertificate;
    }

    public SSOAgentCarbonX509Credential(int tenantId, String tenantDomain) throws Exception {
        this.readCarbonX509Credentials(tenantId, tenantDomain);
    }

    protected void readCarbonX509Credentials(int tenantId, String tenantDomain) throws Exception {
        KeyStoreManager tenantKSM = KeyStoreManager.getInstance((int)tenantId);
        if (!tenantDomain.equals("carbon.super")) {
            String ksName = tenantDomain.trim().replace(".", "-");
            String jksName = ksName + ".jks";
            KeyStore keyStore = null;
            try {
                keyStore = tenantKSM.getKeyStore(jksName);
            }
            catch (Exception e) {
                this.handleException("Error occurred while retrieving key store of tenant " + tenantDomain, e);
                return;
            }
            try {
                this.entityCertificate = (X509Certificate)keyStore.getCertificate(tenantDomain);
            }
            catch (KeyStoreException e) {
                this.handleException("Error occurred while retrieving public certificate with alias " + tenantDomain + " of tenant " + tenantDomain, e);
            }
            this.privateKey = (PrivateKey)tenantKSM.getPrivateKey(jksName, tenantDomain);
        } else {
            try {
                this.entityCertificate = tenantKSM.getDefaultPrimaryCertificate();
            }
            catch (Exception e) {
                this.handleException("Error retrieving default primary certificate of carbon.super", e);
            }
            try {
                this.privateKey = tenantKSM.getDefaultPrivateKey();
            }
            catch (Exception e) {
                this.handleException("Error retrieving default private key of carbon.super", e);
            }
        }
        this.publicKey = this.entityCertificate.getPublicKey();
    }

    private void handleException(String errorMessage, Throwable e) throws Exception {
        log.error((Object)errorMessage);
        throw new Exception(errorMessage, e);
    }
}

