/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.modules.sso.common.managers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.web.SessionHostObject;
import org.jaggeryjs.modules.sso.common.clustering.ClusteringUtil;
import org.jaggeryjs.modules.sso.common.clustering.ServiceProviderMap;
import org.jaggeryjs.modules.sso.common.clustering.ServiceProviderSession;
import org.jaggeryjs.modules.sso.common.clustering.SessionInvalidateClusterMessage;

public class SSOSessionManager {
    private static final Log log = LogFactory.getLog(SSOSessionManager.class);
    private static Map<String, ServiceProviderMap> sessionHostObjectMap;
    private static Map<String, String> sessionToIDPIndexMap;
    private static SSOSessionManager instance;

    private SSOSessionManager() {
        sessionHostObjectMap = new ConcurrentHashMap<String, ServiceProviderMap>();
        sessionToIDPIndexMap = new ConcurrentHashMap<String, String>();
    }

    public static SSOSessionManager getInstance() {
        return instance;
    }

    public void login(String idpSessionIndex, String serviceProvider, SessionHostObject session) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Trying to register Service Provider:%s ", serviceProvider));
        }
        this.registerServiceProviderSessionWithIDPSessionIndex(idpSessionIndex, serviceProvider, session);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Finished registering Service Provider:%s ", serviceProvider));
        }
    }

    public void logout(String idpSessionIndex, String serviceProvider) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Trying to remove Service Provider:%s  using IDP Session Index", serviceProvider));
        }
        this.removeServiceProviderSession(idpSessionIndex, serviceProvider);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Finished removing Service Provider:%s using IDP Session Index ", serviceProvider));
        }
    }

    public void logout(SessionHostObject session, String serviceProvider) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Trying to remove Service Provider:%s using Session ", serviceProvider));
        }
        String sessionId = ServiceProviderSession.getSessionId(session);
        String idpSessionIndex = this.getIDPSessionIndex(sessionId);
        this.removeServiceProviderSession(idpSessionIndex, serviceProvider);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Finished removing ServiceProvider:%s  using Session", serviceProvider));
        }
    }

    public void cleanUp(SessionHostObject session, String serviceProvider) {
        String sessionId;
        String idpSessionIndex;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Cleaning up session details of Service Provider: %s ", serviceProvider));
        }
        if ((idpSessionIndex = this.getIDPSessionIndex(sessionId = ServiceProviderSession.getSessionId(session))) == null) {
            if (log.isDebugEnabled()) {
                log.warn((Object)String.format("Unable to locate an IDP Session Index for the provided session:%s .Aborting clean up operations.", sessionId));
            }
            return;
        }
        ServiceProviderMap serviceProviderMap = this.getServiceProviderSessionMap(idpSessionIndex);
        this.cleanUpSessionProviderMap(serviceProviderMap, serviceProvider);
        this.cleanUpLocalSessionDetails(sessionId);
        this.cleanUpIDPSessionDetails(idpSessionIndex, serviceProviderMap);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Finished cleaning up session details of Service Provider :%s ", serviceProvider));
        }
    }

    public void logoutClusteredNodes(String idpSessionIndex, String serviceProvider) {
        this.removeServiceProviderSessionInCluster(idpSessionIndex, serviceProvider);
    }

    private void registerServiceProviderSessionWithIDPSessionIndex(String idpSessionIndex, String serviceProvider, SessionHostObject session) {
        ServiceProviderMap serviceProviderSessionMap = this.getServiceProviderSessionMap(idpSessionIndex);
        if (serviceProviderSessionMap == null) {
            serviceProviderSessionMap = this.createServiceProviderSessionMap(idpSessionIndex);
        }
        ServiceProviderSession serviceProviderSession = new ServiceProviderSession(serviceProvider, session);
        this.addToServiceProviderSessionMap(serviceProviderSession, serviceProviderSessionMap);
        String localSessionId = serviceProviderSession.getSessionId();
        sessionToIDPIndexMap.put(localSessionId, idpSessionIndex);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Registered Session Id: %s to IDP Session Index : %s", localSessionId, idpSessionIndex));
        }
    }

    private void removeServiceProviderSessionInCluster(String idpSessionIndex, String serviceProvider) {
        if (!sessionHostObjectMap.containsKey(idpSessionIndex)) {
            return;
        }
        this.cleanUpSessionsDetails(idpSessionIndex, serviceProvider);
    }

    private void removeServiceProviderSession(String idpSessionIndex, String serviceProvider) {
        if (!sessionHostObjectMap.containsKey(idpSessionIndex)) {
            this.notifyClusterToInvalidateSession(idpSessionIndex, serviceProvider);
            return;
        }
        this.cleanUpSessionsDetails(idpSessionIndex, serviceProvider);
    }

    private void cleanUpSessionsDetails(String idpSessionIndex, String serviceProvider) {
        ServiceProviderMap serviceProviderMap = this.getServiceProviderSessionMap(idpSessionIndex);
        this.invalidateServiceProviderSession(serviceProviderMap, serviceProvider);
        this.cleanUpIDPSessionDetails(idpSessionIndex, serviceProviderMap);
    }

    private synchronized void cleanUpIDPSessionDetails(String idpSessionIndex, ServiceProviderMap serviceProviderMap) {
        if (!sessionHostObjectMap.containsKey(idpSessionIndex)) {
            return;
        }
        if (serviceProviderMap.isEmpty()) {
            sessionHostObjectMap.remove(idpSessionIndex);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Removed IDP Session Index %s since there  were no Service Providers", idpSessionIndex));
            }
        }
    }

    private void cleanUpLocalSessionDetails(String sessionId) {
        if (!sessionToIDPIndexMap.containsKey(sessionId)) {
            return;
        }
        sessionToIDPIndexMap.remove(sessionId);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Removed Service Provider's Session Id:%s ", sessionId));
        }
    }

    private void cleanUpSessionProviderMap(ServiceProviderMap serviceProviderMap, String serviceProvider) {
        if (!serviceProviderMap.containsKey(serviceProvider)) {
            return;
        }
        serviceProviderMap.remove(serviceProvider);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Removed Service Provider:%s ", serviceProvider));
        }
    }

    private void invalidateServiceProviderSession(ServiceProviderMap serviceProviderMap, String serviceProvider) {
        if (!serviceProviderMap.containsKey(serviceProvider)) {
            return;
        }
        ServiceProviderSession serviceProviderSession = serviceProviderMap.getServiceProviderSession(serviceProvider);
        String sessionId = serviceProviderSession.getSessionId();
        serviceProviderSession.invalidate();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Invalidated the Service Provider session :%s ", serviceProviderSession));
        }
        this.cleanUpSessionProviderMap(serviceProviderMap, serviceProvider);
        this.cleanUpLocalSessionDetails(sessionId);
    }

    private ServiceProviderMap getServiceProviderSessionMap(String idpSessionIndex) {
        return sessionHostObjectMap.get(idpSessionIndex);
    }

    private ServiceProviderMap createServiceProviderSessionMap(String idpSessionIndex) {
        ServiceProviderMap serviceProviderMap = new ServiceProviderMap();
        sessionHostObjectMap.put(idpSessionIndex, serviceProviderMap);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Registered new Service Provider map for IDP Session Index:%s ", idpSessionIndex));
        }
        return serviceProviderMap;
    }

    private void addToServiceProviderSessionMap(ServiceProviderSession serviceProviderSession, ServiceProviderMap map) {
        map.addServiceProviderSession(serviceProviderSession);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Registered Service Provider against Session: %s", serviceProviderSession));
        }
    }

    private String getIDPSessionIndex(String sessionId) {
        return sessionToIDPIndexMap.get(sessionId);
    }

    private void notifyClusterToInvalidateSession(String idpSessionIndex, String serviceProvider) {
        SessionInvalidateClusterMessage message = new SessionInvalidateClusterMessage(idpSessionIndex, serviceProvider);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Sending cluster message: %s ", new Object[]{message}));
        }
        ClusteringUtil.sendClusterMessage(message);
    }

    static {
        instance = new SSOSessionManager();
    }
}

