/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.modules.sso.common.clustering;

import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.modules.sso.common.managers.SSOSessionManager;

public class SessionInvalidateClusterMessage
extends ClusteringMessage {
    private static final Log log = LogFactory.getLog(SessionInvalidateClusterMessage.class);
    private String idpSessionIndex;
    private String serviceProvider;

    public SessionInvalidateClusterMessage(String idpSessionIndex, String serviceProvider) {
        this.idpSessionIndex = idpSessionIndex;
        this.serviceProvider = serviceProvider;
    }

    public ClusteringCommand getResponse() {
        return null;
    }

    public void execute(ConfigurationContext configurationContext) throws ClusteringFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Invalidating session with idp session index=%s", this.idpSessionIndex));
        }
        SSOSessionManager.getInstance().logoutClusteredNodes(this.idpSessionIndex, this.serviceProvider);
    }

    public String toString() {
        return String.format("SSOSessionInvalidationClusterMessage{serviceProvider=%s,sessionIndex=%s}", this.serviceProvider, this.idpSessionIndex);
    }
}

