/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.modules.sso.common.clustering;

import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FailedClusterMessageTransmitter
implements Runnable {
    private static final Log log = LogFactory.getLog(FailedClusterMessageTransmitter.class);
    private ClusteringAgent agent;
    private ClusteringMessage message;
    private int retryCount;

    public FailedClusterMessageTransmitter(ClusteringAgent agent, ClusteringMessage message) {
        this.agent = agent;
        this.retryCount = 0;
        this.message = message;
    }

    @Override
    public void run() {
        boolean isSuccess = false;
        try {
            while (!isSuccess && this.retryCount < 4) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Attempting to retransmit message : %s ", this.message));
                }
                isSuccess = this.send();
                ++this.retryCount;
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!isSuccess) {
            log.error((Object)("Permanently failed to send clustering message " + this.message + " since max retry count has been reached.There will not be any further attempts to send this message."));
        }
    }

    private boolean send() {
        boolean isSuccess = false;
        try {
            this.agent.sendMessage(this.message, true);
            isSuccess = true;
        }
        catch (ClusteringFault e) {
            log.error((Object)("Failed to send message " + this.message + ". Retry count at " + this.retryCount), (Throwable)e);
        }
        return isSuccess;
    }
}

