/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.modules.sso.common.clustering;

import java.util.Hashtable;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.modules.sso.common.clustering.FailedClusterMessageTransmitter;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.utils.ConfigurationContextService;

public class ClusteringUtil {
    private static final Log log = LogFactory.getLog(ClusteringUtil.class);

    public static void sendClusterMessage(ClusteringMessage message) {
        ClusteringAgent agent = ClusteringUtil.createClusteringAgent();
        if (agent == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Failed to send cluster message :%s ", message));
            }
            return;
        }
        try {
            agent.sendMessage(message, true);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Successfully transmitted cluster message :%s", message));
            }
        }
        catch (ClusteringFault e) {
            if (log.isDebugEnabled()) {
                log.error((Object)"Unable to send the clustering message.The system will now attempt to retry sending the message", (Throwable)e);
            }
            Thread th = new Thread(new FailedClusterMessageTransmitter(agent, message));
            th.start();
        }
    }

    public static ClusteringAgent createClusteringAgent() {
        ClusteringAgent agent = null;
        try {
            PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            ConfigurationContextService configContextSvc = (ConfigurationContextService)privilegedCarbonContext.getOSGiService(Class.forName("org.wso2.carbon.utils.ConfigurationContextService"), new Hashtable());
            agent = configContextSvc.getServerConfigContext().getAxisConfiguration().getClusteringAgent();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Unable to create clustering agent", (Throwable)e);
        }
        return agent;
    }
}

