/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.modules.sso.common.builders;

import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.marshall.MarshallingException;
import org.jaggeryjs.modules.sso.common.util.SSOAgentCarbonX509Credential;
import org.jaggeryjs.modules.sso.common.util.Util;
import org.jaggeryjs.modules.sso.common.util.X509CredentialImpl;
import org.joda.time.DateTime;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.SessionIndex;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml2.core.impl.SessionIndexBuilder;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.util.Base64;

public class LogoutRequestBuilder {
    private static Log log = LogFactory.getLog(LogoutRequestBuilder.class);

    public LogoutRequest buildLogoutRequest(String subject, String sessionIndexId, String reason, String issuerId) {
        Util.doBootstrap();
        LogoutRequest logoutReq = new org.opensaml.saml2.core.impl.LogoutRequestBuilder().buildObject();
        logoutReq.setID(Util.createID());
        DateTime issueInstant = new DateTime();
        logoutReq.setIssueInstant(issueInstant);
        logoutReq.setNotOnOrAfter(new DateTime(issueInstant.getMillis() + 300000L));
        IssuerBuilder issuerBuilder = new IssuerBuilder();
        Issuer issuer = issuerBuilder.buildObject();
        issuer.setValue(issuerId);
        logoutReq.setIssuer(issuer);
        NameID nameId = new NameIDBuilder().buildObject();
        nameId.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        nameId.setValue(subject);
        logoutReq.setNameID(nameId);
        SessionIndex sessionIndex = new SessionIndexBuilder().buildObject();
        sessionIndex.setSessionIndex(sessionIndexId);
        logoutReq.getSessionIndexes().add(sessionIndex);
        logoutReq.setReason(reason);
        return logoutReq;
    }

    public LogoutRequest buildLogoutRequest(String subject, String sessionIndexId, String reason, String issuerId, int tenantId, String tenantDomain, String destination, String nameIdFormat) throws Exception {
        Util.doBootstrap();
        LogoutRequest logoutReq = new org.opensaml.saml2.core.impl.LogoutRequestBuilder().buildObject();
        logoutReq.setID(Util.createID());
        DateTime issueInstant = new DateTime();
        logoutReq.setIssueInstant(issueInstant);
        logoutReq.setNotOnOrAfter(new DateTime(issueInstant.getMillis() + 300000L));
        IssuerBuilder issuerBuilder = new IssuerBuilder();
        Issuer issuer = issuerBuilder.buildObject();
        issuer.setValue(issuerId);
        logoutReq.setIssuer(issuer);
        logoutReq.setNameID(Util.buildNameID(nameIdFormat, subject));
        SessionIndex sessionIndex = new SessionIndexBuilder().buildObject();
        sessionIndex.setSessionIndex(sessionIndexId);
        logoutReq.getSessionIndexes().add(sessionIndex);
        logoutReq.setReason(reason);
        logoutReq.setDestination(destination);
        SSOAgentCarbonX509Credential ssoAgentCarbonX509Credential = new SSOAgentCarbonX509Credential(tenantId, tenantDomain);
        LogoutRequestBuilder.setSignature(logoutReq, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", new X509CredentialImpl(ssoAgentCarbonX509Credential));
        return logoutReq;
    }

    public static LogoutRequest setSignature(LogoutRequest logoutRequest, String signatureAlgorithm, X509Credential cred) throws Exception {
        try {
            Signature signature = (Signature)Util.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.setSigningCredential((Credential)cred);
            signature.setSignatureAlgorithm(signatureAlgorithm);
            signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            KeyInfo keyInfo = (KeyInfo)Util.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
            X509Data data = (X509Data)Util.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
            X509Certificate cert = (X509Certificate)Util.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
            String value = Base64.encodeBytes((byte[])cred.getEntityCertificate().getEncoded());
            cert.setValue(value);
            data.getX509Certificates().add(cert);
            keyInfo.getX509Datas().add(data);
            signature.setKeyInfo(keyInfo);
            logoutRequest.setSignature(signature);
            ArrayList<Signature> signatureList = new ArrayList<Signature>();
            signatureList.add(signature);
            MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)logoutRequest);
            marshaller.marshall((XMLObject)logoutRequest);
            Signer.signObjects(signatureList);
            return logoutRequest;
        }
        catch (CertificateEncodingException e) {
            LogoutRequestBuilder.handleException("Error getting certificate", e);
        }
        catch (MarshallingException e) {
            LogoutRequestBuilder.handleException("Error while marshalling logout request", e);
        }
        catch (SignatureException e) {
            LogoutRequestBuilder.handleException("Error while signing the SAML logout request", e);
        }
        catch (Exception e) {
            LogoutRequestBuilder.handleException("Error while signing the SAML logout request", e);
        }
        return null;
    }

    private static void handleException(String errorMessage, Throwable e) throws Exception {
        log.error((Object)errorMessage);
        throw new Exception(errorMessage, e);
    }
}

