/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.modules.sso.common.builders;

import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.modules.sso.common.util.SSOAgentCarbonX509Credential;
import org.jaggeryjs.modules.sso.common.util.Util;
import org.jaggeryjs.modules.sso.common.util.X509CredentialImpl;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.util.Base64;

public class AuthReqBuilder {
    private static Log log = LogFactory.getLog(AuthReqBuilder.class);

    public AuthnRequest buildAuthenticationRequest(String issuerId) throws Exception {
        Util.doBootstrap();
        AuthnRequest authnRequest = (AuthnRequest)Util.buildXMLObject(AuthnRequest.DEFAULT_ELEMENT_NAME);
        authnRequest.setID(Util.createID());
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        authnRequest.setIssueInstant(new DateTime());
        authnRequest.setIssuer(AuthReqBuilder.buildIssuer(issuerId));
        authnRequest.setNameIDPolicy(AuthReqBuilder.buildNameIDPolicy());
        return authnRequest;
    }

    public AuthnRequest buildAuthenticationRequest(String issuerId, String destination, String acsUrl, boolean isPassive, int tenantId, String tenantDomain, String nameIdPolicy) throws Exception {
        Util.doBootstrap();
        AuthnRequest authnRequest = (AuthnRequest)Util.buildXMLObject(AuthnRequest.DEFAULT_ELEMENT_NAME);
        authnRequest.setID(Util.createID());
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        authnRequest.setIssueInstant(new DateTime());
        authnRequest.setIssuer(AuthReqBuilder.buildIssuer(issuerId));
        authnRequest.setNameIDPolicy(Util.buildNameIDPolicy(nameIdPolicy));
        if (!StringUtils.isEmpty((String)acsUrl)) {
            acsUrl = Util.processAcsUrl(acsUrl);
            authnRequest.setAssertionConsumerServiceURL(acsUrl);
        }
        if (isPassive) {
            authnRequest.setIsPassive(Boolean.valueOf(true));
        }
        authnRequest.setDestination(destination);
        SSOAgentCarbonX509Credential ssoAgentCarbonX509Credential = new SSOAgentCarbonX509Credential(tenantId, tenantDomain);
        AuthReqBuilder.setSignature(authnRequest, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", new X509CredentialImpl(ssoAgentCarbonX509Credential));
        return authnRequest;
    }

    public static AuthnRequest setSignature(AuthnRequest authnRequest, String signatureAlgorithm, X509Credential cred) throws Exception {
        try {
            Signature signature = (Signature)Util.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.setSigningCredential((Credential)cred);
            signature.setSignatureAlgorithm(signatureAlgorithm);
            signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            KeyInfo keyInfo = (KeyInfo)Util.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
            X509Data data = (X509Data)Util.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
            X509Certificate cert = (X509Certificate)Util.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
            String value = Base64.encodeBytes((byte[])cred.getEntityCertificate().getEncoded());
            cert.setValue(value);
            data.getX509Certificates().add(cert);
            keyInfo.getX509Datas().add(data);
            signature.setKeyInfo(keyInfo);
            authnRequest.setSignature(signature);
            ArrayList<Signature> signatureList = new ArrayList<Signature>();
            signatureList.add(signature);
            MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)authnRequest);
            marshaller.marshall((XMLObject)authnRequest);
            Signer.signObjects(signatureList);
            return authnRequest;
        }
        catch (CertificateEncodingException e) {
            AuthReqBuilder.handleException("Error getting certificate", e);
        }
        catch (MarshallingException e) {
            AuthReqBuilder.handleException("Error while marshalling auth request", e);
        }
        catch (SignatureException e) {
            AuthReqBuilder.handleException("Error while signing the SAML Request message", e);
        }
        catch (Exception e) {
            AuthReqBuilder.handleException("Error while signing the SAML Request message", e);
        }
        return null;
    }

    private static Issuer buildIssuer(String issuerId) {
        IssuerBuilder issuerBuilder = new IssuerBuilder();
        Issuer issuer = issuerBuilder.buildObject();
        issuer.setValue(issuerId);
        return issuer;
    }

    private static NameIDPolicy buildNameIDPolicy() {
        NameIDPolicy nameIDPolicy = new NameIDPolicyBuilder().buildObject();
        nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        nameIDPolicy.setAllowCreate(Boolean.valueOf(true));
        return nameIDPolicy;
    }

    private static void handleException(String errorMessage, Throwable e) throws Exception {
        log.error((Object)errorMessage);
        throw new Exception(errorMessage, e);
    }
}

