/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.endpoint.util.client.api;

import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.mgt.endpoint.util.IdentityManagementEndpointUtil;
import org.wso2.carbon.identity.mgt.endpoint.util.client.ApiClient;
import org.wso2.carbon.identity.mgt.endpoint.util.client.ApiException;
import org.wso2.carbon.identity.mgt.endpoint.util.client.Configuration;
import org.wso2.carbon.identity.mgt.endpoint.util.client.Pair;
import org.wso2.carbon.identity.mgt.endpoint.util.client.model.CodeValidationRequest;
import org.wso2.carbon.identity.mgt.endpoint.util.client.model.Property;
import org.wso2.carbon.identity.mgt.endpoint.util.client.model.RecoveryInitiatingRequest;
import org.wso2.carbon.identity.mgt.endpoint.util.client.model.ResetPasswordRequest;
import org.wso2.carbon.identity.mgt.endpoint.util.client.model.UserClaim;

public class NotificationApi {
    private ApiClient apiClient;
    String basePath = IdentityManagementEndpointUtil.buildEndpointUrl("/api/identity/recovery/v0.9");

    public NotificationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NotificationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public String recoverPasswordPost(RecoveryInitiatingRequest recoveryInitiatingRequest, String type, Boolean notify) throws ApiException {
        return this.recoverPasswordPost(recoveryInitiatingRequest, type, notify, null);
    }

    public String recoverPasswordPost(RecoveryInitiatingRequest recoveryInitiatingRequest, String type, Boolean notify, Map<String, String> headers) throws ApiException {
        RecoveryInitiatingRequest localVarPostBody = recoveryInitiatingRequest;
        if (recoveryInitiatingRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'recoveryInitiatingRequest' when calling recoverPasswordPost");
        }
        String tenantDomain = "carbon.super";
        if (StringUtils.isNotBlank((String)recoveryInitiatingRequest.getUser().getTenantDomain())) {
            tenantDomain = recoveryInitiatingRequest.getUser().getTenantDomain();
        }
        this.basePath = IdentityManagementEndpointUtil.getBasePath(tenantDomain, "/api/identity/recovery/v0.9");
        this.apiClient.setBasePath(this.basePath);
        String localVarPath = "/recover-password".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (MapUtils.isNotEmpty(headers)) {
            localVarHeaderParams.putAll(headers);
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "type", type));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "notify", notify));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void recoverUsernamePost(List<UserClaim> claim, String tenantDomain, Boolean notify) throws ApiException {
        List<UserClaim> localVarPostBody = claim;
        if (claim == null) {
            throw new ApiException(400, "Missing the required parameter 'claim' when calling recoverUsernamePost");
        }
        if (StringUtils.isBlank((String)tenantDomain)) {
            tenantDomain = "carbon.super";
        }
        this.basePath = IdentityManagementEndpointUtil.getBasePath(tenantDomain, "/api/identity/recovery/v0.9");
        this.apiClient.setBasePath(this.basePath);
        String localVarPath = "/recover-username/".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tenant-domain", tenantDomain));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "notify", notify));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void setPasswordPost(ResetPasswordRequest resetPasswordRequest) throws ApiException {
        ResetPasswordRequest localVarPostBody = resetPasswordRequest;
        if (resetPasswordRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'resetPasswordRequest' when calling setPasswordPost");
        }
        String userTenantDomain = "carbon.super";
        List<Property> properties = resetPasswordRequest.getProperties();
        for (Property property : properties) {
            if (!StringUtils.equalsIgnoreCase((String)"tenantdomain", (String)property.getKey())) continue;
            userTenantDomain = property.getValue();
            properties.remove(property);
            break;
        }
        this.basePath = IdentityManagementEndpointUtil.getBasePath(userTenantDomain, "/api/identity/recovery/v0.9");
        this.apiClient.setBasePath(this.basePath);
        String localVarPath = "/set-password".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void setPasswordPost(ResetPasswordRequest resetPasswordRequest, Map<String, String> localVarHeaderParams) throws ApiException {
        ResetPasswordRequest localVarPostBody = resetPasswordRequest;
        if (resetPasswordRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'resetPasswordRequest' when calling setPasswordPost");
        }
        String userTenantDomain = "carbon.super";
        List<Property> properties = resetPasswordRequest.getProperties();
        for (Property property : properties) {
            if (!StringUtils.equalsIgnoreCase((String)"tenantdomain", (String)property.getKey())) continue;
            userTenantDomain = property.getValue();
            properties.remove(property);
            break;
        }
        this.basePath = IdentityManagementEndpointUtil.getBasePath(userTenantDomain, "/api/identity/recovery/v0.9");
        this.apiClient.setBasePath(this.basePath);
        String localVarPath = "/set-password".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void validateCodePostCall(CodeValidationRequest code) throws ApiException {
        if (code == null) {
            throw new ApiException(400, "Missing the required parameter 'code' when calling validateCodePost(Async)");
        }
        String[] contentType = new String[]{"application/json"};
        String headerAccept = this.apiClient.selectHeaderAccept(contentType);
        String tenantDomain = this.getTenantDomain(code);
        this.basePath = IdentityManagementEndpointUtil.getBasePath(tenantDomain, "/api/identity/recovery/v0.9");
        this.apiClient.setBasePath(this.basePath);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (headerAccept != null) {
            headerParams.put("Accept", headerAccept);
        }
        String headerContentType = this.apiClient.selectHeaderContentType(contentType);
        headerParams.put("Content-Type", headerContentType);
        String[] authNames = new String[]{};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        String path = "/validate-code".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        this.apiClient.invokeAPI(path, "POST", queryParams, code, headerParams, formParams, headerAccept, headerContentType, authNames, localVarReturnType);
    }

    private String getTenantDomain(CodeValidationRequest code) {
        String tenantDomain = "carbon.super";
        List<Property> properties = code.getProperties();
        for (Property property : properties) {
            if (!StringUtils.isNotEmpty((String)property.getKey()) || !"tenantDomain".equals(property.getKey())) continue;
            tenantDomain = property.getValue();
        }
        return tenantDomain;
    }
}

