/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.endpoint.util.client;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.idp.xsd.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.idp.xsd.IdentityProviderProperty;
import org.wso2.carbon.identity.mgt.endpoint.util.IdentityManagementEndpointUtil;
import org.wso2.carbon.identity.mgt.endpoint.util.IdentityManagementServiceUtil;
import org.wso2.carbon.identity.mgt.endpoint.util.client.IdentityRecoveryException;
import org.wso2.carbon.idp.mgt.stub.IdentityProviderMgtServiceStub;

public class CallBackValidator {
    private static final Log log = LogFactory.getLog(CallBackValidator.class);

    public boolean isValidCallbackURL(String callbackURL, String tenantDomain) throws IdentityRecoveryException {
        IdentityProvider residentIdP;
        if (StringUtils.isBlank((String)tenantDomain)) {
            tenantDomain = "carbon.super";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Tenant domain is considered as super tenant domain: " + tenantDomain));
            }
        }
        StringBuilder builder = new StringBuilder();
        String serviceURL = builder.append(IdentityManagementServiceUtil.getInstance().getServiceContextURL()).append("/IdentityProviderMgtService.IdentityProviderMgtServiceHttpsSoap11Endpoint/").toString().replaceAll("(?<!(http:|https:))//", "/");
        try {
            IdentityProviderMgtServiceStub idPMgtStub = new IdentityProviderMgtServiceStub(serviceURL);
            ServiceClient idpClient = idPMgtStub._getServiceClient();
            IdentityManagementEndpointUtil.authenticate(idpClient);
            residentIdP = idPMgtStub.getResidentIdP();
        }
        catch (AxisFault axisFault) {
            throw new IdentityRecoveryException("Error while instantiating IdentityProviderMgtServiceStub", axisFault);
        }
        catch (Exception e) {
            throw new IdentityRecoveryException("Error occurred when getting residentIDP configurations.", e);
        }
        IdentityProviderProperty[] idpProperties = null;
        if (residentIdP != null) {
            idpProperties = residentIdP.getIdpProperties();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Resident identity provider is not found for the tenant domain: " + tenantDomain));
        }
        String callbackRegex = null;
        if (idpProperties != null) {
            for (IdentityProviderProperty property : idpProperties) {
                if (!"Recovery.CallbackRegex".equals(property.getValue())) continue;
                callbackRegex = property.getValue();
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("Configured recovery callback URL regex: " + callbackRegex));
                break;
            }
        }
        if (StringUtils.isNotBlank((String)callbackURL)) {
            try {
                String encodeURL = URLEncoder.encode(callbackURL, "UTF-8");
                URI uri = new URI(encodeURL);
                callbackURL = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, null).toString();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Callback URL in the username recovery request: " + callbackURL));
                }
            }
            catch (URISyntaxException e) {
                throw new IdentityRecoveryException("Error occurred while formatting the provided callback URL. ", e);
            }
            catch (UnsupportedEncodingException e) {
                throw new IdentityRecoveryException("Error occurred while encoding the provided callback URL.", e);
            }
        }
        return callbackRegex == null || callbackURL.matches(callbackRegex);
    }

    @Deprecated
    public boolean isValidCallbackURL(String callbackURL, String tenantDomain, boolean isUserPortalURL) throws IdentityRecoveryException {
        if (isUserPortalURL) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Callback URL is equal to the user portal URL: " + callbackURL));
            }
            return true;
        }
        return this.isValidCallbackURL(callbackURL, tenantDomain);
    }
}

