/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.endpoint.util.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.mgt.endpoint.util.IdentityManagementEndpointUtil;
import org.wso2.carbon.identity.mgt.endpoint.util.IdentityManagementServiceUtil;
import org.wso2.carbon.identity.mgt.endpoint.util.client.ApiException;
import org.wso2.carbon.identity.mgt.endpoint.util.client.Pair;
import org.wso2.carbon.identity.mgt.endpoint.util.client.StringUtil;

public class ApiClient {
    private static final String AUTHORIZATION = "Authorization";
    private static final String CLIENT = "Client ";
    private static final String X_HTTP_METHOD_OVERRIDE = "X-HTTP-Method-Override";
    private static final String PATCH = "PATCH";
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String PUT = "PUT";
    private static final String DELETE = "DELETE";
    private static final Log log = LogFactory.getLog(ApiClient.class);
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private String basePath = IdentityManagementEndpointUtil.buildEndpointUrl("/api/identity/recovery/v0.9");
    private boolean debugging = false;
    private int connectionTimeout = 0;
    private Client httpClient;
    private ObjectMapper objectMapper = new ObjectMapper();
    private int statusCode;
    private Map<String, List<String>> responseHeaders;
    private DateFormat dateFormat;

    public ApiClient() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        this.objectMapper.setDateFormat(ApiClient.buildDefaultDateFormat());
        this.dateFormat = ApiClient.buildDefaultDateFormat();
        this.rebuildHttpClient();
    }

    public static DateFormat buildDefaultDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat;
    }

    public ApiClient rebuildHttpClient() {
        JacksonJsonProvider jsonProvider = new JacksonJsonProvider(this.objectMapper);
        DefaultClientConfig conf = new DefaultClientConfig();
        conf.getSingletons().add(jsonProvider);
        Client client = Client.create((ClientConfig)conf);
        if (this.debugging) {
            client.addFilter((ClientFilter)new LoggingFilter());
        }
        this.httpClient = client;
        return this;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public ApiClient setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.rebuildHttpClient();
        return this;
    }

    public Client getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(Client httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        this.debugging = debugging;
        this.rebuildHttpClient();
        return this;
    }

    public int getConnectTimeout() {
        return this.connectionTimeout;
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        this.httpClient.setConnectTimeout(Integer.valueOf(connectionTimeout));
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.objectMapper.setDateFormat((DateFormat)dateFormat.clone());
        this.rebuildHttpClient();
        return this;
    }

    public Date parseDate(String str) {
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (StringUtils.isEmpty((String)name) || value == null) {
            return params;
        }
        if (!(value instanceof Collection)) {
            params.add(new Pair(name, this.parameterToString(value)));
            return params;
        }
        Collection valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        String string = collectionFormat = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if (collectionFormat.equals("multi")) {
            for (Object item : valueCollection) {
                params.add(new Pair(name, this.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        if (collectionFormat.equals("csv")) {
            delimiter = ",";
        } else if (collectionFormat.equals("ssv")) {
            delimiter = " ";
        } else if (collectionFormat.equals("tsv")) {
            delimiter = "\t";
        } else if (collectionFormat.equals("pipes")) {
            delimiter = "|";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : valueCollection) {
            sb.append(delimiter);
            sb.append(this.parameterToString(item));
        }
        params.add(new Pair(name, sb.substring(1)));
        return params;
    }

    public boolean isJsonMime(String mime) {
        return mime != null && mime.matches("(?i)application\\/json(;.*)?");
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public Object serialize(Object obj, String contentType, Map<String, Object> formParams) throws ApiException {
        if (contentType.startsWith("multipart/form-data")) {
            FormDataMultiPart mp = new FormDataMultiPart();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                if (param.getValue() instanceof File) {
                    File file = (File)param.getValue();
                    mp.bodyPart((BodyPart)new FileDataBodyPart(param.getKey(), file, MediaType.MULTIPART_FORM_DATA_TYPE));
                    continue;
                }
                mp.field(param.getKey(), (Object)this.parameterToString(param.getValue()), MediaType.MULTIPART_FORM_DATA_TYPE);
            }
            return mp;
        }
        if (contentType.startsWith("application/x-www-form-urlencoded")) {
            return this.getXWWWFormUrlencodedParams(formParams);
        }
        return obj;
    }

    private String buildUrl(String path, List<Pair> queryParams) {
        StringBuilder url = new StringBuilder();
        url.append(this.basePath).append(path);
        if (queryParams != null && !queryParams.isEmpty()) {
            String prefix = path.contains("?") ? "&" : "?";
            for (Pair param : queryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                String value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(this.escapeString(value));
            }
        }
        return url.toString();
    }

    private ClientResponse getAPIResponse(String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames) throws ApiException {
        if (body != null && !formParams.isEmpty()) {
            throw new ApiException(500, "Cannot have body and form params");
        }
        if (!this.isRequestMethodSupported(method)) {
            throw new ApiException(500, "unknown method type " + method);
        }
        String url = this.buildUrl(path, queryParams);
        if (log.isDebugEnabled()) {
            String headerParamsAsString = "";
            if (MapUtils.isNotEmpty(headerParams)) {
                headerParamsAsString = headerParams.keySet().stream().map(key -> key + "=" + (String)headerParams.get(key)).collect(Collectors.joining(", ", "{", "}"));
            }
            Object formParamsAsString = "";
            if (MapUtils.isNotEmpty(formParams)) {
                formParamsAsString = formParams.keySet().stream().map(key -> key + "=" + formParams.get(key)).collect(Collectors.joining(", ", "{", "}"));
            }
            log.debug((Object)String.format("Initiating api request for \npath=%s, \nmethod=%s, \nheaderParams=%s, \nformParams=%s, \naccept=%s, \ncontentType=%s", url, method, headerParamsAsString, formParamsAsString, accept, contentType));
        }
        WebResource.Builder builder = accept == null ? this.httpClient.resource(url).getRequestBuilder() : this.httpClient.resource(url).accept(new String[]{accept});
        for (Map.Entry entry : headerParams.entrySet()) {
            builder = (WebResource.Builder)builder.header((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : this.defaultHeaderMap.entrySet()) {
            if (headerParams.containsKey(entry.getKey())) continue;
            builder = (WebResource.Builder)builder.header((String)entry.getKey(), entry.getValue());
        }
        String toEncode = IdentityManagementServiceUtil.getInstance().getAppName() + ":" + String.valueOf(IdentityManagementServiceUtil.getInstance().getAppPassword());
        byte[] byArray = Base64.encodeBase64((byte[])toEncode.getBytes());
        String authHeader = new String(byArray, Charset.defaultCharset());
        try {
            ClientResponse response = null;
            if (GET.equals(method)) {
                response = (ClientResponse)((WebResource.Builder)builder.header(AUTHORIZATION, (Object)(CLIENT + authHeader))).get(ClientResponse.class);
            } else if (POST.equals(method)) {
                response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)builder.type(contentType)).header(AUTHORIZATION, (Object)(CLIENT + authHeader))).post(ClientResponse.class, this.serialize(body, contentType, formParams));
            } else if (PUT.equals(method)) {
                response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)builder.type(contentType)).header(AUTHORIZATION, (Object)(CLIENT + authHeader))).put(ClientResponse.class, this.serialize(body, contentType, formParams));
            } else if (DELETE.equals(method)) {
                response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)builder.type(contentType)).header(AUTHORIZATION, (Object)(CLIENT + authHeader))).delete(ClientResponse.class, this.serialize(body, contentType, formParams));
            } else if (PATCH.equals(method)) {
                response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)builder.type(contentType)).header(X_HTTP_METHOD_OVERRIDE, (Object)PATCH)).header(AUTHORIZATION, (Object)(CLIENT + authHeader))).post(ClientResponse.class, this.serialize(body, contentType, formParams));
            }
            if (log.isDebugEnabled()) {
                if (response != null) {
                    log.debug((Object)String.format("Response from the %s request made to url %s \nResponse: status=%s, statusMessage=%s", method, url, response.getStatusInfo().getStatusCode(), response.getStatusInfo().getReasonPhrase()));
                } else {
                    log.debug((Object)String.format("Response from the %s request made to url %s is null.", method, url));
                }
            }
            return response;
        }
        catch (Exception e) {
            String errMsg = String.format("Error while performing the request method: %s on the resource: %s", method, url);
            log.error((Object)errMsg, (Throwable)e);
            throw new ApiException(500, "Error while accessing the backend service");
        }
    }

    public <T> T invokeAPI(String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames, GenericType<T> returnType) throws ApiException {
        ClientResponse response = this.getAPIResponse(path, method, queryParams, body, headerParams, formParams, accept, contentType, authNames);
        this.statusCode = response.getStatusInfo().getStatusCode();
        this.responseHeaders = response.getHeaders();
        if (response.getStatusInfo().getStatusCode() == ClientResponse.Status.NO_CONTENT.getStatusCode()) {
            throw new ApiException(204, "No content Found");
        }
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            if (returnType != null && response.hasEntity()) {
                return (T)response.getEntity(returnType);
            }
            return null;
        }
        String message = "error";
        String respBody = null;
        if (response.hasEntity()) {
            try {
                message = respBody = (String)response.getEntity(String.class);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        throw new ApiException(response.getStatusInfo().getStatusCode(), message, (Map<String, List<String>>)response.getHeaders(), respBody);
    }

    private boolean isRequestMethodSupported(String method) {
        return GET.equals(method) || POST.equals(method) || PUT.equals(method) || DELETE.equals(method) || PATCH.equals(method);
    }

    private String getXWWWFormUrlencodedParams(Map<String, Object> formParams) {
        StringBuilder formParamBuilder = new StringBuilder();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            String valueStr = this.parameterToString(param.getValue());
            try {
                formParamBuilder.append(URLEncoder.encode(param.getKey(), "utf8")).append("=").append(URLEncoder.encode(valueStr, "utf8"));
                formParamBuilder.append("&");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        String encodedFormParams = formParamBuilder.toString();
        if (encodedFormParams.endsWith("&")) {
            encodedFormParams = encodedFormParams.substring(0, encodedFormParams.length() - 1);
        }
        return encodedFormParams;
    }
}

