/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.feature.mgt.core.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.feature.mgt.core.ProvisioningException;
import org.wso2.carbon.feature.mgt.core.internal.ServiceHolder;

public class RepositoryUtils {
    public static void addRepository(URI location, String nickName) throws ProvisioningException {
        IMetadataRepositoryManager metadataRepositoryManager = null;
        IArtifactRepositoryManager artifactRepositoryManager = null;
        if (location == null) {
            throw ProvisioningException.makeExceptionFromErrorCode("invalid.repo.location", "null value");
        }
        if (nickName == null || nickName.length() == 0) {
            throw ProvisioningException.makeExceptionFromErrorCode("invalid.repo.name", nickName == null ? "null value" : nickName);
        }
        try {
            metadataRepositoryManager = ServiceHolder.getMetadataRepositoryManager();
            artifactRepositoryManager = ServiceHolder.getArtifactRepositoryManager();
            if (metadataRepositoryManager.contains(location)) {
                return;
            }
            metadataRepositoryManager.addRepository(location);
            artifactRepositoryManager.addRepository(location);
            metadataRepositoryManager.loadRepository(location, (IProgressMonitor)new NullProgressMonitor());
            metadataRepositoryManager.setRepositoryProperty(location, "p2.nickname", nickName);
            artifactRepositoryManager.loadRepository(location, (IProgressMonitor)new NullProgressMonitor());
            artifactRepositoryManager.setRepositoryProperty(location, "p2.nickname", nickName);
        }
        catch (Exception e) {
            metadataRepositoryManager.removeRepository(location);
            artifactRepositoryManager.removeRepository(location);
            throw ProvisioningException.makeExceptionFromErrorCode("failed.add.repository", e, location);
        }
    }

    public static void updateRepository(URI prevLocation, String prevNickName, URI updatedLocation, String updatedNickName) throws ProvisioningException {
        if (updatedLocation == null) {
            throw ProvisioningException.makeExceptionFromErrorCode("invalid.repo.location", "null value");
        }
        if (updatedNickName == null || updatedNickName.length() == 0) {
            throw ProvisioningException.makeExceptionFromErrorCode("invalid.repo.name", updatedNickName == null ? "null value" : updatedNickName);
        }
        try {
            if (!prevLocation.equals(updatedLocation)) {
                RepositoryUtils.removeRepository(prevLocation);
                RepositoryUtils.addRepository(updatedLocation, updatedNickName);
            } else if (!prevNickName.equals(updatedNickName)) {
                RepositoryUtils.setMetadataRepositoryProperty(prevLocation, "p2.nickname", updatedNickName);
            }
        }
        catch (Exception e) {
            throw ProvisioningException.makeExceptionFromErrorCode("failed.update.repository", e, updatedLocation);
        }
    }

    public static void removeRepository(URI location) throws ProvisioningException {
        if (location == null) {
            throw ProvisioningException.makeExceptionFromErrorCode("invalid.repo.location", "null value");
        }
        try {
            RepositoryUtils.removeMetadataRepository(location);
            RepositoryUtils.removeArtifactRepository(location);
        }
        catch (Exception e) {
            throw ProvisioningException.makeExceptionFromErrorCode("failed.remove.repository", e, location);
        }
    }

    public static void enableRepository(URI location, boolean enable) throws ProvisioningException {
        if (location == null) {
            throw ProvisioningException.makeExceptionFromErrorCode("invalid.repo.location", "null value");
        }
        try {
            IMetadataRepositoryManager metadataRepositoryManager = ServiceHolder.getMetadataRepositoryManager();
            IArtifactRepositoryManager artifactRepositoryManager = ServiceHolder.getArtifactRepositoryManager();
            metadataRepositoryManager.setEnabled(location, enable);
            artifactRepositoryManager.setEnabled(location, enable);
        }
        catch (Exception e) {
            throw ProvisioningException.makeExceptionFromErrorCode("failed.enable.repository", e, location);
        }
    }

    public static boolean isRepositoryEnabled(URI location) throws ProvisioningException {
        IMetadataRepositoryManager metadataRepositoryManager = ServiceHolder.getMetadataRepositoryManager();
        IArtifactRepositoryManager artifactRepositoryManager = ServiceHolder.getArtifactRepositoryManager();
        return metadataRepositoryManager.isEnabled(location) && artifactRepositoryManager.isEnabled(location);
    }

    public static URI[] getRepositoryList(int type) throws ProvisioningException {
        try {
            IMetadataRepositoryManager metadataRepositoryManager = ServiceHolder.getMetadataRepositoryManager();
            return metadataRepositoryManager.getKnownRepositories(type);
        }
        catch (Exception e) {
            throw ProvisioningException.makeExceptionFromErrorCode("failed.get.repositories", e);
        }
    }

    public static String getMetadataRepositoryProperty(URI location, String key) throws ProvisioningException {
        IMetadataRepositoryManager metadataRepositoryManager = ServiceHolder.getMetadataRepositoryManager();
        return metadataRepositoryManager.getRepositoryProperty(location, key);
    }

    public static Collection getInstallableUnitsInRepositories(URI location, IQuery query) throws ProvisioningException {
        Object queryable = location != null ? RepositoryUtils.getMetadataRepository(location) : ServiceHolder.getMetadataRepositoryManager();
        return queryable.query(query, (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet();
    }

    public static IQueryable getQuerybleRepositoryManager(URI location) {
        try {
            Object queryable = location != null ? RepositoryUtils.getMetadataRepository(location) : ServiceHolder.getMetadataRepositoryManager();
            return queryable;
        }
        catch (ProvisioningException ignore) {
            return null;
        }
    }

    public static IInstallableUnit getInstallableUnit(String id, String version) throws ProvisioningException {
        return RepositoryUtils.getInstallableUnit(QueryUtil.createIUQuery((String)id, (Version)Version.create((String)version)));
    }

    public static String addDefaultRepository() throws ProvisioningException, URISyntaxException {
        String repositoryName = null;
        String repositoryURL = null;
        ServerConfigurationService serverConfigService = ServiceHolder.getServerConfigurationService();
        repositoryName = serverConfigService.getFirstProperty("FeatureRepository.RepositoryName");
        repositoryURL = serverConfigService.getFirstProperty("FeatureRepository.RepositoryURL");
        if (repositoryName != null && repositoryURL != null) {
            IMetadataRepositoryManager metadataRepositoryManager = ServiceHolder.getMetadataRepositoryManager();
            IArtifactRepositoryManager artifactRepositoryManager = ServiceHolder.getArtifactRepositoryManager();
            try {
                URI location = new URI(repositoryURL);
                if (!metadataRepositoryManager.contains(location)) {
                    metadataRepositoryManager.addRepository(location);
                    metadataRepositoryManager.setRepositoryProperty(location, "p2.nickname", repositoryName);
                    artifactRepositoryManager.addRepository(location);
                    artifactRepositoryManager.setRepositoryProperty(location, "p2.nickname", repositoryName);
                }
            }
            catch (Exception e) {
                throw ProvisioningException.makeExceptionFromErrorCode("failed.add.repository", e, repositoryURL);
            }
        }
        return repositoryURL;
    }

    public static IInstallableUnit getInstallableUnit(IQuery query) throws ProvisioningException {
        Collection collection = RepositoryUtils.getInstallableUnitsInRepositories(null, query);
        IInstallableUnit[] installableUnits = collection.toArray(new IInstallableUnit[0]);
        if (installableUnits == null || installableUnits.length == 0) {
            return null;
        }
        return installableUnits[0];
    }

    private static IMetadataRepository getMetadataRepository(URI location) throws ProvisioningException {
        IMetadataRepositoryManager metadataRepositoryManager = ServiceHolder.getMetadataRepositoryManager();
        try {
            return metadataRepositoryManager.loadRepository(location, null);
        }
        catch (ProvisionException e) {
            throw new ProvisioningException(e.getMessage(), e);
        }
    }

    private static void setMetadataRepositoryProperty(URI location, String key, String value) throws ProvisioningException {
        IMetadataRepositoryManager metadataRepositoryManager = ServiceHolder.getMetadataRepositoryManager();
        metadataRepositoryManager.setRepositoryProperty(location, key, value);
    }

    private static void removeMetadataRepository(URI location) throws ProvisioningException {
        IMetadataRepositoryManager metadataRepositoryManager = ServiceHolder.getMetadataRepositoryManager();
        metadataRepositoryManager.removeRepository(location);
    }

    private static void removeArtifactRepository(URI location) throws ProvisioningException {
        IArtifactRepositoryManager artifactRepositoryManager = ServiceHolder.getArtifactRepositoryManager();
        artifactRepositoryManager.removeRepository(location);
    }
}

