/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.feature.mgt.core.operations;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.wso2.carbon.feature.mgt.core.ProvisioningException;
import org.wso2.carbon.feature.mgt.core.ResolutionResult;
import org.wso2.carbon.feature.mgt.core.internal.ServiceHolder;

public abstract class ProfileChangeOperation {
    private String actionType;
    public static final long SIZE_UNKNOWN = -1L;
    public static final long SIZE_UNAVAILABLE = -2L;
    public static final long SIZE_NOTAPPLICABLE = -3L;
    protected IInstallableUnit[] iusToInstall = new IInstallableUnit[0];
    protected IInstallableUnit[] iusToUninstall = new IInstallableUnit[0];
    protected long timestamp;

    public IInstallableUnit[] getIusToInstall() {
        return Arrays.copyOf(this.iusToInstall, this.iusToInstall.length);
    }

    public void setIusToInstall(IInstallableUnit[] iusToInstall) {
        this.iusToInstall = Arrays.copyOf(iusToInstall, iusToInstall.length);
    }

    public IInstallableUnit[] getIusToUninstall() {
        return Arrays.copyOf(this.iusToUninstall, this.iusToUninstall.length);
    }

    public void setIusToUninstall(IInstallableUnit[] iusToUninstall) {
        this.iusToUninstall = Arrays.copyOf(iusToUninstall, iusToUninstall.length);
    }

    public ProfileChangeOperation(String actionType) {
        this.actionType = actionType;
    }

    public ResolutionResult reviewProfileChangeAction(IProfile profile) throws ProvisioningException {
        MultiStatus initialStatus = this.getInitialStatus();
        ProfileChangeRequest profileChangeRequest = this.generateProfileChangeRequest(profile, initialStatus, null);
        IProvisioningPlan provisioningPlan = this.generateProvisioningPlan(profileChangeRequest, ServiceHolder.getProvisioningContext());
        if (provisioningPlan == null) {
            throw new ProvisioningException("Failed to generate the Provisioning Plan");
        }
        return this.generateResolutionResult(profileChangeRequest, provisioningPlan, initialStatus);
    }

    private IProvisioningPlan generateProvisioningPlan(ProfileChangeRequest request, ProvisioningContext context) throws ProvisioningException {
        IPlanner planner = ServiceHolder.getPlanner();
        return planner.getProvisioningPlan((IProfileChangeRequest)request, context, (IProgressMonitor)new NullProgressMonitor());
    }

    public ResolutionResult generateResolutionResult(ProfileChangeRequest originalRequest, IProvisioningPlan plan, MultiStatus originalStatus) throws ProvisioningException {
        PlannerStatus plannerStatus;
        IEngine engine = ServiceHolder.getP2Engine();
        ResolutionResult report = new ResolutionResult();
        report.setProvisioningPlan(plan);
        if (ProfileChangeOperation.nothingToDo(originalRequest)) {
            IStatus[] details;
            report.addSummaryStatus((IStatus)new Status(4, "temp", 10050, "Cannot complete the request.  See the error log for details.", null));
            for (IStatus detail : details = originalStatus.getChildren()) {
                report.addSummaryStatus(detail);
            }
            return report;
        }
        if (originalStatus != null && originalStatus.getChildren().length > 0) {
            report.addSummaryStatus((IStatus)originalStatus);
        }
        if (!plan.getStatus().isOK()) {
            report.addSummaryStatus(plan.getStatus());
        }
        PlannerStatus plannerStatus2 = plannerStatus = plan.getStatus() instanceof PlannerStatus ? (PlannerStatus)plan.getStatus() : null;
        if (plannerStatus == null) {
            return report;
        }
        if (plan.getStatus().getSeverity() != 4) {
            Collection iusAdded = originalRequest.getAdditions();
            for (IInstallableUnit added : iusAdded) {
                RequestStatus rs = (RequestStatus)plannerStatus.getRequestChanges().get(added);
                if (rs == null) continue;
                if (rs.getSeverity() == 4) {
                    Status fail = new Status(4, "temp", 10011, added.getId() + " is not applicable to the current configuration and will not be installed.", null);
                    report.addStatus(added, (IStatus)fail);
                    report.addSummaryStatus((IStatus)fail);
                    report.addFailedInstallableUnit(added);
                    continue;
                }
                report.addReviewedInstallableUnit(added);
            }
            Collection iusRemoved = originalRequest.getRemovals();
            for (IInstallableUnit removed : iusRemoved) {
                RequestStatus rs = (RequestStatus)plannerStatus.getRequestChanges().get(removed);
                if (rs == null) continue;
                if (rs.getSeverity() == 4) {
                    Status fail = new Status(1, "temp", 10007, removed.getId() + " cannot be fully uninstalled because other installed software requires it.  The parts that are not required will be uninstalled.", null);
                    report.addStatus(removed, (IStatus)fail);
                    report.addSummaryStatus((IStatus)fail);
                    report.addFailedUninstallableUnit(removed);
                    continue;
                }
                report.addReviewedUninstallableUnit(removed);
            }
        }
        long size = 0L;
        if (report.getReviewedInstallableUnits().length != 0) {
            size = this.getSize(plan, plan.getProfile(), engine, ServiceHolder.getProvisioningContext(), null);
        }
        report.setInstallationSize(this.getFormattedSize(size));
        return report;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public abstract ProfileChangeRequest generateProfileChangeRequest(IProfile var1, MultiStatus var2, IProgressMonitor var3);

    public abstract long getSize(IProvisioningPlan var1, IProfile var2, IEngine var3, ProvisioningContext var4, IProgressMonitor var5);

    public abstract MultiStatus getInitialStatus();

    private static boolean nothingToDo(ProfileChangeRequest request) {
        return request.getAdditions().size() == 0 && request.getRemovals().size() == 0 && request.getInstallableUnitProfilePropertiesToAdd().size() == 0 && request.getInstallableUnitProfilePropertiesToRemove().size() == 0;
    }

    private String getFormattedSize(long size) {
        if (size == -1L || size == -2L) {
            return "Unknown";
        }
        if (size > 1000L) {
            long kb = size / 1000L;
            return NumberFormat.getInstance().format(kb) + " kb";
        }
        return NumberFormat.getInstance().format(size);
    }
}

