/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.feature.mgt.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.wso2.carbon.feature.mgt.core.util.IUPropertyUtils;

public class ResolutionResult
implements Serializable {
    private static final long serialVersionUID = -5597451836018051452L;
    private static final String NESTING_INDENT = "  ";
    private HashMap iuToStatusMap = new HashMap();
    private MultiStatus summaryStatus;
    private IProvisioningPlan provisioningPlan;
    private String installationSize;
    private ArrayList<IInstallableUnit> reviewedInstallableUnits = new ArrayList();
    private ArrayList<IInstallableUnit> reviewedUninstallableUnits = new ArrayList();
    private ArrayList<IInstallableUnit> failedinstallableUnits = new ArrayList();
    private ArrayList<IInstallableUnit> failedUninstallableUnits = new ArrayList();

    public void addFailedUninstallableUnit(IInstallableUnit iu) {
        this.failedUninstallableUnits.add(iu);
    }

    public void addFailedInstallableUnit(IInstallableUnit iu) {
        this.failedinstallableUnits.add(iu);
    }

    public void addReviewedUninstallableUnit(IInstallableUnit iu) {
        this.reviewedUninstallableUnits.add(iu);
    }

    public void addReviewedInstallableUnit(IInstallableUnit iu) {
        this.reviewedInstallableUnits.add(iu);
    }

    public IInstallableUnit[] getFailedInstallableUnits() {
        IInstallableUnit[] ius = new IInstallableUnit[this.failedinstallableUnits.size()];
        return this.failedinstallableUnits.toArray(ius);
    }

    public IInstallableUnit[] getFailedUninstallableUnits() {
        IInstallableUnit[] ius = new IInstallableUnit[this.failedUninstallableUnits.size()];
        return this.failedUninstallableUnits.toArray(ius);
    }

    public IInstallableUnit[] getReviewedInstallableUnits() {
        IInstallableUnit[] ius = new IInstallableUnit[this.reviewedInstallableUnits.size()];
        return this.reviewedInstallableUnits.toArray(ius);
    }

    public IInstallableUnit[] getReviewedUninstallableUnits() {
        IInstallableUnit[] ius = new IInstallableUnit[this.reviewedUninstallableUnits.size()];
        return this.reviewedUninstallableUnits.toArray(ius);
    }

    public String getInstallationSize() {
        return this.installationSize;
    }

    public void setInstallationSize(String installationSize) {
        this.installationSize = installationSize;
    }

    public IProvisioningPlan getProvisioningPlan() {
        return this.provisioningPlan;
    }

    public void setProvisioningPlan(IProvisioningPlan provisioningPlan) {
        this.provisioningPlan = provisioningPlan;
    }

    public IStatus getSummaryStatus() {
        if (this.summaryStatus != null) {
            return this.summaryStatus;
        }
        return Status.OK_STATUS;
    }

    public void addSummaryStatus(IStatus status) {
        if (this.summaryStatus == null) {
            this.summaryStatus = new MultiStatus("temp", 0, "Operation details", null);
        }
        this.summaryStatus.add(status);
    }

    public IStatus statusOf(IInstallableUnit iu) {
        return (IStatus)this.iuToStatusMap.get(iu);
    }

    public void addStatus(IInstallableUnit iu, IStatus status) {
        MultiStatus iuSummaryStatus = (MultiStatus)this.iuToStatusMap.get(iu);
        if (iuSummaryStatus != null) {
            iuSummaryStatus.add(status);
        }
    }

    private String getIUString(IInstallableUnit iu) {
        if (iu == null) {
            return "Items";
        }
        String name = IUPropertyUtils.getIUProperty(iu, "org.eclipse.equinox.p2.name");
        if (name != null) {
            return name;
        }
        return iu.getId();
    }

    public String getSummaryReport() {
        if (this.summaryStatus != null) {
            StringBuffer buffer = new StringBuffer();
            this.appendDetailText((IStatus)this.summaryStatus, buffer, -1, false);
            return buffer.toString();
        }
        return "";
    }

    public String getDetailedReport(IInstallableUnit[] ius) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < ius.length; ++i) {
            MultiStatus iuStatus = (MultiStatus)this.iuToStatusMap.get(ius[i]);
            if (iuStatus == null) continue;
            this.appendDetailText((IStatus)iuStatus, buffer, 0, true);
        }
        String report = buffer.toString();
        if (report.length() == 0) {
            return null;
        }
        return report;
    }

    void appendDetailText(IStatus status, StringBuffer buffer, int indent, boolean includeTopLevelMessage) {
        Throwable t;
        if (includeTopLevelMessage) {
            for (int i = 0; i < indent; ++i) {
                buffer.append(NESTING_INDENT);
            }
            if (status.getMessage() != null) {
                buffer.append(status.getMessage());
            }
        }
        if ((t = status.getException()) != null) {
            buffer.append('\n');
            for (int i = 0; i <= indent; ++i) {
                buffer.append(NESTING_INDENT);
            }
            if (t instanceof CoreException) {
                IStatus exceptionStatus = ((CoreException)t).getStatus();
                if (exceptionStatus != null && exceptionStatus.getMessage() != null) {
                    buffer.append(exceptionStatus.getMessage());
                } else {
                    String details = t.getLocalizedMessage();
                    if (details != null) {
                        buffer.append(details);
                    }
                }
            } else {
                String details = t.getLocalizedMessage();
                if (details != null) {
                    buffer.append(details);
                }
            }
        }
        IStatus[] children = status.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (buffer.length() > 0) {
                buffer.append('\n');
            }
            this.appendDetailText(children[i], buffer, indent + 1, true);
        }
    }
}

