/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.eventing.template;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.eventing.template.NotificationTemplate;

public class RegistryNotification
implements NotificationTemplate {
    private static final String TEMPLATE_PATH = "/repository/components/org.wso2.carbon.governance/templates";
    private static final String DEFAULT_TEMPLATE_NAME = "default";
    private static final String TEMPLATE_EXT = ".html";
    private static final String DEFAULT_TEMPLATE = "/repository/components/org.wso2.carbon.governance/templates/default.html";
    private static final Log log = LogFactory.getLog(RegistryNotification.class);

    @Override
    public String populateEmailMessage(Registry configRegistry, String resourcePath, String message, String eventType) {
        String templateLocation = "/repository/components/org.wso2.carbon.governance/templates/" + eventType.toLowerCase() + TEMPLATE_EXT;
        Resource template = null;
        try {
            Object object;
            if (configRegistry.resourceExists(templateLocation)) {
                template = configRegistry.get(templateLocation);
            } else if (configRegistry.resourceExists(DEFAULT_TEMPLATE)) {
                template = configRegistry.get(DEFAULT_TEMPLATE);
            }
            if (template != null && (object = template.getContent()) != null) {
                String content = object instanceof String ? (String)object : new String((byte[])object);
                return content.replace("$$message$$", message);
            }
        }
        catch (RegistryException e) {
            log.warn((Object)"An error occurred while accessing email template from the registry");
        }
        return null;
    }
}

