/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.eventing;

import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.event.core.Message;
import org.wso2.carbon.registry.eventing.events.DispatchEvent;
import org.wso2.carbon.registry.eventing.internal.EventingDataHolder;
import org.wso2.carbon.registry.eventing.template.NotificationTemplate;

public class MimeEmailMessageHandler {
    public static final int MIN_THREAD = 8;
    public static final int MAX_THREAD = 100;
    public static final String MIN_THREAD_NAME = "minThread";
    public static final String MAX_THREAD_NAME = "maxThread";
    public static final String DEFAULT_KEEP_ALIVE_TIME_NAME = "defaultKeepAliveTime";
    public static final long DEFAULT_KEEP_ALIVE_TIME = 20L;
    private static final Log log = LogFactory.getLog(MimeEmailMessageHandler.class);
    private static Session session;
    private static ThreadPoolExecutor threadPoolExecutor;
    private InternetAddress smtpFromAddress = null;

    public void sendMimeMessage(ConfigurationContext configContext, String message, String subject, String toAddress) throws RegistryException {
        Properties props = new Properties();
        if (configContext != null && configContext.getAxisConfiguration().getTransportOut("mailto") != null) {
            ArrayList params = configContext.getAxisConfiguration().getTransportOut("mailto").getParameters();
            for (Parameter parm : params) {
                props.put(parm.getName(), parm.getValue());
            }
        }
        if (threadPoolExecutor == null) {
            threadPoolExecutor = new ThreadPoolExecutor(8, 100, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000));
        }
        String smtpFrom = props.getProperty("mail.smtp.from");
        try {
            this.smtpFromAddress = new InternetAddress(smtpFrom);
        }
        catch (AddressException e) {
            log.error((Object)"Error in retrieving smtp address");
            throw new RegistryException("Error in transforming smtp address");
        }
        final String smtpUsername = props.getProperty("mail.smtp.user");
        final String smtpPassword = props.getProperty("mail.smtp.password");
        session = smtpUsername != null && smtpPassword != null ? Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(smtpUsername, smtpPassword);
            }
        }) : Session.getInstance((Properties)props);
        threadPoolExecutor.submit(new EmailSender(toAddress, subject, message.toString(), "text/html"));
    }

    public String getEmailSubject(Message message, String path, String event) {
        String mailHeader = message.getProperty("Subject");
        if (mailHeader == null && (path == null || path.length() == 0)) {
            mailHeader = "[" + event + "]";
        } else if (mailHeader == null) {
            mailHeader = "[" + event + "] at path: " + path;
        }
        return mailHeader;
    }

    public String getEmailMessage(Message message, int tenantId) {
        String emailMessage = null;
        DispatchEvent event = (DispatchEvent)message;
        String eventType = event.getEvent().getClass().getSimpleName();
        String resourcePath = event.getEvent().getOperationDetails().getPath();
        if (EventingDataHolder.getInstance().getRegistryService() != null) {
            try {
                UserRegistry registry = EventingDataHolder.getInstance().getRegistryService().getConfigSystemRegistry(tenantId);
                String mesageContent = event.getEvent().getMessage().toString();
                String className = EventingDataHolder.getInstance().getNotificationConfig().getConfigurationClass();
                Class<?> clazz = Class.forName(className);
                Object instance = clazz.newInstance();
                if (instance instanceof NotificationTemplate) {
                    NotificationTemplate template = (NotificationTemplate)instance;
                    emailMessage = template.populateEmailMessage((Registry)registry, resourcePath, mesageContent, eventType);
                }
            }
            catch (InstantiationException e) {
                log.warn((Object)"Error while instantiating template");
            }
            catch (IllegalAccessException e) {
                log.warn((Object)"Error while instantiating template");
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)"Error while instantiating template");
            }
            catch (RegistryException e) {
                log.warn((Object)"Error while instantiating template");
            }
        }
        return emailMessage;
    }

    class EmailSender
    implements Runnable {
        String to;
        String subject;
        String body;
        String type;

        EmailSender(String to, String subject, String body, String type) {
            this.to = to;
            this.subject = subject;
            this.body = body;
            this.type = type;
        }

        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Format of the email: " + this.to + "->" + this.type));
            }
            MimeMessage message = new MimeMessage(session);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.body);
            String finalString = stringBuilder.toString();
            try {
                message.setFrom((Address)MimeEmailMessageHandler.this.smtpFromAddress);
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.to));
                message.setSubject(this.subject);
                message.setSentDate(new Date());
                message.setContent((Object)finalString, this.type);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Meta data of the email configured successfully");
                }
                Transport.send((javax.mail.Message)message);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Mail sent to the EmailID " + this.to + " Successfully"));
                }
            }
            catch (MessagingException e) {
                log.error((Object)("Error in sending the Email : " + MimeEmailMessageHandler.this.smtpFromAddress.toString() + "::" + e.getMessage()), (Throwable)e);
            }
        }
    }
}

