/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.stratos.deployment.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.stratos.deployment.CloudDeploymentInterceptor;
import org.wso2.carbon.stratos.deployment.SuperTenantRolePlayer;
import org.wso2.carbon.stratos.deployment.internal.DataHolder;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.stratos.deployment.internal.CloudDeploymentServiceComponent", immediate=true)
public class CloudDeploymentServiceComponent {
    private static final Log log = LogFactory.getLog(CloudDeploymentServiceComponent.class);

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            ConfigurationContext configContext = DataHolder.getInstance().getServerConfigContext();
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("org.apache.axis2.osgi.config.service", AxisObserver.class.getName());
            ctxt.getBundleContext().registerService(AxisObserver.class.getName(), (Object)new CloudDeploymentInterceptor(), props);
            AxisConfiguration axisConfiguration = configContext.getAxisConfiguration();
            axisConfiguration.addParameter(new Parameter("rolePlayer", (Object)new SuperTenantRolePlayer()));
        }
        catch (Exception e) {
            log.error((Object)"CloudDeploymentServiceComponent activation failed", (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        DataHolder.getInstance().setServerConfigContext(contextService.getServerConfigContext());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        DataHolder.getInstance().setServerConfigContext(null);
    }
}

