/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.event.ws.internal.receivers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.event.core.EventBroker;
import org.wso2.carbon.registry.event.core.Message;
import org.wso2.carbon.registry.event.core.exception.EventBrokerException;
import org.wso2.carbon.registry.event.core.subscription.Subscription;
import org.wso2.carbon.registry.event.ws.internal.WSEventBrokerHolder;
import org.wso2.carbon.registry.event.ws.internal.builders.GetStatusCommandBuilder;
import org.wso2.carbon.registry.event.ws.internal.builders.GetSubscriptionsCommandBuilder;
import org.wso2.carbon.registry.event.ws.internal.builders.RenewCommandBuilder;
import org.wso2.carbon.registry.event.ws.internal.builders.SubscribeCommandBuilder;
import org.wso2.carbon.registry.event.ws.internal.builders.UnSubscribeCommandBuilder;
import org.wso2.carbon.registry.event.ws.internal.builders.exceptions.InvalidExpirationTimeException;
import org.wso2.carbon.registry.event.ws.internal.builders.exceptions.InvalidMessageException;
import org.wso2.carbon.registry.event.ws.internal.builders.utils.BuilderUtils;
import org.wso2.carbon.registry.event.ws.internal.exception.WSEventException;
import org.wso2.carbon.registry.event.ws.internal.util.EventBrokerUtils;
import org.wso2.carbon.registry.event.ws.internal.util.EventingConstants;

public class CarbonEventingMessageReceiver
extends AbstractMessageReceiver {
    private static final Log log = LogFactory.getLog(CarbonEventingMessageReceiver.class);
    private static final String ENABLE_SUBSCRIBE = "enableSubscribe";
    private static final String ENABLE_UNSUBSCRIBE = "enableUnsubscribe";
    private static final String ENABLE_RENEW = "enableRenew";
    private static final String ENABLE_GET_STATUS = "enableGetStatus";
    private static final Pattern TO_ADDRESS_PATTERN = Pattern.compile("/services/.*/publish/(.*)");

    private boolean isEnabled(MessageContext mc, String operation) {
        if (mc.getAxisService() != null) {
            String operationValue = (String)mc.getAxisService().getParameterValue(operation);
            return operationValue == null || !operationValue.toLowerCase().equals(Boolean.toString(false));
        }
        return true;
    }

    public final void invokeBusinessLogic(MessageContext mc) throws AxisFault {
        try {
            this.processMessage(mc);
        }
        catch (WSEventException e) {
            log.error((Object)"An exception occured. Unable to Process Request", (Throwable)e);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String details = sw.toString();
            pw.close();
            SOAPEnvelope soapEnvelope = BuilderUtils.genFaultResponse("Receiver", "EventSourceUnableToProcess", e.getMessage(), details, mc.isSOAP11());
            this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", mc, true);
        }
    }

    protected void handleSubscribe(MessageContext mc) throws AxisFault, WSEventException {
        try {
            SOAPEnvelope soapEnvelope;
            if (!this.isEnabled(mc, ENABLE_SUBSCRIBE)) {
                log.warn((Object)"Subscribe operation is disabled");
                return;
            }
            Subscription subscription = null;
            SubscribeCommandBuilder builder = new SubscribeCommandBuilder(mc);
            try {
                subscription = builder.toSubscription(mc.getEnvelope());
                subscription.setOwner(EventBrokerUtils.getLoggedInUserName());
            }
            catch (InvalidExpirationTimeException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e.getMessage());
                }
                soapEnvelope = BuilderUtils.genFaultResponse("Receiver", "InvalidExpirationTime", e.getMessage(), "", mc.isSOAP11());
                this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", mc, true);
            }
            catch (InvalidMessageException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e.getMessage());
                }
                soapEnvelope = BuilderUtils.genFaultResponse("Receiver", "InvalidMessage", e.getMessage(), "", mc.isSOAP11());
                this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", mc, true);
            }
            if (subscription != null) {
                String toAddress = mc.getOptions().getTo().getAddress();
                String topicName = subscription.getEventFilter().getValue();
                if ((topicName == null || topicName.equals("")) && toAddress.indexOf("RegistryEventBrokerService/") > 0) {
                    topicName = toAddress.substring(toAddress.indexOf("RegistryEventBrokerService/") + "RegistryEventBrokerService".length() + 1);
                }
                subscription.setTopicName(topicName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Subscription request recieved  : " + subscription.getId()));
                }
                if (subscription.getEventSinkURL().startsWith("sqs://")) {
                    subscription.setEventDispatcherName("EventSinkDispatcher");
                } else {
                    subscription.setEventDispatcherName("wsEventDispatcher");
                }
                String subID = WSEventBrokerHolder.getInstance().getEventBroker().subscribe(subscription);
                subscription.setId(subID);
                if (subID != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Sending subscription response for Subscription ID : " + subscription.getId()));
                    }
                    SOAPEnvelope soapEnvelope2 = builder.fromSubscription(subscription);
                    this.dispatchResponse(soapEnvelope2, "http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscribeResponse", mc, false);
                } else {
                    log.debug((Object)"Subscription Failed, sending fault response");
                    SOAPEnvelope soapEnvelope3 = BuilderUtils.genFaultResponse("Receiver", "EventSourceUnableToProcess", "Unable to subscribe ", "", mc.isSOAP11());
                    this.dispatchResponse(soapEnvelope3, "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", mc, true);
                }
            } else {
                log.debug((Object)"Subscription Failed, sending fault response");
                SOAPEnvelope soapEnvelope4 = BuilderUtils.genFaultResponse("Receiver", "EventSourceUnableToProcess", "Unable to subscribe ", "", mc.isSOAP11());
                this.dispatchResponse(soapEnvelope4, "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", mc, true);
            }
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            if (errorMessage.contains("errorCode=UNAUTHORIZED_ACCESS")) {
                String user = EventBrokerUtils.getLoggedInUserName();
                errorMessage = user + " does not has permission to perform subscription, please check permissions";
            }
            throw new WSEventException(errorMessage, e);
        }
    }

    protected void handleUnsubscribe(MessageContext mc) throws AxisFault, WSEventException {
        if (!this.isEnabled(mc, ENABLE_UNSUBSCRIBE)) {
            log.warn((Object)"Unsubscribe operation is disabled");
            return;
        }
        try {
            UnSubscribeCommandBuilder builder = new UnSubscribeCommandBuilder(mc);
            Subscription subscription = builder.toSubscription(mc.getEnvelope());
            if (log.isDebugEnabled()) {
                log.debug((Object)("UnSubscribe response recived for Subscription ID : " + subscription.getId()));
            }
            this.getBrokerService().unsubscribe(subscription.getId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending UnSubscribe responce for Subscription ID : " + subscription.getId()));
            }
            SOAPEnvelope soapEnvelope = builder.fromSubscription(subscription);
            this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/eventing/UnsubscribeResponse", mc, false);
        }
        catch (InvalidMessageException e) {
            throw new WSEventException("Invalid message ", e);
        }
        catch (EventBrokerException e) {
            log.debug((Object)"UnSubscription failed, sending fault repsponse");
            SOAPEnvelope soapEnvelope = BuilderUtils.genFaultResponse("Receiver", "EventSourceUnableToProcess", "Unable to Unsubscribe", "", mc.isSOAP11());
            this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", mc, true);
        }
    }

    protected void handleGetStatus(MessageContext mc) throws AxisFault, WSEventException {
        if (!this.isEnabled(mc, ENABLE_GET_STATUS)) {
            log.warn((Object)"Get Status operation is disabled");
            return;
        }
        try {
            GetStatusCommandBuilder builder = new GetStatusCommandBuilder(mc);
            Subscription subscription = builder.toSubscription(mc.getEnvelope());
            if (log.isDebugEnabled()) {
                log.debug((Object)("GetStatus request recived for Subscription ID : " + subscription.getId()));
            }
            if ((subscription = this.getBrokerService().getSubscription(subscription.getId())) != null) {
                String loggedInUser = EventBrokerUtils.getLoggedInUserName();
                if (!loggedInUser.equals("admin") && !loggedInUser.equals(subscription.getOwner())) {
                    throw new WSEventException("User " + loggedInUser + " does not own subscription " + subscription.getId());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending GetStatus responce for Subscription ID : " + subscription.getId()));
                }
                SOAPEnvelope soapEnvelope = builder.fromSubscription(subscription);
                this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatusResponse", mc, false);
            } else {
                log.debug((Object)"GetStatus failed, sending fault response");
                SOAPEnvelope soapEnvelope = BuilderUtils.genFaultResponse("Receiver", "EventSourceUnableToProcess", "Subscription Not Found", "", mc.isSOAP11());
                this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", mc, true);
            }
        }
        catch (InvalidMessageException e) {
            throw new WSEventException("Invalid message exception ", e);
        }
        catch (EventBrokerException e) {
            throw new WSEventException("Event processing exception ", e);
        }
    }

    protected void handleRenew(MessageContext mc) throws AxisFault, WSEventException {
        SOAPEnvelope soapEnvelope;
        SOAPEnvelope soapEnvelope2;
        if (!this.isEnabled(mc, ENABLE_RENEW)) {
            log.warn((Object)"Renew operation is disabled");
            return;
        }
        RenewCommandBuilder builder = new RenewCommandBuilder(mc);
        Subscription subscription = null;
        try {
            subscription = builder.toSubscription(mc.getEnvelope());
        }
        catch (InvalidExpirationTimeException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            soapEnvelope2 = BuilderUtils.genFaultResponse("Receiver", "InvalidExpirationTime", e.getMessage(), "", mc.isSOAP11());
            this.dispatchResponse(soapEnvelope2, "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", mc, true);
        }
        catch (InvalidMessageException e) {
            e.printStackTrace();
        }
        if (subscription != null && subscription.getId() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Renew request recived for Subscription ID : " + subscription.getId()));
            }
            try {
                this.getBrokerService().renewSubscription(subscription);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending Renew response for Subscription ID : " + subscription.getId()));
                }
                soapEnvelope = builder.fromSubscription(subscription);
                this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/eventing/RenewResponse", mc, false);
            }
            catch (EventBrokerException e) {
                log.debug((Object)"Renew failed, sending fault response");
                soapEnvelope2 = BuilderUtils.genFaultResponse("Receiver", "UnableToRenew", "Subscription Not Found", "", mc.isSOAP11());
                this.dispatchResponse(soapEnvelope2, "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", mc, true);
            }
        } else {
            soapEnvelope = BuilderUtils.genFaultResponse("Receiver", "UnableToRenew", "Subscription Not Found", "", mc.isSOAP11());
            this.dispatchResponse(soapEnvelope, "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", mc, true);
        }
    }

    protected void handleGetSubscriptions(MessageContext mc) throws WSEventException {
        try {
            OMElement sortingInstructionsEle;
            OMElement element = mc.getEnvelope().getBody().getFirstElement();
            String maxResultCountStr = element.getAttributeValue(new QName("maxResultCount"));
            String resultFilterStr = element.getAttributeValue(new QName("resultFilter"));
            String firstIndexStr = element.getAttributeValue(new QName("firstIndex"));
            boolean ascending = true;
            String sortingInstructions = null;
            if (mc.getEnvelope().getHeader() != null && (sortingInstructionsEle = mc.getEnvelope().getHeader().getFirstChildWithName(EventingConstants.SORTING_DATA)) != null) {
                sortingInstructions = sortingInstructionsEle.getText();
                String style = sortingInstructionsEle.getAttributeValue(new QName("style"));
                ascending = style == null || !style.equals(EventingConstants.SORTING_STYLES.decending.toString());
            }
            int maxResultCount = Integer.MAX_VALUE;
            if (maxResultCountStr != null && (maxResultCount = Integer.parseInt(maxResultCountStr)) < 0) {
                maxResultCount = Integer.MAX_VALUE;
            }
            int firstIndex = 0;
            if (firstIndexStr != null) {
                firstIndex = Integer.parseInt(firstIndexStr);
            }
            String loggedInUser = EventBrokerUtils.getLoggedInUserName();
            ArrayList<Subscription> filteredSubscriptions = new ArrayList<Subscription>();
            List<Subscription> subscriptions = this.getBrokerService().getAllSubscriptions(resultFilterStr);
            subscriptions = this.sortResults(sortingInstructions, ascending, subscriptions);
            for (Subscription subscription : subscriptions) {
                if (!loggedInUser.equals("admin") && !loggedInUser.equals(subscription.getOwner())) continue;
                filteredSubscriptions.add(subscription);
            }
            SOAPEnvelope getSubscriptionsResponseEnv = GetSubscriptionsCommandBuilder.buildResponseforGetSubscriptions(filteredSubscriptions, maxResultCount, firstIndex);
            this.dispatchResponse(getSubscriptionsResponseEnv, "http://schemas.xmlsoap.org/ws/2004/08/eventing/RenewResponse", mc, false);
        }
        catch (AxisFault e) {
            throw new WSEventException("Error at Get Subscriptions:" + e.getMessage(), e);
        }
        catch (EventBrokerException e) {
            throw new WSEventException("Can not get the subscriptions ", e);
        }
    }

    protected void handleInstallEventSink(MessageContext mc) throws WSEventException {
        throw new UnsupportedOperationException();
    }

    protected void handleEvent(MessageContext mc) throws AxisFault, WSEventException {
        String topic = EventBrokerUtils.extractTopicFromMessage(mc);
        if (topic == null) {
            return;
        }
        try {
            Message message = new Message();
            message.setMessage(mc.getEnvelope().getBody().getFirstElement());
            this.getBrokerService().publishRobust(message, topic);
        }
        catch (EventBrokerException e) {
            throw new WSEventException("Can not publish the message : " + e.getMessage(), e);
        }
    }

    public final void processMessage(MessageContext mc) throws AxisFault, WSEventException {
        if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/Subscribe".equals(mc.getWSAAction())) {
            this.handleSubscribe(mc);
        } else if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/Unsubscribe".equals(mc.getWSAAction())) {
            this.handleUnsubscribe(mc);
        } else if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatus".equals(mc.getWSAAction())) {
            this.handleGetStatus(mc);
        } else if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/Renew".equals(mc.getWSAAction())) {
            this.handleRenew(mc);
        } else if ("http://ws.apache.org/ws/2007/05/eventing-extended/getSubscriptions".equals(mc.getWSAAction())) {
            this.handleGetSubscriptions(mc);
        } else if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/installEventSink".equals(mc.getWSAAction())) {
            this.handleInstallEventSink(mc);
        } else {
            this.handleEvent(mc);
        }
    }

    private void dispatchResponse(SOAPEnvelope soapEnvelope, String responseAction, MessageContext mc, boolean isFault) throws AxisFault {
        MessageContext rmc = MessageContextBuilder.createOutMessageContext((MessageContext)mc);
        rmc.getOperationContext().addMessageContext(rmc);
        this.replicateState(mc);
        rmc.setEnvelope(soapEnvelope);
        rmc.setWSAAction(responseAction);
        rmc.setSoapAction(responseAction);
        if (isFault) {
            AxisEngine.sendFault((MessageContext)rmc);
        } else {
            AxisEngine.send((MessageContext)rmc);
        }
    }

    private EventBroker getBrokerService() {
        return WSEventBrokerHolder.getInstance().getEventBroker();
    }

    public List<Subscription> sortResults(String sortingInstructions, final boolean ascending, List<Subscription> list) {
        if (sortingInstructions != null) {
            Comparator<Subscription> comparator = null;
            if (sortingInstructions.equals("eventSinkAddress")) {
                comparator = new Comparator<Subscription>(){

                    @Override
                    public int compare(Subscription o1, Subscription o2) {
                        if (o2 == null || o1 == null) {
                            return 0;
                        }
                        return (ascending ? 1 : -1) * o1.getEventSinkURL().compareTo(o2.getEventSinkURL());
                    }
                };
            } else if (sortingInstructions.equals("createdTime")) {
                comparator = new Comparator<Subscription>(){

                    @Override
                    public int compare(Subscription o1, Subscription o2) {
                        if (o2 == null || o1 == null) {
                            return 0;
                        }
                        return (ascending ? 1 : -1) * o1.getCreatedTime().compareTo(o2.getCreatedTime());
                    }
                };
            } else if (sortingInstructions.equals("subscriptionEndingTime")) {
                comparator = new Comparator<Subscription>(){

                    @Override
                    public int compare(Subscription o1, Subscription o2) {
                        if (o2 == null || o1 == null) {
                            return 0;
                        }
                        return (ascending ? 1 : -1) * o1.getExpires().compareTo(o2.getExpires());
                    }
                };
            }
            if (comparator != null) {
                Collections.sort(list, comparator);
            }
        }
        return list;
    }
}

