/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.event.ws.internal.builders;

import java.util.Calendar;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.wso2.carbon.registry.event.core.subscription.Subscription;

public class GetSubscriptionsCommandBuilder {
    private static SOAPFactory fac = OMAbstractFactory.getSOAP12Factory();

    public static SOAPEnvelope buildResponseforGetSubscriptions(List<Subscription> subscriptions, int maxResultCount, int startIndex) {
        OMNamespace wseexns = fac.createOMNamespace("http://ws.apache.org/ws/2007/05/eventing-extended", "wseex");
        OMElement response = fac.createOMElement("getSubscriptionsResponse", wseexns);
        int addedCount = 0;
        for (int i = startIndex; i < Math.min(subscriptions.size(), startIndex + maxResultCount); ++i) {
            Calendar calendar;
            Subscription subscription = subscriptions.get(i);
            OMElement subsciptionEle = fac.createOMElement("subscriptionDetail", wseexns, (OMContainer)response);
            fac.createOMElement("subscriptionId", wseexns, (OMContainer)subsciptionEle).setText(subscription.getId());
            fac.createOMElement("eventSinkAddress", wseexns, (OMContainer)subsciptionEle).setText(subscription.getEventSinkURL());
            if (subscription.getExpires() != null) {
                calendar = Calendar.getInstance();
                calendar.setTimeInMillis(subscription.getExpires().getTimeInMillis());
                fac.createOMElement("subscriptionEndingTime", wseexns, (OMContainer)subsciptionEle).setText(ConverterUtil.convertToString((Calendar)calendar));
            }
            fac.createOMElement("topic", wseexns, (OMContainer)subsciptionEle).setText(subscription.getTopicName());
            if (subscription.getCreatedTime() != null) {
                calendar = Calendar.getInstance();
                calendar.setTimeInMillis(subscription.getCreatedTime().getTime());
                fac.createOMElement("createdTime", wseexns, (OMContainer)subsciptionEle).setText(ConverterUtil.convertToString((Calendar)calendar));
            }
            ++addedCount;
        }
        response.addAttribute("allRequestCount", String.valueOf(subscriptions.size()), null);
        if (startIndex + maxResultCount < subscriptions.size()) {
            response.addAttribute("hasMoreResults", "true", null);
        }
        SOAPEnvelope envelope = fac.getDefaultEnvelope();
        envelope.getBody().addChild((OMNode)response);
        return envelope;
    }
}

