/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.forgerock.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.wso2.carbon.apimgt.api.model.ConfigurationDto;
import org.wso2.carbon.apimgt.api.model.KeyManagerConnectorConfiguration;
import org.wso2.forgerock.client.ForgerockJWTValidatoImpl;
import org.wso2.forgerock.client.ForgerockOAuthClient;

@Component(name="forgerock.configuration.component", immediate=true, service={KeyManagerConnectorConfiguration.class})
public class ForgerockConnectorConfiguration
implements KeyManagerConnectorConfiguration {
    public String getImplementation() {
        return ForgerockOAuthClient.class.getName();
    }

    public String getJWTValidator() {
        return ForgerockJWTValidatoImpl.class.getName();
    }

    public List<ConfigurationDto> getConnectionConfigurations() {
        ArrayList<ConfigurationDto> configurationDtoList = new ArrayList<ConfigurationDto>();
        configurationDtoList.add(new ConfigurationDto("client_id", "Client ID", "input", "Client ID of service Application", "", true, false, Collections.emptyList(), false));
        configurationDtoList.add(new ConfigurationDto("client_secret", "Client Secret", "input", "Client Secret of service Application", "", true, true, Collections.emptyList(), false));
        return configurationDtoList;
    }

    public List<ConfigurationDto> getApplicationConfigurations() {
        ArrayList<ConfigurationDto> configurationDtoList = new ArrayList<ConfigurationDto>();
        configurationDtoList.add(new ConfigurationDto("application_type", "Application Type", "select", "Type Of Application to create", "web", false, false, Arrays.asList("web", "native", "service", "browser"), false));
        configurationDtoList.add(new ConfigurationDto("response_types", "Response Type", "select", "Type Of Token response", "", false, false, Arrays.asList("code", "token", "id_token"), true));
        configurationDtoList.add(new ConfigurationDto("access_token_lifetime", "Access Token Lifetime", "input", "Life Time of the Access Token", "0", false, false, Collections.emptyList(), false));
        configurationDtoList.add(new ConfigurationDto("refresh_token_lifetime", "Refresh Token Lifetime", "input", "Life Time of the Refresh Token", "0", false, false, Collections.emptyList(), false));
        configurationDtoList.add(new ConfigurationDto("authorization_code_lifetime", "Authorization code Lifetime", "input", "Life Time of the Authorization code", "0", false, false, Collections.emptyList(), false));
        configurationDtoList.add(new ConfigurationDto("token_endpoint_auth_method", "Token endpoint Authentication Method", "select", "How to Authenticate Token Endpoint", "client_secret_basic", false, true, Arrays.asList("client_secret_basic", "client_secret_post", "client_secret_jwt"), false));
        return configurationDtoList;
    }

    public String getType() {
        return "Forgerock";
    }

    public String getDefaultScopesClaim() {
        return "scp";
    }

    public String getDefaultConsumerKeyClaim() {
        return "aud";
    }
}

