/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.statistics.ui;

import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.statistics.stub.client.EventStatisticsAdminServiceStub;

public class EventStatisticsAdminClient {
    private static final Log log = LogFactory.getLog(EventStatisticsAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.event.statistics.ui.i18n.Resources";
    private EventStatisticsAdminServiceStub stub;
    private ResourceBundle bundle;

    public EventStatisticsAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "EventStatisticsAdminService";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new EventStatisticsAdminServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public EventStatisticsAdminServiceStub.StatsDTO getGlobalCount() throws RemoteException {
        try {
            return this.stub.getGlobalCount();
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.event.stats"), e);
            return null;
        }
    }

    public EventStatisticsAdminServiceStub.StatsDTO getCategoryCount(String categoryName) throws RemoteException {
        try {
            return this.stub.getCategoryCount(categoryName);
        }
        catch (RemoteException e) {
            this.handleException(MessageFormat.format(this.bundle.getString("cannot.get.event.category.stats"), categoryName), e);
            return null;
        }
    }

    public EventStatisticsAdminServiceStub.StatsDTO getDeploymentCount(String categoryName, String deploymentName) throws RemoteException {
        try {
            return this.stub.getDeploymentCount(categoryName, deploymentName);
        }
        catch (RemoteException e) {
            this.handleException(MessageFormat.format(this.bundle.getString("cannot.get.event.deployment.stats"), categoryName, deploymentName), e);
            return null;
        }
    }

    public EventStatisticsAdminServiceStub.StatsDTO getElementCount(String categoryName, String deploymentName, String elementName) throws RemoteException {
        try {
            return this.stub.getElementCount(categoryName, deploymentName, elementName);
        }
        catch (RemoteException e) {
            this.handleException(MessageFormat.format(this.bundle.getString("cannot.get.event.element.stats"), categoryName, deploymentName, elementName), e);
            return null;
        }
    }

    private void handleException(String msg, Exception e) throws RemoteException {
        log.error((Object)msg, (Throwable)e);
        throw new RemoteException(msg, e);
    }
}

