/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.websocket.local.internal;

import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.websocket.local.WebsocketLocalInputCallbackRegisterService;

public class WebsocketLocalInputCallbackRegisterServiceImpl
implements WebsocketLocalInputCallbackRegisterService {
    private ConcurrentHashMap<Integer, ConcurrentHashMap<String, InputEventAdapterListener>> inputEventAdaptorListenerMap = new ConcurrentHashMap();

    @Override
    public void subscribeAdapterListener(String adaptorName, InputEventAdapterListener eventAdapterListener) {
        int tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ConcurrentHashMap<String, Object> tenantSpecificAdaptorMap = this.inputEventAdaptorListenerMap.get(tenantID);
        if (tenantSpecificAdaptorMap == null) {
            tenantSpecificAdaptorMap = new ConcurrentHashMap();
            if (null != this.inputEventAdaptorListenerMap.putIfAbsent(tenantID, tenantSpecificAdaptorMap)) {
                tenantSpecificAdaptorMap = this.inputEventAdaptorListenerMap.get(tenantID);
            }
        }
        tenantSpecificAdaptorMap.putIfAbsent(adaptorName, eventAdapterListener);
    }

    @Override
    public void unsubscribeAdapterListener(String adaptorName) {
        int tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ConcurrentHashMap<String, InputEventAdapterListener> tenantSpecificAdaptorMap = this.inputEventAdaptorListenerMap.get(tenantID);
        tenantSpecificAdaptorMap.remove(adaptorName);
        if (tenantSpecificAdaptorMap.size() == 0) {
            this.inputEventAdaptorListenerMap.remove(tenantID);
        }
    }

    @Override
    public InputEventAdapterListener getAdapterListener(String adaptorName) {
        int tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ConcurrentHashMap<String, InputEventAdapterListener> tenantSpecificAdaptorMap = this.inputEventAdaptorListenerMap.get(tenantID);
        if (tenantSpecificAdaptorMap != null) {
            return tenantSpecificAdaptorMap.get(adaptorName);
        }
        return null;
    }
}

