/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.websocket.local;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.core.Property;
import org.wso2.carbon.event.input.adapter.websocket.local.WebsocketLocalEventAdapter;
import org.wso2.carbon.utils.CarbonUtils;

public class WebsocketLocalEventAdapterFactory
extends InputEventAdapterFactory {
    ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.input.adapter.websocket.local.i18n.Resources", Locale.getDefault());
    private int httpPort;
    private int httpsPort;
    private int portOffset = this.getPortOffset();

    public WebsocketLocalEventAdapterFactory() {
        this.httpPort = 9763 + this.portOffset;
        this.httpsPort = 9443 + this.portOffset;
    }

    public String getType() {
        return "websocket-local";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportInputMessageTypes = new ArrayList<String>();
        supportInputMessageTypes.add("xml");
        supportInputMessageTypes.add("json");
        supportInputMessageTypes.add("text");
        return supportInputMessageTypes;
    }

    public List<Property> getPropertyList() {
        return null;
    }

    public String getUsageTips() {
        return this.resourceBundle.getString("websocket.local.usage.tips.prefix") + this.httpPort + this.resourceBundle.getString("websocket.local.usage.tips.mid") + this.httpsPort + this.resourceBundle.getString("websocket.local.usage.tips.postfix");
    }

    public InputEventAdapter createEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new WebsocketLocalEventAdapter(eventAdapterConfiguration, globalProperties);
    }

    private int getPortOffset() {
        return CarbonUtils.getPortFromServerConfig((String)"Ports.Offset") + 1;
    }
}

