/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.lcm.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.lcm.stub.LifeCycleManagementServiceStub;
import org.wso2.carbon.registry.common.utils.CommonUtil;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.pagination.PaginationUtils;
import org.wso2.carbon.ui.CarbonUIUtil;

public class LifeCycleManagementServiceClient {
    private static final Log log = LogFactory.getLog(LifeCycleManagementServiceClient.class);
    private LifeCycleManagementServiceStub stub;
    private String epr;

    public LifeCycleManagementServiceClient(String cookie, ServletConfig config, HttpSession session) throws RegistryException {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "LifeCycleManagementService";
        try {
            this.stub = new LifeCycleManagementServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate life cycle service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public String[] getLifeCycleList(HttpServletRequest request) throws Exception {
        String[] output;
        try {
            output = this.stub.getLifecycleList();
        }
        catch (Exception e) {
            if (e instanceof RegistryException) {
                return new String[0];
            }
            throw e;
        }
        return output;
    }

    public String getLifeCycleConfiguration(HttpServletRequest request) throws Exception {
        String output;
        String lifecycleName = request.getParameter("lifecycleName");
        try {
            output = this.stub.getLifecycleConfiguration(lifecycleName);
            String version = this.stub.getLifecycleConfigurationVersion(lifecycleName);
            request.getSession().setAttribute("resourceVersion", (Object)version);
        }
        catch (Exception e) {
            if (e instanceof RegistryException) {
                return "";
            }
            throw e;
        }
        return output;
    }

    public boolean newLifeCycle(HttpServletRequest request) throws Exception {
        String payload = request.getParameter("payload");
        boolean output = false;
        try {
            if (this.stub.parseConfiguration(payload)) {
                output = this.stub.createLifecycle(payload);
            }
        }
        catch (Exception e) {
            if (e instanceof RegistryException) {
                return false;
            }
            throw e;
        }
        return output;
    }

    public boolean updateLifeCycle(HttpServletRequest request) throws Exception {
        boolean output;
        String lifecycleName = request.getParameter("lifecycleName");
        String updateOverride = request.getParameter("updateOverride");
        if (lifecycleName == null) {
            lifecycleName = "";
        }
        String payload = request.getParameter("payload");
        try {
            if (!this.stub.parseConfiguration(payload)) {
                return false;
            }
            String latestVersion = this.stub.getLifecycleConfigurationVersion(lifecycleName);
            if (!updateOverride.equals("true") && !CommonUtil.isLatestVersion((String)((String)request.getSession().getAttribute("resourceVersion")), (String)latestVersion)) {
                throw new Exception("Lifecycle resource has already modified ");
            }
            output = this.stub.updateLifecycle(lifecycleName, payload);
        }
        catch (Exception e) {
            if (e instanceof RegistryException) {
                return false;
            }
            log.error((Object)e);
            throw e;
        }
        return output;
    }

    public boolean deleteLifeCycle(HttpServletRequest request) throws Exception {
        boolean output;
        String lifecycleName = request.getParameter("lifecycleName");
        try {
            output = this.stub.deleteLifecycle(lifecycleName);
        }
        catch (Exception e) {
            if (e instanceof RegistryException) {
                return false;
            }
            throw e;
        }
        return output;
    }

    public boolean isLifeCycleNameInUse(HttpServletRequest request) throws Exception {
        String lifeCycleName = request.getParameter("lifecycleName");
        return this.isLifeCycleNameInUse(lifeCycleName);
    }

    public boolean isLifeCycleNameInUse(String lifeCycleName) throws Exception {
        int rowCount;
        boolean output;
        try {
            PaginationContext.init((int)0, (int)1, (String)"", (String)"", (int)1);
            PaginationUtils.copyPaginationContext((ServiceClient)this.stub._getServiceClient());
            output = this.stub.isLifecycleNameInUse(lifeCycleName);
            rowCount = PaginationUtils.getRowCount((ServiceClient)this.stub._getServiceClient());
        }
        catch (Exception e) {
            if (e instanceof RegistryException) {
                return false;
            }
            throw e;
        }
        return output ? output : rowCount > 0;
    }
}

