/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.provider.dto.OpenIDParameterDTO;
import org.wso2.carbon.identity.provider.openid.client.OpenIDAdminClient;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OpenIDUtil {
    private static final Set<Character> UNRESERVED_CHARACTERS = new HashSet<Character>();
    private static final Log log = LogFactory.getLog(OpenIDUtil.class);

    private OpenIDUtil() {
    }

    public static String getUserName(String rquestUrl) throws IdentityException {
        String caller = null;
        String path = null;
        URI uri = null;
        String contextPath = "/openid/";
        try {
            uri = new URI(rquestUrl);
            path = uri.getPath();
        }
        catch (URISyntaxException e) {
            throw IdentityException.error((String)"Invalid OpenID", (Throwable)e);
        }
        caller = path.substring(path.indexOf(contextPath) + contextPath.length(), path.length());
        return caller;
    }

    public static String generateOpenID(String user, String openIDUserUrl) throws IdentityException {
        String openID = null;
        URI uri = null;
        URL url = null;
        String normalizedUser = OpenIDUtil.normalizeUrlEncoding(user);
        openID = String.format(openIDUserUrl, normalizedUser);
        try {
            uri = new URI(openID);
        }
        catch (URISyntaxException e) {
            log.error((Object)("Invalid OpenID URL :" + openID), (Throwable)e);
            throw IdentityException.error((String)"Invalid OpenID URL");
        }
        try {
            url = uri.normalize().toURL();
            if (url.getQuery() != null || url.getRef() != null) {
                log.error((Object)("Invalid user name for OpenID :" + openID));
                throw IdentityException.error((String)"Invalid user name for OpenID");
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)("Malformed OpenID URL :" + openID), (Throwable)e);
            throw IdentityException.error((String)"Malformed OpenID URL");
        }
        openID = url.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("OpenID generated successfully : " + openID));
        }
        return openID;
    }

    private static String normalizeUrlEncoding(String text) {
        if (text == null) {
            return null;
        }
        int len = text.length();
        StringBuilder normalized = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char current = text.charAt(i);
            if (current == '%' && i < len - 2) {
                String percentCode = text.substring(i, i + 3).toUpperCase();
                try {
                    String str = URLDecoder.decode(percentCode, "ISO-8859-1");
                    char chr = str.charAt(0);
                    if (UNRESERVED_CHARACTERS.contains(Character.valueOf(chr))) {
                        normalized.append(chr);
                    } else {
                        normalized.append(percentCode);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    normalized.append(percentCode);
                }
                i += 2;
                continue;
            }
            normalized.append(current);
        }
        return normalized.toString();
    }

    public static String getRelyingPartyUrl(String rpUrl) throws IdentityException {
        URI uri = null;
        URL url = null;
        try {
            uri = new URI(rpUrl);
        }
        catch (URISyntaxException e) {
            log.error((Object)("Invalid relying party URL :" + rpUrl), (Throwable)e);
            throw IdentityException.error((String)"Invalid relying party URL");
        }
        try {
            url = uri.normalize().toURL();
            url = new URL(url.getProtocol().toLowerCase(), url.getHost().toLowerCase(), url.getPort(), url.getPath());
            return url.toString();
        }
        catch (MalformedURLException e) {
            log.error((Object)("Malformed relying party URL :" + rpUrl), (Throwable)e);
            throw IdentityException.error((String)"Malformed relying party URL");
        }
    }

    public static OpenIDParameterDTO[] getOpenIDAuthRequest(ParameterList request) {
        OpenIDParameterDTO[] params = null;
        List list = null;
        list = request.getParameters();
        params = new OpenIDParameterDTO[list.size()];
        int i = 0;
        for (Object object : list) {
            Parameter param = (Parameter)object;
            OpenIDParameterDTO openIDParameterDTO = new OpenIDParameterDTO();
            openIDParameterDTO.setName(param.getKey());
            openIDParameterDTO.setValue(param.getValue());
            params[i++] = openIDParameterDTO;
        }
        return params;
    }

    public static OpenIDParameterDTO[] getOpenIDAuthRequest(HttpServletRequest request) {
        List<OpenIDParameterDTO> params = null;
        params = OpenIDUtil.getOpenIDAuthRequestAsList(request);
        return params.toArray(new OpenIDParameterDTO[params.size()]);
    }

    public static List<OpenIDParameterDTO> getOpenIDAuthRequestAsList(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        ArrayList<OpenIDParameterDTO> params = new ArrayList<OpenIDParameterDTO>();
        for (Map.Entry keyValEntry : parameterMap.entrySet()) {
            String name = (String)keyValEntry.getKey();
            String[] values = (String[])keyValEntry.getValue();
            if (values.length > 1 && name.startsWith("openid.")) {
                throw new IllegalArgumentException("Multiple parameters with the same name: " + values[0]);
            }
            String value = values.length > 0 ? values[0] : null;
            OpenIDParameterDTO param = new OpenIDParameterDTO();
            param.setName(name);
            param.setValue(value);
            params.add(param);
        }
        return params;
    }

    public static String getOpenID(String userName) throws IdentityException {
        return OpenIDUtil.generateOpenID(userName, "");
    }

    public static String getFronEndUrl(String openId, HttpServletRequest request, String relativeUrl) {
        String tenant = MultitenantUtils.getDomainNameFromOpenId((String)openId);
        if (OpenIDUtil.getHostName().equals(tenant)) {
            tenant = null;
        }
        String frontEndUrl = IdentityUtil.getServerURL((String)"/carbon/", (boolean)false, (boolean)true) + relativeUrl;
        if (tenant != null && tenant.trim().length() > 0) {
            return frontEndUrl.replace("/carbon/", "/t/" + tenant + "/carbon/");
        }
        return frontEndUrl;
    }

    public static OpenIDAdminClient getOpenIDAdminClient(HttpSession session) throws AxisFault {
        OpenIDAdminClient client = (OpenIDAdminClient)session.getAttribute("openid_admin_client");
        if (client == null) {
            String serverURL = CarbonUIUtil.getServerURL((ServletContext)session.getServletContext(), (HttpSession)session);
            ConfigurationContext configContext = (ConfigurationContext)session.getServletContext().getAttribute("ConfigurationContext");
            String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
            client = new OpenIDAdminClient(configContext, serverURL, cookie);
            session.setAttribute("openid_admin_client", (Object)client);
        }
        return client;
    }

    private static String getHostName() {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        if (serverConfig.getFirstProperty("HostName") != null) {
            return MultitenantUtils.getDomainNameFromOpenId((String)serverConfig.getFirstProperty("HostName"));
        }
        return "localhost";
    }

    public static String getLoginPageQueryParams(ParameterList params) throws IdentityException {
        String queryParams = null;
        try {
            String realm = params.getParameterValue("openid.realm") != null ? URLEncoder.encode(params.getParameterValue("openid.realm"), StandardCharsets.UTF_8.name()) : "";
            String returnTo = params.getParameterValue("openid.return_to") != null ? URLEncoder.encode(params.getParameterValue("openid.return_to"), StandardCharsets.UTF_8.name()) : "";
            String claimedId = params.getParameterValue("openid.claimed_id") != null ? URLEncoder.encode(params.getParameterValue("openid.claimed_id"), StandardCharsets.UTF_8.name()) : "";
            String identity = params.getParameterValue("openid.identity") != null ? URLEncoder.encode(params.getParameterValue("openid.identity"), StandardCharsets.UTF_8.name()) : "";
            queryParams = "?openid.realm=" + realm + "&" + "openid.return_to" + "=" + returnTo + "&" + "openid.claimed_id" + "=" + claimedId + "&" + "openid.identity" + "=" + identity;
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"UTF-8 encoding is not supported", (Throwable)e);
            throw IdentityException.error((String)"UTF-8 encoding is not supported");
        }
        String username = null;
        if (params.getParameterValue("openid.identity") != null) {
            username = OpenIDUtil.getUserName(params.getParameterValue("openid.identity"));
            queryParams = queryParams + "&" + "userName" + "=" + username;
        }
        return queryParams;
    }

    public static Cookie getCookie(String name, HttpServletRequest req) {
        Cookie[] reqCookies = req.getCookies();
        if (reqCookies != null) {
            for (Cookie cookie : reqCookies) {
                if (!cookie.getName().equalsIgnoreCase(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static void setCookie(String name, String value, int expires, String path, boolean secure, HttpServletResponse resp) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(expires);
        cookie.setPath(path);
        cookie.setSecure(secure);
        cookie.setHttpOnly(true);
        resp.addCookie(cookie);
    }

    public static void deleteCookie(String name, String path, HttpServletRequest request) {
        Cookie[] reqCookies = request.getCookies();
        if (reqCookies != null) {
            for (Cookie cookie : reqCookies) {
                if (!cookie.getName().equals(name) || cookie.getPath() == null || !cookie.getPath().equals(path)) continue;
                cookie.setMaxAge(0);
                break;
            }
        }
    }
}

