/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.replication;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.Association;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.provider.internal.IdentityProviderServiceComponent;
import org.wso2.carbon.identity.provider.openid.replication.AssociationCleanupService;
import org.wso2.carbon.identity.provider.openid.replication.AssociationClusterMessage;

public class OpenIDAssociationReplicationManager {
    private static final Log log = LogFactory.getLog(OpenIDAssociationReplicationManager.class);
    private static OpenIDAssociationReplicationManager associationReplicationManager = new OpenIDAssociationReplicationManager();
    private Map<String, Association> associationMap = new ConcurrentHashMap<String, Association>();

    public OpenIDAssociationReplicationManager() {
        String isCleanupTaskEnabled = "true";
        if (IdentityUtil.getProperty((String)"OpenID.EnableOpenIDAssociationCleanupTask") != null) {
            isCleanupTaskEnabled = IdentityUtil.getProperty((String)"OpenID.EnableOpenIDAssociationCleanupTask");
        }
        if (Boolean.parseBoolean(isCleanupTaskEnabled)) {
            long cleanupPeriod = 15L;
            String associationCleanupPeriod = IdentityUtil.getProperty((String)"OpenID.OpenIDAssociationCleanupPeriod");
            if (StringUtils.isNotBlank((String)associationCleanupPeriod)) {
                try {
                    cleanupPeriod = Long.parseLong(associationCleanupPeriod);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Error while setting association cleanup period as " + associationCleanupPeriod + ". Setting association cleanup period to default (15 mins)"), (Throwable)e);
                }
            }
            AssociationCleanupService sessionCleanUpService = new AssociationCleanupService(cleanupPeriod, cleanupPeriod);
            sessionCleanUpService.activateCleanUp();
        } else {
            log.info((Object)"Association CleanUp Task is not enabled.");
        }
    }

    public static OpenIDAssociationReplicationManager getPersistenceManager() {
        return associationReplicationManager;
    }

    public Map<String, Association> getAssociationMap() {
        return this.associationMap;
    }

    public boolean isExistingSession(String id) {
        return this.associationMap.containsKey(id);
    }

    public void addAssociation(Association association) {
        this.associationMap.put(association.getHandle(), association);
        AssociationClusterMessage associationInfoData = new AssociationClusterMessage(association, false);
        this.replicateAssociationInfo(associationInfoData);
    }

    public Association getAssociation(String handle) {
        return this.associationMap.get(handle);
    }

    public void removeAssociation(String handle) {
        if (this.associationMap.containsKey(handle)) {
            Association association = this.associationMap.get(handle);
            AssociationClusterMessage associationInfoData = new AssociationClusterMessage(association, true);
            this.replicateAssociationInfo(associationInfoData);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Association does not exists. Cannot remove association : " + handle));
        }
    }

    private void replicateAssociationInfo(AssociationClusterMessage associationInfoData) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting to replicate association : " + associationInfoData.getAssociation().getHandle()));
        }
        ClusteringAgent agent = IdentityProviderServiceComponent.getConfigContext().getAxisConfiguration().getClusteringAgent();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clustering Agent: " + agent));
        }
        if (agent != null) {
            try {
                agent.sendMessage((ClusteringMessage)associationInfoData, true);
            }
            catch (ClusteringFault e) {
                log.error((Object)("Unable to send cluster message :" + e.getMessage()), (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Completed replicating association : " + associationInfoData.getAssociation().getHandle()));
        }
    }

    public void removeExpiredAssociations() {
        Date currentTime = new Date();
        for (Map.Entry<String, Association> entry : this.associationMap.entrySet()) {
            Association association = entry.getValue();
            if (!currentTime.after(association.getExpiry())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Current time : " + currentTime.getTime() + ", expiry time : " + association.getExpiry().getTime() + ". Hence removing expired association : " + association.getHandle()));
            }
            this.removeAssociation(association.getHandle());
        }
    }
}

