/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.replication;

import java.io.Serializable;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.Association;
import org.wso2.carbon.identity.provider.openid.replication.OpenIDAssociationReplicationManager;

public class AssociationClusterMessage
extends ClusteringMessage
implements Serializable {
    private static final long serialVersionUID = 3421028095886637679L;
    private static final Log log = LogFactory.getLog(AssociationClusterMessage.class);
    private Association association;
    private boolean isRemove;

    public AssociationClusterMessage(Association association, boolean isRemove) {
        this.setAssociation(association);
        this.setRemove(isRemove);
    }

    public Association getAssociation() {
        return this.association;
    }

    public void setAssociation(Association association) {
        this.association = association;
    }

    public boolean isRemove() {
        return this.isRemove;
    }

    public void setRemove(boolean isRemove) {
        this.isRemove = isRemove;
    }

    public ClusteringCommand getResponse() {
        return null;
    }

    public void execute(ConfigurationContext configCtx) throws ClusteringFault {
        OpenIDAssociationReplicationManager associationReplicationManager = OpenIDAssociationReplicationManager.getPersistenceManager();
        Association association = this.getAssociation();
        if (this.isRemove()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing association : " + association.getHandle() + " during the replication replication"));
            }
            if (associationReplicationManager.isExistingSession(association.getHandle())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Association : " + association.getHandle() + " does exist"));
                }
                associationReplicationManager.getAssociationMap().remove(association.getHandle());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removed association : " + association.getHandle() + " during the replication replication"));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Association : " + association.getHandle() + " does not exist. Cannot remove association"));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding new association : " + association.getHandle() + " during the replication replication"));
            }
            associationReplicationManager.getAssociationMap().put(association.getHandle(), association);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added new association : " + association.getHandle() + " during the replication replication"));
            }
        }
    }
}

