/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.replication;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.provider.openid.replication.OpenIDAssociationReplicationManager;

public class AssociationCleanupService {
    private final ScheduledExecutorService scheduler;
    private final long initialDelay;
    private final long delayBetweenRuns;
    private static final int NUM_THREADS = 1;
    private static final Log log = LogFactory.getLog(AssociationCleanupService.class);

    public AssociationCleanupService(long initialDelay, long delayBetweenRuns) {
        this.initialDelay = initialDelay;
        this.delayBetweenRuns = delayBetweenRuns;
        this.scheduler = Executors.newScheduledThreadPool(1);
    }

    public void activateCleanUp() {
        AssociationCleanupTask associationCleanupTask = new AssociationCleanupTask();
        this.scheduler.scheduleWithFixedDelay(associationCleanupTask, this.initialDelay, this.delayBetweenRuns, TimeUnit.MINUTES);
    }

    private static final class AssociationCleanupTask
    implements Runnable {
        private static final Log log = LogFactory.getLog(AssociationCleanupTask.class);

        private AssociationCleanupTask() {
        }

        @Override
        public void run() {
            log.debug((Object)"Start running the Association cleanup task.");
            OpenIDAssociationReplicationManager.getPersistenceManager().removeExpiredAssociations();
            log.info((Object)"Association cleanup task is completed successfully for removing expired Associations");
        }
    }
}

