/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.AbstractIdentityUserOperationEventListener;
import org.wso2.carbon.identity.core.dao.OpenIDUserRPDAO;
import org.wso2.carbon.identity.core.model.OpenIDUserRPDO;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class IdentityOpenIDUserEventListener
extends AbstractIdentityUserOperationEventListener {
    private static final Log log = LogFactory.getLog(IdentityOpenIDUserEventListener.class);

    public int getExecutionOrderId() {
        int orderId = this.getOrderId();
        if (orderId != -1) {
            return orderId;
        }
        return 70;
    }

    public boolean doPreDeleteUser(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing OpenID related information of the user : " + userName));
        }
        try {
            int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            this.deleteUsersRPs(userName, tenantId);
        }
        catch (IdentityException e) {
            throw new UserStoreException("Error occurred while deleting RP entries in the DB related to the user", (Throwable)e);
        }
        return true;
    }

    private void deleteUsersRPs(String userName, int tenantId) throws IdentityException {
        OpenIDUserRPDAO dao = new OpenIDUserRPDAO();
        OpenIDUserRPDO[] userRPs = dao.getOpenIDUserRPs(userName, tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing " + userRPs.length + " RPs in DB related to the user : " + userName));
        }
        for (int i = 0; i < userRPs.length; ++i) {
            dao.delete(userRPs[i], tenantId);
        }
    }
}

