/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.handlers;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.DirectError;
import org.openid4java.message.ParameterList;
import org.owasp.encoder.Encode;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationRequestCacheEntry;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationResultCacheEntry;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationRequest;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationResult;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.identity.provider.dto.OpenIDAuthRequestDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDAuthResponseDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDParameterDTO;
import org.wso2.carbon.identity.provider.openid.OpenIDUtil;
import org.wso2.carbon.identity.provider.openid.client.OpenIDAdminClient;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;

public class OpenIDHandler {
    private static final String TRUE = "true";
    private static OpenIDHandler provider;
    private static final Log log;
    private String frontEndUrl;
    private String opAddress;

    private OpenIDHandler(String serverUrl) {
        this.opAddress = serverUrl;
    }

    public static OpenIDHandler getInstance(String serverUrl) {
        if (provider == null) {
            provider = new OpenIDHandler(serverUrl);
        }
        return provider;
    }

    public void setFrontEndUrl(String frontEndUrl) {
        this.frontEndUrl = frontEndUrl;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authentication page set to :" + this.frontEndUrl));
        }
    }

    public String getOpAddress() {
        return this.opAddress;
    }

    public String processRequest(HttpServletRequest request, HttpServletResponse response) throws IdentityException {
        if (request.getParameter("logoutUrl") != null) {
            return this.handleSingleLogout(request, response);
        }
        if (request.getAttribute("nonlogin") == null && request.getParameter("sessionDataKey") != null) {
            this.handleRequestFromLoginPage(request, response);
        } else {
            String approval = request.getParameter("hasApprovedAlways");
            if (approval != null) {
                request.getSession().setAttribute("userApprovedAlways", (Object)approval);
                request.getSession().setAttribute("userApproved", (Object)TRUE);
            }
            String responseText = null;
            try {
                HttpSession session = request.getSession();
                OpenIDAdminClient client = org.wso2.carbon.identity.provider.openid.util.OpenIDUtil.getOpenIDAdminClient(session);
                ParameterList paramList = this.getParameterList(request);
                String mode = this.getOpenIDMessageMode(paramList, response, request);
                if ("associate".equals(mode)) {
                    OpenIDParameterDTO[] reqDTO = org.wso2.carbon.identity.provider.openid.util.OpenIDUtil.getOpenIDAuthRequest(request);
                    responseText = client.getOpenIDAssociationResponse(reqDTO);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Association created successfully");
                    }
                } else {
                    if ("checkid_setup".equals(mode) || "checkid_immediate".equals(mode)) {
                        return this.checkSetupOrImmediate(request, response, paramList, client);
                    }
                    if ("check_authentication".equals(mode)) {
                        responseText = client.verify(org.wso2.carbon.identity.provider.openid.util.OpenIDUtil.getOpenIDAuthRequest(request));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Authentication verified successfully");
                        }
                    } else {
                        responseText = this.getErrorResponseText("Not a valid OpenID request");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("No valid MODE found : " + request.getQueryString()));
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to process OpenID client request", (Throwable)e);
                responseText = this.getErrorResponseText(e.getMessage());
            }
            try {
                this.directResponse(response, responseText);
            }
            catch (IOException e) {
                log.error((Object)"Failed to redirect OpenID response", (Throwable)e);
                throw IdentityException.error((String)"OpenID redirect reponse failed");
            }
        }
        return null;
    }

    private String getOpenIDMessageMode(ParameterList paramList, HttpServletResponse response, HttpServletRequest request) throws IOException {
        String mode = null;
        if (paramList == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid OpenID message :" + request.getQueryString()));
            }
            this.directResponse(response, this.getErrorResponseText("Invalid OpenID message"));
            return null;
        }
        String string = mode = paramList.hasParameter("openid.mode") ? paramList.getParameterValue("openid.mode") : null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("OpenID authentication mode :" + mode));
        }
        return mode;
    }

    private ParameterList getParameterList(HttpServletRequest request) {
        if ("authenticated".equals(request.getSession().getAttribute("_action")) || "cancel".equals(request.getSession().getAttribute("_action"))) {
            return (ParameterList)request.getSession().getAttribute("parameterlist");
        }
        return new ParameterList(request.getParameterMap());
    }

    private String handleSingleLogout(HttpServletRequest request, HttpServletResponse response) {
        log.info((Object)("OpenID Single Logout for " + request.getSession().getAttribute("authenticatedOpenID")));
        request.getSession().setAttribute("authenticatedOpenID", null);
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie curCookie = null;
            for (int x = 0; x < cookies.length; ++x) {
                curCookie = cookies[x];
                if (!"openidtoken".equalsIgnoreCase(curCookie.getName())) continue;
                curCookie.setMaxAge(0);
                response.addCookie(curCookie);
                break;
            }
        }
        return request.getParameter("logoutUrl");
    }

    private String checkSetupOrImmediate(HttpServletRequest request, HttpServletResponse response, ParameterList params, OpenIDAdminClient client) throws IdentityProviderException {
        String openIdInSession;
        boolean authenticated = false;
        String profileName = null;
        HttpSession session = request.getSession();
        String claimedID = params.getParameterValue("openid.identity");
        if (claimedID == null) {
            throw new IdentityProviderException("Required attribute openid.identity is missing");
        }
        if (claimedID.endsWith("/openid/") && (openIdInSession = (String)session.getAttribute("openId")) != null && !"".equals(openIdInSession.trim())) {
            claimedID = openIdInSession;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authentication check for user " + claimedID));
        }
        boolean authCompleted = "authenticated".equals(session.getAttribute("_action"));
        boolean approved = TRUE.equals(session.getAttribute("userApproved"));
        if (authCompleted && approved) {
            session.removeAttribute("userApproved");
            session.removeAttribute("_action");
            session.removeAttribute("profile");
            authenticated = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authenticated and user confirmed :" + claimedID));
            }
            if ((profileName = (String)session.getAttribute("profile")) == null) {
                profileName = "default";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Selected profile : " + profileName));
            }
            this.updateRPInfo(claimedID, profileName, params, client, session);
        }
        if ("cancel".equals(session.getAttribute("_action"))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User cancelled :" + claimedID));
            }
            authenticated = false;
        } else if (!authenticated) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(claimedID + " not authenticated. Redirecting for authentication"));
            }
            session.setAttribute("parameterlist", (Object)params);
            try {
                return this.getLoginPageUrl(claimedID, request, params);
            }
            catch (IOException | IdentityException e) {
                throw new IdentityProviderException("Failed to get login page url", e);
            }
        }
        OpenIDAuthRequestDTO openIDAuthRequest = new OpenIDAuthRequestDTO();
        if (TRUE.equals(session.getAttribute("phishingResistanceAuthentication"))) {
            openIDAuthRequest.setPhishiingResistanceAuthRequest(true);
            session.removeAttribute("phishingResistanceAuthentication");
        }
        if (TRUE.equals(session.getAttribute("multifactorlogin"))) {
            openIDAuthRequest.setMultiFactorAuthRequested(true);
            session.removeAttribute("multifactorlogin");
        }
        openIDAuthRequest.setParams(org.wso2.carbon.identity.provider.openid.util.OpenIDUtil.getOpenIDAuthRequest(params));
        openIDAuthRequest.setOpLocalId(claimedID);
        openIDAuthRequest.setUserSelectedClaimedId(claimedID);
        openIDAuthRequest.setAuthenticated(authenticated);
        openIDAuthRequest.setOpenID(claimedID);
        openIDAuthRequest.setProfileName(profileName);
        String authenticatedIdPsParam = "";
        if (session.getAttribute("AuthenticationResult") != null) {
            AuthenticationResult authResult = (AuthenticationResult)session.getAttribute("AuthenticationResult");
            openIDAuthRequest.setResponseClaims(authResult.getSubject().getUserAttributes());
            String authenticatedIdPs = authResult.getAuthenticatedIdPs();
            if (authenticatedIdPs != null && !authenticatedIdPs.isEmpty()) {
                try {
                    authenticatedIdPsParam = "&AuthenticatedIdPs=" + URLEncoder.encode(authenticatedIdPs, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new IdentityProviderException("Url encoding failed", e);
                }
            }
        }
        session.removeAttribute("openId");
        OpenIDAuthResponseDTO openIDAuthResponse = client.getOpenIDAuthResponse(openIDAuthRequest);
        return openIDAuthResponse.getDestinationUrl() + authenticatedIdPsParam;
    }

    private void updateRPInfo(String openId, String profileName, ParameterList params, OpenIDAdminClient client, HttpSession session) throws IdentityProviderException {
        if (!client.isOpenIDUserApprovalBypassEnabled()) {
            boolean alwaysApprovedRp = Boolean.parseBoolean((String)session.getAttribute("userApprovedAlways"));
            client.updateOpenIDUserRPInfo(params.getParameterValue("openid.return_to"), alwaysApprovedRp, profileName, openId);
        }
    }

    private String getLoginPageUrl(String claimedID, HttpServletRequest request, ParameterList params) throws IdentityException, IOException {
        request.getSession().setAttribute("openId", (Object)claimedID);
        String commonAuthURL = IdentityUtil.getServerURL((String)"commonauth", (boolean)false, (boolean)true);
        String selfPath = request.getContextPath();
        String sessionDataKey = UUIDGenerator.generateUUID();
        AuthenticationRequest authenticationRequest = new AuthenticationRequest();
        authenticationRequest.setRelyingParty(this.getRelyingParty(request));
        authenticationRequest.setCommonAuthCallerPath(selfPath);
        String username = null;
        String tenantDomain = null;
        if (params.getParameterValue("openid.identity") != null) {
            username = org.wso2.carbon.identity.provider.openid.util.OpenIDUtil.getUserName(params.getParameterValue("openid.identity"));
            authenticationRequest.addRequestQueryParam("username", new String[]{username});
        }
        if (params.getParameterValue("tenantDomain") != null) {
            tenantDomain = params.getParameterValue("tenantDomain");
            authenticationRequest.setTenantDomain(tenantDomain);
        }
        boolean forceAuthenticate = false;
        if (!claimedID.endsWith("/openid/")) {
            String authenticatedUser = (String)request.getSession().getAttribute("authenticatedOpenID");
            if (log.isDebugEnabled()) {
                log.debug((Object)("claimedID : " + claimedID + ", authenticated user : " + authenticatedUser));
            }
            if (authenticatedUser != null && !"".equals(authenticatedUser.trim()) && !claimedID.equals(authenticatedUser.trim())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Overriding previously authenticated OpenID : " + authenticatedUser + " with the OpenID in the current request :" + claimedID + " and setting forceAuthenticate."));
                }
                forceAuthenticate = true;
            }
        }
        authenticationRequest.setForceAuth(forceAuthenticate);
        authenticationRequest.setRequestQueryParams(request.getParameterMap());
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement().toString();
            authenticationRequest.addHeader(headerName, request.getHeader(headerName));
        }
        AuthenticationRequestCacheEntry authRequest = new AuthenticationRequestCacheEntry(authenticationRequest);
        FrameworkUtils.addAuthenticationRequestToCache((String)sessionDataKey, (AuthenticationRequestCacheEntry)authRequest);
        StringBuilder queryStringBuilder = new StringBuilder();
        queryStringBuilder.append(commonAuthURL).append("?").append("sessionDataKey").append("=").append(URLEncoder.encode(sessionDataKey, "UTF-8")).append("&").append("type").append("=").append("openid");
        return queryStringBuilder.toString();
    }

    private String getErrorResponseText(String message) {
        log.error((Object)message);
        return DirectError.createDirectError((String)message).keyValueFormEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void directResponse(HttpServletResponse httpResp, String response) throws IOException {
        try (ServletOutputStream stream = null;){
            stream = httpResp.getOutputStream();
            stream.write(response.getBytes());
        }
    }

    private void handleRequestFromLoginPage(HttpServletRequest req, HttpServletResponse resp) throws IdentityException {
        try {
            HttpSession session = req.getSession();
            String claimedID = (String)session.getAttribute("openId");
            if (claimedID == null) {
                throw IdentityException.error((String)"No valid OpenID Identifier found. Terminating authentication flow");
            }
            String userName = null;
            AuthenticationResult authnResult = null;
            if (req.getParameter("sessionDataKey") != null) {
                authnResult = this.getAuthenticationResultFromCache(req.getParameter("sessionDataKey"));
            }
            if (claimedID.endsWith("/openid/")) {
                if (authnResult != null && authnResult.isAuthenticated()) {
                    userName = authnResult.getSubject().getAuthenticatedSubjectIdentifier();
                    this.regenerateSession(req);
                    session = req.getSession();
                    session.setAttribute("AuthenticationResult", (Object)authnResult);
                }
                String authenticatedUserName = (String)session.getAttribute("userName");
                if (userName != null && !"".equals(userName.trim())) {
                    if (authenticatedUserName != null && authenticatedUserName.equals(userName)) {
                        log.debug((Object)"Username in request is different from the authenticated username in the session. Starting new session ");
                        session.removeAttribute("userName");
                    }
                    session.setAttribute("userName", (Object)userName);
                    claimedID = claimedID + userName;
                }
            }
            session.setAttribute("openId", (Object)claimedID);
            boolean isAuthenticated = false;
            String authenticatedOpenID = (String)session.getAttribute("authenticatedOpenID");
            if (authenticatedOpenID != null && authenticatedOpenID.equals(claimedID)) {
                isAuthenticated = true;
            }
            OpenIDAdminClient client = org.wso2.carbon.identity.provider.openid.util.OpenIDUtil.getOpenIDAdminClient(session);
            if (!isAuthenticated && authnResult != null) {
                isAuthenticated = authnResult.isAuthenticated();
            }
            if (isAuthenticated) {
                session.setAttribute("authenticatedOpenID", (Object)claimedID);
                if (client.isOpenIDUserApprovalBypassEnabled()) {
                    session.setAttribute("_action", (Object)"authenticated");
                    session.setAttribute("userApproved", (Object)TRUE);
                    session.setAttribute("selectedProfile", (Object)"default");
                    req.setAttribute("nonlogin", (Object)TRUE);
                    RequestDispatcher dispatcher = req.getRequestDispatcher("../../openidserver");
                    dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
                } else {
                    String[] rpInfo = client.getOpenIDUserRPInfo(claimedID, ((ParameterList)session.getAttribute("parameterlist")).getParameterValue("openid.return_to"));
                    if (TRUE.equals(rpInfo[0])) {
                        session.setAttribute("_action", (Object)"authenticated");
                        session.setAttribute("userApproved", (Object)TRUE);
                        session.setAttribute("userApprovedAlways", (Object)TRUE);
                        session.setAttribute("selectedProfile", (Object)rpInfo[1]);
                        req.setAttribute("nonlogin", (Object)TRUE);
                        RequestDispatcher dispatcher = req.getRequestDispatcher("../../openidserver");
                        dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
                    } else {
                        session.setAttribute("_action", (Object)"authenticated");
                        this.sendToApprovalPage(req, resp);
                    }
                }
            } else {
                org.wso2.carbon.identity.provider.openid.util.OpenIDUtil.deleteCookie("openidtoken", "/", req);
                org.wso2.carbon.identity.provider.openid.util.OpenIDUtil.deleteCookie("openidrememberme", "/", req);
                session.removeAttribute("authenticatedOpenID");
                String openIdEndpointUrl = OpenIDUtil.getOpenIDLoginPageURL();
                resp.sendRedirect(openIdEndpointUrl + org.wso2.carbon.identity.provider.openid.util.OpenIDUtil.getLoginPageQueryParams((ParameterList)req.getSession().getAttribute("parameterlist")) + "&errorMsg=error.while.user.auth");
            }
        }
        catch (Exception e) {
            throw IdentityException.error((String)"Exception while handling request from the login page", (Throwable)e);
        }
    }

    private void sendToApprovalPage(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HttpSession session = req.getSession();
        PrintWriter out = resp.getWriter();
        out.println("<html>");
        out.println("<body>");
        out.println("<p>You are now redirected back to Approval Page.");
        out.println(" If the redirection fails, please click the post button.</p>");
        out.println("<form method='post' action='authenticationendpoint/openid_profile.do'>");
        out.println("<p>");
        AuthenticationResult authnResult = null;
        AuthenticatedUser authenticatedUser = null;
        if (req.getParameter("sessionDataKey") != null) {
            authnResult = this.getAuthenticationResultFromCache(req.getParameter("sessionDataKey"));
        }
        if (authnResult != null) {
            authenticatedUser = authnResult.getSubject();
        }
        Map userAttributes = authenticatedUser != null ? authenticatedUser.getUserAttributes() : null;
        out.println("<input type='hidden' name='openid.identity' value='" + Encode.forHtmlAttribute((String)((String)session.getAttribute("authenticatedOpenID"))) + "'>");
        out.println("<input type='hidden' name='openid.return_to' value='" + Encode.forHtmlAttribute((String)((ParameterList)session.getAttribute("parameterlist")).getParameterValue("openid.return_to")) + "'>");
        if (userAttributes != null) {
            for (Map.Entry entry : userAttributes.entrySet()) {
                String value = (String)entry.getValue();
                ClaimMapping claimMapping = (ClaimMapping)entry.getKey();
                if (value == null) continue;
                out.println("<input type='hidden' name='claimTag' value='" + Encode.forHtmlAttribute((String)claimMapping.getLocalClaim().getClaimUri()) + "'>");
                out.println("<input type='hidden' name='claimValue' value='" + Encode.forHtmlAttribute((String)((String)userAttributes.get(claimMapping))) + "'>");
            }
        }
        out.println("<button type='submit'>POST</button>");
        out.println("</p>");
        out.println("</form>");
        out.println("<script type='text/javascript'>");
        out.println("document.forms[0].submit();");
        out.println("</script>");
        out.println("</body>");
        out.println("</html>");
    }

    private AuthenticationResult getAuthenticationResultFromCache(String sessionDataKey) {
        AuthenticationResult authResult = null;
        AuthenticationResultCacheEntry authResultCacheEntry = FrameworkUtils.getAuthenticationResultFromCache((String)sessionDataKey);
        if (authResultCacheEntry != null) {
            authResult = authResultCacheEntry.getResult();
        } else {
            log.error((Object)"Cannot find AuthenticationResult from the cache");
        }
        return authResult;
    }

    private String getRelyingParty(HttpServletRequest request) {
        return request.getParameter("openid.realm");
    }

    private void regenerateSession(HttpServletRequest request) {
        HttpSession oldSession = request.getSession();
        Enumeration<Object> attrNames = oldSession.getAttributeNames();
        Properties props = new Properties();
        while (attrNames != null && attrNames.hasMoreElements()) {
            String key = (String)attrNames.nextElement();
            props.put(key, oldSession.getAttribute(key));
        }
        oldSession.invalidate();
        HttpSession newSession = request.getSession(true);
        attrNames = props.keys();
        while (attrNames != null && attrNames.hasMoreElements()) {
            String key = (String)attrNames.nextElement();
            newSession.setAttribute(key, props.get(key));
        }
    }

    static {
        log = LogFactory.getLog(OpenIDHandler.class);
    }
}

