/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.handlers;

import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.provider.openid.extensions.OpenIDAttributeExchange;
import org.wso2.carbon.identity.provider.openid.extensions.OpenIDExtension;
import org.wso2.carbon.identity.provider.openid.extensions.OpenIDPape;
import org.wso2.carbon.identity.provider.openid.extensions.OpenIDSimpleReg;
import org.wso2.carbon.identity.provider.openid.handlers.OpenIDAuthenticationRequest;

public class OpenIDExtensionFactory {
    private static OpenIDExtensionFactory factory = new OpenIDExtensionFactory();

    private OpenIDExtensionFactory() {
    }

    public static OpenIDExtensionFactory getInstance() {
        return factory;
    }

    public OpenIDExtension getExtension(OpenIDAuthenticationRequest request) throws IdentityException {
        if (request == null) {
            return null;
        }
        String alias = request.getExtensionAlias();
        if ("http://openid.net/srv/ax/1.0".equals(alias) || "http://openid.net/srv/ax/1.0".equals(alias)) {
            return new OpenIDAttributeExchange(request);
        }
        if ("http://openid.net/sreg/1.0".equals(alias) || "http://openid.net/sreg/1.0".equals(alias) || "http://openid.net/extensions/sreg/1.1".equals(alias)) {
            return new OpenIDSimpleReg(request);
        }
        if ("http://specs.openid.net/extensions/pape/1.0".equals(alias)) {
            return new OpenIDPape(request);
        }
        return null;
    }
}

